<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('producto_variants', function (Blueprint $table) {
            $table->string('sku')->nullable()->after('values');
            $table->decimal('price_adjustment', 10, 2)->default(0)->after('sku');
            $table->integer('quantity')->default(0)->after('price_adjustment');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('producto_variants', function (Blueprint $table) {
            $table->dropColumn(['sku', 'price_adjustment', 'quantity']);
        });
    }
};
