<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('producto_variants', function (Blueprint $table) {
            $table->string('image_path')->nullable()->after('values');
            $table->string('image_thumbnail_path')->nullable()->after('image_path');
            $table->string('alt_text')->nullable()->after('image_thumbnail_path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('producto_variants', function (Blueprint $table) {
            $table->dropColumn(['image_path', 'image_thumbnail_path', 'alt_text']);
        });
    }
};
