<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('producto_variants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('producto_id')
                ->constrained('productos')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->string('name'); // Ej: "Color", "Tamaño"
            $table->json('values'); // Ej: ["Rojo", "Azul", "Verde"]
            $table->foreignId('empresa_id')
                ->constrained('empresas')
                ->onUpdate('cascade')
                ->onDelete('cascade');
            $table->timestamps();

            $table->index('producto_id');
            $table->index('empresa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('producto_variants');
    }
};
