<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('batch_movements', function (Blueprint $table) {
            $table->id();
            $table->foreignId('batch_id')->constrained('product_batches')->onDelete('cascade');
            $table->enum('type', ['in', 'out', 'adjustment', 'expired', 'returned']);
            $table->integer('quantity');
            $table->string('reference')->nullable(); // Número de pedido, factura, etc.
            $table->text('reason')->nullable();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('empresa_id')->constrained('empresas');
            $table->timestamps();
            
            $table->index(['batch_id', 'type']);
            $table->index('created_at');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('batch_movements');
    }
};