<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            $table->string('batch_number')->nullable()->after('barcode');
            $table->date('expiry_date')->nullable()->after('batch_number');
            $table->boolean('requires_batch_tracking')->default(false)->after('expiry_date');
        });
    }

    public function down(): void
    {
        Schema::table('productos', function (Blueprint $table) {
            $table->dropColumn(['batch_number', 'expiry_date', 'requires_batch_tracking']);
        });
    }
};