-- Respaldo filtrado por fechas (2025-11-28 a 2025-11-28)
-- Generado: 2025-11-28 13:50:16


-- Estructura de tabla `active_sessions`
DROP TABLE IF EXISTS `active_sessions`;
CREATE TABLE `active_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `last_activity` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `login_at` timestamp NULL DEFAULT NULL,
  `logout_at` timestamp NULL DEFAULT NULL,
  `is_current` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `active_sessions_user_id_session_id_index` (`user_id`,`session_id`),
  CONSTRAINT `active_sessions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `active_sessions` (filtrado)
INSERT INTO `active_sessions` (`id`, `user_id`, `session_id`, `ip_address`, `user_agent`, `location`, `latitude`, `longitude`, `last_activity`, `login_at`, `logout_at`, `is_current`, `is_active`, `created_at`, `updated_at`) VALUES
('14', '2', 'LcHSbQmpzfsgc64cjhZJp1NrNqtzZOpwDnwrHGK9', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, '10.49626410', '-66.88133670', '2025-11-28 13:43:45', NULL, NULL, '0', '1', '2025-11-28 13:43:45', '2025-11-28 13:43:45');


-- Estructura de tabla `activity_log`
DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject_id` bigint unsigned DEFAULT NULL,
  `causer_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` bigint unsigned DEFAULT NULL,
  `properties` json DEFAULT NULL,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla activity_log: Sin datos en el rango de fechas


-- Estructura de tabla `bancos`
DROP TABLE IF EXISTS `bancos`;
CREATE TABLE `bancos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bancos_codigo_unique` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla bancos: Sin datos en el rango de fechas


-- Estructura de tabla `cache`
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache: Sin datos


-- Estructura de tabla `cache_locks`
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache_locks: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache_locks: Sin datos


-- Estructura de tabla `cajas`
DROP TABLE IF EXISTS `cajas`;
CREATE TABLE `cajas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `fecha` date NOT NULL,
  `numero_corte` int NOT NULL DEFAULT '1',
  `monto_inicial` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_efectivo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_transferencias` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_tarjetas` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_ingresos` decimal(10,2) NOT NULL DEFAULT '0.00',
  `monto_final` decimal(10,2) NOT NULL DEFAULT '0.00',
  `estado` enum('abierta','cerrada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'abierta',
  `fecha_apertura` timestamp NOT NULL,
  `fecha_cierre` timestamp NULL DEFAULT NULL,
  `observaciones_apertura` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `observaciones_cierre` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cajas_user_id_foreign` (`user_id`),
  KEY `cajas_fecha_estado_index` (`fecha`,`estado`),
  KEY `cajas_empresa_id_foreign` (`empresa_id`),
  KEY `cajas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `cajas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cajas: Sin datos en el rango de fechas


-- Estructura de tabla `categorias`
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categorias_slug_unique` (`slug`),
  KEY `categorias_empresa_id_foreign` (`empresa_id`),
  KEY `categorias_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `categorias_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categorias_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla categorias: Sin datos en el rango de fechas


-- Estructura de tabla `clientes`
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `documento_identidad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientes_empresa_id_foreign` (`empresa_id`),
  KEY `clientes_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `clientes_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla clientes: Sin datos en el rango de fechas


-- Estructura de tabla `comprobantes`
DROP TABLE IF EXISTS `comprobantes`;
CREATE TABLE `comprobantes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha_emision` datetime NOT NULL,
  `serie` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` json NOT NULL,
  `comprobanteable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobanteable_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `comprobantes_numero_unique` (`numero`),
  KEY `comprobantes_comprobanteable_type_comprobanteable_id_index` (`comprobanteable_type`,`comprobanteable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla comprobantes: Sin datos en el rango de fechas


-- Estructura de tabla `detalle_pedidos`
DROP TABLE IF EXISTS `detalle_pedidos`;
CREATE TABLE `detalle_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `productoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detalle_pedidos_empresaid_foreign` (`empresaId`),
  KEY `detalle_pedidos_userid_foreign` (`userId`),
  KEY `detalle_pedidos_productoid_foreign` (`productoId`),
  KEY `detalle_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `detalle_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_productoid_foreign` FOREIGN KEY (`productoId`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla detalle_pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `empleado_pedido`
DROP TABLE IF EXISTS `empleado_pedido`;
CREATE TABLE `empleado_pedido` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empleadoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleado_pedido_empleadoid_pedidoid_unique` (`empleadoId`,`pedidoId`),
  KEY `empleado_pedido_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `empleado_pedido_empleadoid_foreign` FOREIGN KEY (`empleadoId`) REFERENCES `empleados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleado_pedido_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleado_pedido: Sin datos en el rango de fechas


-- Estructura de tabla `empleados`
DROP TABLE IF EXISTS `empleados`;
CREATE TABLE `empleados` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_documento` enum('cedula','pasaporte','rif') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('masculino','femenino','otro') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cargo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `departamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salario` decimal(10,2) DEFAULT NULL,
  `fecha_ingreso` date NOT NULL,
  `fecha_salida` date DEFAULT NULL,
  `estado_civil` enum('soltero','casado','divorciado','viudo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacto_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observaciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleados_codigo_unique` (`codigo`),
  UNIQUE KEY `empleados_documento_unique` (`documento`),
  UNIQUE KEY `empleados_email_unique` (`email`),
  KEY `empleados_empresa_id_foreign` (`empresa_id`),
  KEY `empleados_sucursal_id_foreign` (`sucursal_id`),
  KEY `empleados_user_id_foreign` (`user_id`),
  CONSTRAINT `empleados_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleados: Sin datos en el rango de fechas


-- Estructura de tabla `empresas`
DROP TABLE IF EXISTS `empresas`;
CREATE TABLE `empresas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pais_id` bigint unsigned DEFAULT NULL,
  `razon_social` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `representante_legal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empresas_documento_unique` (`documento`),
  KEY `empresas_pais_id_foreign` (`pais_id`),
  CONSTRAINT `empresas_pais_id_foreign` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empresas: Sin datos en el rango de fechas


-- Estructura de tabla `exchange_rates`
DROP TABLE IF EXISTS `exchange_rates`;
CREATE TABLE `exchange_rates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `usd_rate` decimal(10,4) NOT NULL,
  `eur_rate` decimal(10,4) DEFAULT NULL,
  `source` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fetch_time` time NOT NULL,
  `raw_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exchange_rates_date_fetch_time_unique` (`date`,`fetch_time`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla exchange_rates: Sin datos en el rango de fechas


-- Estructura de tabla `failed_jobs`
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla failed_jobs: Sin datos en el rango de fechas


-- Estructura de tabla `historico_pedidos`
DROP TABLE IF EXISTS `historico_pedidos`;
CREATE TABLE `historico_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historico_pedidos_empresaid_foreign` (`empresaId`),
  KEY `historico_pedidos_userid_foreign` (`userId`),
  KEY `historico_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `historico_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla historico_pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `images`
DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned NOT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_producto_id_foreign` (`producto_id`),
  KEY `images_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `images_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `images_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla images: Sin datos en el rango de fechas


-- Estructura de tabla `inventory_movements`
DROP TABLE IF EXISTS `inventory_movements`;
CREATE TABLE `inventory_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `type` enum('ingreso','salida','devolucion','ajuste','venta','compra') COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `quantity_before` int NOT NULL,
  `quantity_after` int NOT NULL,
  `unit_cost` decimal(10,2) DEFAULT NULL,
  `total_cost` decimal(10,2) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_movements_user_id_foreign` (`user_id`),
  KEY `inventory_movements_empresa_id_foreign` (`empresa_id`),
  KEY `inventory_movements_sucursal_id_foreign` (`sucursal_id`),
  KEY `inventory_movements_producto_id_created_at_index` (`producto_id`,`created_at`),
  KEY `inventory_movements_type_created_at_index` (`type`,`created_at`),
  CONSTRAINT `inventory_movements_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `inventory_movements_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_movements_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `inventory_movements_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla inventory_movements: Sin datos en el rango de fechas


-- Estructura de tabla `job_batches`
DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla job_batches: Sin datos en el rango de fechas


-- Estructura de tabla `jobs`
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla jobs: Sin datos en el rango de fechas


-- Estructura de tabla `marcas`
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE `marcas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `marcas_slug_unique` (`slug`),
  KEY `marcas_empresa_id_foreign` (`empresa_id`),
  KEY `marcas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `marcas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `marcas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla marcas: Sin datos en el rango de fechas


-- Estructura de tabla `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla migrations: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `migrations` (completo)
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
('1', '0001_01_01_000000_create_users_table', '1'),
('2', '0001_01_01_000001_create_cache_table', '1'),
('3', '0001_01_01_000002_create_jobs_table', '1'),
('4', '2023_10_21_000000_add_two_factor_columns_to_users_table', '1'),
('5', '2024_01_01_000000_create_template_customizations_table', '1'),
('6', '2025_10_17_000000_add_verification_code_to_users_table', '1'),
('7', '2025_10_17_000001_create_active_sessions_table', '1'),
('8', '2025_10_17_000002_add_fields_to_active_sessions_table', '1'),
('9', '2025_10_17_205657_create_empresas_table', '1'),
('10', '2025_10_17_214709_create_sucursales_table', '1'),
('11', '2025_10_20_132700_add_empresa_id_to_users_table', '1'),
('12', '2025_10_20_171800_add_profile_fields_to_users_table', '1'),
('13', '2025_10_20_200325_create_permission_tables', '1'),
('14', '2025_10_22_201649_add_telefono_and_email_to_empresas_table', '1'),
('15', '2025_10_24_162929_add_module_to_permissions_table', '1'),
('16', '2025_10_27_020859_create_notifications_table', '1'),
('17', '2025_10_27_022318_create_activity_log_table', '1'),
('18', '2025_10_27_022319_add_event_column_to_activity_log_table', '1'),
('19', '2025_10_27_022320_add_batch_uuid_column_to_activity_log_table', '1'),
('20', '2025_10_29_123000_create_comprobantes_table', '1'),
('21', '2025_11_01_000000_create_series_table', '1'),
('22', '2025_11_03_000001_create_cajas_table', '1'),
('23', '2025_11_03_160220_create_exchange_rates_table', '1'),
('24', '2025_11_03_161309_fix_exchange_rates_source_column', '1'),
('25', '2025_11_03_162823_add_numero_corte_to_cajas_table', '1'),
('26', '2025_11_05_090016_create_reunions_table', '1'),
('27', '2025_11_05_100000_remove_unique_constraint_from_cajas_table', '1'),
('28', '2025_11_06_090055_create_pais_table', '1'),
('29', '2025_11_06_090208_add_pais_id_to_empresas_table', '1'),
('30', '2025_11_10_120000_create_clientes_table', '1'),
('31', '2025_11_10_150121_create_marcas_table', '1'),
('32', '2025_11_10_150141_create_categorias_table', '1'),
('33', '2025_11_10_154642_create_productos_table', '1'),
('34', '2025_11_10_155453_create_images_table', '1'),
('35', '2025_11_10_155454_add_fields_to_images_table', '1'),
('36', '2025_11_10_160000_create_producto_variants_table', '1'),
('37', '2025_11_10_160001_add_image_fields_to_producto_variants_table', '1'),
('38', '2025_11_10_160002_add_sku_price_adjustment_quantity_to_producto_variants_table', '1'),
('39', '2025_11_10_160003_add_additional_fields_to_productos_table', '1'),
('40', '2025_11_10_160004_create_producto_inventory_settings_table', '1'),
('41', '2025_11_10_160005_create_producto_seo_table', '1'),
('42', '2025_11_13_000001_create_reviews_table', '1'),
('43', '2025_11_13_122414_create_wishlists_table', '1'),
('44', '2025_11_13_143714_create_search_index_for_products_table', '1'),
('45', '2025_11_14_083315_create_pedidos_table', '1'),
('46', '2025_11_14_083326_create_detalle_pedidos_table', '1'),
('47', '2025_11_14_121623_create_movimiento_pedido_table', '1'),
('48', '2025_11_14_152802_add_username_and_telephone_to_users_table', '1'),
('49', '2025_11_14_160052_add_note_to_pedidos_table', '1'),
('50', '2025_11_14_200523_create_pedido_pago_table', '1'),
('51', '2025_11_14_200524_add_total_bs_to_pedido_pago_table', '1'),
('52', '2025_11_15_000001_create_bancos_table', '1'),
('53', '2025_11_15_000002_create_referencias_bancarias_table', '1'),
('54', '2025_11_15_122143_add_tipo_atencion_to_historico_pedidos', '1'),
('55', '2025_11_15_125248_add_nota_to_pedido_pago', '1'),
('56', '2025_11_16_204410_add_location_fields_to_active_sessions_table', '1'),
('57', '2025_11_16_204411_create_empleados_table', '1'),
('58', '2025_11_17_000000_create_empleado_pedido_table', '1'),
('59', '2025_11_17_005213_add_caja_id_to_pedido_pago_table', '1'),
('60', '2025_11_24_085341_create_personal_access_tokens_table', '1'),
('61', '2025_11_24_090034_add_api_token_to_users_table', '1'),
('62', '2025_11_24_103514_add_unique_constraint_to_wishlists_table', '1'),
('63', '2025_11_24_125702_add_fecha_entrega_to_pedidos_table', '1'),
('64', '2025_11_24_130441_create_resenas_table', '1'),
('65', '2025_12_19_000000_add_simbolo_moneda_to_pais_table', '1'),
('66', '2025_11_26_123000_create_pedido_historial_table', '2'),
('67', '2025_01_27_000000_add_profile_fields_to_users_table', '3'),
('68', '2025_11_26_220850_create_product_reviews_table', '3'),
('69', '2025_11_27_101754_ensure_empleado_pedido_table_exists', '3'),
('70', '2025_11_26_000000_add_precio_bs_to_producto_variants_table', '4'),
('71', '2024_01_01_000001_create_inventory_movements_table', '5'),
('72', '2025_11_26_000000_add_sucursal_id_to_products_table', '6');


-- Estructura de tabla `model_has_permissions`
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Tabla model_has_permissions: Sin datos


-- Estructura de tabla `model_has_roles`
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_roles: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `model_has_roles` (completo)
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
('1', 'App\\Models\\User', '1'),
('2', 'App\\Models\\User', '2'),
('4', 'App\\Models\\User', '3'),
('5', 'App\\Models\\User', '4'),
('5', 'App\\Models\\User', '5'),
('5', 'App\\Models\\User', '6'),
('5', 'App\\Models\\User', '7'),
('5', 'App\\Models\\User', '8'),
('5', 'App\\Models\\User', '9');


-- Estructura de tabla `notifications`
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_user_id_read_at_index` (`user_id`,`read_at`),
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla notifications: Sin datos en el rango de fechas


-- Estructura de tabla `pais`
DROP TABLE IF EXISTS `pais`;
CREATE TABLE `pais` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso2` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso3` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_telefonico` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moneda_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `simbolo_moneda` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idioma_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continente` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zona_horaria` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `formato_fecha` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dd/mm/yyyy',
  `formato_moneda` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.234,56',
  `impuesto_predeterminado` decimal(5,2) NOT NULL DEFAULT '0.00',
  `separador_miles` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `separador_decimales` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `decimales_moneda` int NOT NULL DEFAULT '2',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pais_codigo_iso2_unique` (`codigo_iso2`),
  UNIQUE KEY `pais_codigo_iso3_unique` (`codigo_iso3`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pais: Sin datos en el rango de fechas


-- Estructura de tabla `password_reset_tokens`
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla password_reset_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_historial`
DROP TABLE IF EXISTS `pedido_historial`;
CREATE TABLE `pedido_historial` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `usuario_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_historial_pedido_id_foreign` (`pedido_id`),
  KEY `pedido_historial_usuario_id_foreign` (`usuario_id`),
  CONSTRAINT `pedido_historial_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_historial_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedido_historial: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_pago`
DROP TABLE IF EXISTS `pedido_pago`;
CREATE TABLE `pedido_pago` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `caja_id` bigint unsigned DEFAULT NULL,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` decimal(15,2) DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `nota` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDENTE',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_pago_empresaid_foreign` (`empresaId`),
  KEY `pedido_pago_userid_foreign` (`userId`),
  KEY `pedido_pago_pedidoid_foreign` (`pedidoId`),
  KEY `pedido_pago_caja_id_foreign` (`caja_id`),
  CONSTRAINT `pedido_pago_caja_id_foreign` FOREIGN KEY (`caja_id`) REFERENCES `cajas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pedido_pago_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedido_pago: Sin datos en el rango de fechas


-- Estructura de tabla `pedidos`
DROP TABLE IF EXISTS `pedidos`;
CREATE TABLE `pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `fecha_entrega` timestamp NULL DEFAULT NULL,
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nota` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedidos_empresaid_foreign` (`empresaId`),
  KEY `pedidos_userid_foreign` (`userId`),
  CONSTRAINT `pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`),
  KEY `permissions_module_index` (`module`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla permissions: Sin datos en el rango de fechas


-- Estructura de tabla `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_expires_at_index` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla personal_access_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `product_reviews`
DROP TABLE IF EXISTS `product_reviews`;
CREATE TABLE `product_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` tinyint unsigned NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `verified_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_reviews_producto_id_user_id_unique` (`producto_id`,`user_id`),
  KEY `product_reviews_user_id_foreign` (`user_id`),
  KEY `product_reviews_producto_id_is_approved_index` (`producto_id`,`is_approved`),
  CONSTRAINT `product_reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_reviews: Sin datos en el rango de fechas


-- Estructura de tabla `producto_inventory_settings`
DROP TABLE IF EXISTS `producto_inventory_settings`;
CREATE TABLE `producto_inventory_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `low_stock_threshold` int NOT NULL DEFAULT '5',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_inventory_settings_producto_id_index` (`producto_id`),
  KEY `producto_inventory_settings_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_inventory_settings_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_inventory_settings_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla producto_inventory_settings: Sin datos en el rango de fechas


-- Estructura de tabla `producto_seo`
DROP TABLE IF EXISTS `producto_seo`;
CREATE TABLE `producto_seo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_seo_producto_id_index` (`producto_id`),
  KEY `producto_seo_empresa_id_index` (`empresa_id`),
  KEY `producto_seo_sku_index` (`sku`),
  KEY `producto_seo_barcode_index` (`barcode`),
  CONSTRAINT `producto_seo_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_seo_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla producto_seo: Sin datos en el rango de fechas


-- Estructura de tabla `producto_variants`
DROP TABLE IF EXISTS `producto_variants`;
CREATE TABLE `producto_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` json NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `image_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_variants_producto_id_index` (`producto_id`),
  KEY `producto_variants_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_variants_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_variants_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla producto_variants: Sin datos en el rango de fechas


-- Estructura de tabla `productos`
DROP TABLE IF EXISTS `productos`;
CREATE TABLE `productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `has_variants` tinyint(1) NOT NULL DEFAULT '0',
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `quantity` int NOT NULL DEFAULT '0',
  `quantity_alert` int NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `categoria_id` bigint unsigned NOT NULL,
  `marca_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productos_code_unique` (`code`),
  KEY `productos_empresa_id_index` (`empresa_id`),
  KEY `productos_categoria_id_index` (`categoria_id`),
  KEY `productos_marca_id_index` (`marca_id`),
  KEY `productos_name_index` (`name`),
  KEY `productos_price_index` (`price`),
  KEY `productos_quantity_index` (`quantity`),
  KEY `productos_status_quantity_index` (`status`,`quantity`),
  KEY `productos_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `productos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla productos: Sin datos en el rango de fechas


-- Estructura de tabla `referencias_bancarias`
DROP TABLE IF EXISTS `referencias_bancarias`;
CREATE TABLE `referencias_bancarias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `tipo_pago` enum('pago_movil','transferencia') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `banco_id` bigint unsigned NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_cuenta` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_cuenta` enum('ahorro','corriente') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_restante` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `referencias_bancarias_pedido_id_foreign` (`pedido_id`),
  KEY `referencias_bancarias_banco_id_foreign` (`banco_id`),
  CONSTRAINT `referencias_bancarias_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `bancos` (`id`),
  CONSTRAINT `referencias_bancarias_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla referencias_bancarias: Sin datos en el rango de fechas


-- Estructura de tabla `resenas`
DROP TABLE IF EXISTS `resenas`;
CREATE TABLE `resenas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `calificacion` tinyint unsigned NOT NULL COMMENT '1-5 estrellas',
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `aprobada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resenas_user_id_foreign` (`user_id`),
  KEY `resenas_producto_id_foreign` (`producto_id`),
  KEY `resenas_pedido_id_producto_id_index` (`pedido_id`,`producto_id`),
  KEY `resenas_calificacion_index` (`calificacion`),
  KEY `resenas_aprobada_index` (`aprobada`),
  CONSTRAINT `resenas_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla resenas: Sin datos en el rango de fechas


-- Estructura de tabla `reunions`
DROP TABLE IF EXISTS `reunions`;
CREATE TABLE `reunions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `fecha_inicio` datetime NOT NULL,
  `fecha_fin` datetime NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` enum('programada','en_curso','finalizada','cancelada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'programada',
  `color` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#007bff',
  `participantes` json DEFAULT NULL,
  `creado_por` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reunions_creado_por_foreign` (`creado_por`),
  KEY `reunions_empresa_id_foreign` (`empresa_id`),
  KEY `reunions_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `reunions_creado_por_foreign` FOREIGN KEY (`creado_por`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reunions: Sin datos en el rango de fechas


-- Estructura de tabla `reviews`
DROP TABLE IF EXISTS `reviews`;
CREATE TABLE `reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL DEFAULT '5',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_empresa_id_foreign` (`empresa_id`),
  KEY `reviews_producto_id_approved_index` (`producto_id`,`approved`),
  KEY `reviews_user_id_index` (`user_id`),
  CONSTRAINT `reviews_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reviews: Sin datos en el rango de fechas


-- Estructura de tabla `role_has_permissions`
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla role_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `role_has_permissions` (completo)
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
('1', '1'),
('2', '1'),
('3', '1'),
('4', '1'),
('5', '1'),
('6', '1'),
('7', '1'),
('8', '1'),
('9', '1'),
('10', '1'),
('11', '1'),
('12', '1'),
('13', '1'),
('14', '1'),
('15', '1'),
('16', '1'),
('17', '1'),
('18', '1'),
('19', '1'),
('20', '1'),
('21', '1'),
('22', '1'),
('23', '1'),
('24', '1'),
('25', '1'),
('26', '1'),
('27', '1'),
('28', '1'),
('29', '1'),
('30', '1'),
('31', '1'),
('32', '1'),
('33', '1'),
('34', '1'),
('35', '1'),
('36', '1'),
('37', '1'),
('38', '1'),
('39', '1'),
('40', '1'),
('41', '1'),
('42', '1'),
('43', '1'),
('44', '1'),
('45', '1'),
('46', '1'),
('47', '1'),
('48', '1'),
('49', '1'),
('50', '1'),
('51', '1'),
('52', '1'),
('53', '1'),
('54', '1'),
('55', '1'),
('56', '1'),
('57', '1'),
('58', '1'),
('59', '1'),
('60', '1'),
('61', '1'),
('62', '1'),
('63', '1'),
('64', '1'),
('65', '1'),
('66', '1'),
('67', '1'),
('68', '1'),
('69', '1'),
('70', '1'),
('71', '1'),
('72', '1'),
('73', '1'),
('74', '1'),
('75', '1'),
('76', '1'),
('77', '1'),
('78', '1'),
('79', '1'),
('80', '1'),
('81', '1'),
('82', '1'),
('83', '1'),
('84', '1'),
('85', '1'),
('86', '1'),
('87', '1'),
('88', '1'),
('89', '1'),
('90', '1'),
('91', '1'),
('92', '1'),
('93', '1'),
('94', '1'),
('95', '1'),
('96', '1'),
('97', '1'),
('98', '1'),
('99', '1'),
('100', '1'),
('101', '1'),
('102', '1'),
('103', '1'),
('104', '1'),
('105', '1'),
('106', '1'),
('107', '1'),
('108', '1'),
('109', '1'),
('110', '1'),
('111', '1'),
('112', '1'),
('113', '1'),
('114', '1'),
('115', '1'),
('116', '1'),
('117', '1'),
('118', '1'),
('119', '1'),
('120', '1'),
('121', '1'),
('122', '1'),
('123', '1'),
('124', '1'),
('125', '1'),
('126', '1'),
('127', '1'),
('128', '1'),
('129', '1'),
('130', '1'),
('131', '1'),
('132', '1'),
('133', '1'),
('134', '1'),
('135', '1'),
('136', '1'),
('137', '1'),
('138', '1'),
('139', '1'),
('140', '1'),
('141', '1'),
('142', '1'),
('143', '1'),
('144', '1'),
('145', '1'),
('146', '1'),
('147', '1'),
('148', '1'),
('149', '1'),
('150', '1'),
('151', '1'),
('152', '1'),
('153', '1'),
('154', '1'),
('155', '1'),
('156', '1'),
('157', '1'),
('158', '1'),
('159', '1'),
('160', '1'),
('161', '1'),
('162', '1'),
('163', '1'),
('164', '1'),
('165', '1'),
('166', '1'),
('167', '1'),
('168', '1'),
('169', '1'),
('170', '1'),
('171', '1'),
('172', '1'),
('173', '1'),
('1', '2'),
('2', '2'),
('3', '2'),
('4', '2'),
('5', '2'),
('6', '2'),
('7', '2'),
('8', '2'),
('9', '2'),
('10', '2'),
('11', '2'),
('12', '2'),
('13', '2'),
('14', '2'),
('15', '2'),
('16', '2'),
('17', '2'),
('18', '2'),
('19', '2'),
('20', '2'),
('22', '2'),
('23', '2'),
('24', '2'),
('25', '2'),
('27', '2'),
('28', '2'),
('29', '2'),
('30', '2'),
('31', '2'),
('32', '2'),
('33', '2'),
('34', '2'),
('35', '2'),
('36', '2'),
('37', '2'),
('38', '2'),
('39', '2'),
('40', '2'),
('41', '2'),
('42', '2'),
('43', '2'),
('44', '2'),
('45', '2'),
('46', '2'),
('47', '2'),
('48', '2'),
('49', '2'),
('50', '2'),
('51', '2'),
('52', '2'),
('53', '2'),
('54', '2'),
('55', '2'),
('56', '2'),
('57', '2'),
('58', '2'),
('59', '2'),
('60', '2'),
('61', '2'),
('62', '2'),
('63', '2'),
('64', '2'),
('65', '2'),
('66', '2'),
('67', '2'),
('68', '2'),
('69', '2'),
('70', '2'),
('71', '2'),
('72', '2'),
('73', '2'),
('74', '2'),
('75', '2'),
('76', '2'),
('77', '2'),
('78', '2'),
('79', '2'),
('80', '2'),
('81', '2'),
('82', '2'),
('83', '2'),
('84', '2'),
('85', '2'),
('86', '2'),
('87', '2'),
('88', '2'),
('89', '2'),
('90', '2'),
('91', '2'),
('92', '2'),
('93', '2'),
('94', '2'),
('95', '2'),
('96', '2'),
('97', '2'),
('98', '2'),
('99', '2'),
('100', '2'),
('101', '2'),
('102', '2'),
('103', '2'),
('104', '2'),
('105', '2'),
('106', '2'),
('107', '2'),
('108', '2'),
('109', '2'),
('110', '2'),
('111', '2'),
('112', '2'),
('113', '2'),
('114', '2'),
('115', '2'),
('116', '2'),
('117', '2'),
('118', '2'),
('119', '2'),
('120', '2'),
('121', '2'),
('122', '2'),
('123', '2'),
('124', '2'),
('125', '2'),
('126', '2'),
('127', '2'),
('128', '2'),
('129', '2'),
('130', '2'),
('131', '2'),
('132', '2'),
('133', '2'),
('134', '2'),
('135', '2'),
('136', '2'),
('137', '2'),
('138', '2'),
('139', '2'),
('140', '2'),
('141', '2'),
('142', '2'),
('143', '2'),
('144', '2'),
('145', '2'),
('146', '2'),
('147', '2'),
('148', '2'),
('149', '2'),
('150', '2'),
('151', '2'),
('152', '2'),
('153', '2'),
('154', '2'),
('155', '2'),
('156', '2'),
('157', '2'),
('158', '2'),
('159', '2'),
('160', '2'),
('161', '2'),
('162', '2'),
('163', '2'),
('164', '2'),
('165', '2'),
('166', '2'),
('167', '2'),
('168', '2'),
('169', '2'),
('170', '2'),
('171', '2'),
('172', '2'),
('173', '2'),
('43', '3'),
('44', '3'),
('45', '3'),
('46', '3'),
('47', '3'),
('48', '3'),
('49', '3'),
('50', '3'),
('69', '3'),
('70', '3'),
('71', '3'),
('72', '3'),
('73', '3'),
('74', '3'),
('75', '3'),
('76', '3'),
('77', '3'),
('78', '3'),
('79', '3'),
('137', '4'),
('138', '4'),
('139', '4'),
('140', '4'),
('141', '4'),
('142', '4'),
('143', '4'),
('144', '4'),
('145', '4'),
('146', '4'),
('147', '4'),
('148', '4'),
('149', '4'),
('150', '4'),
('151', '4'),
('137', '5'),
('138', '5'),
('139', '5'),
('140', '5'),
('141', '5'),
('142', '5'),
('143', '5'),
('144', '5'),
('145', '5'),
('146', '5'),
('147', '5'),
('148', '5'),
('149', '5');


-- Estructura de tabla `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla roles: Sin datos en el rango de fechas


-- Estructura de tabla `series`
DROP TABLE IF EXISTS `series`;
CREATE TABLE `series` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo_documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `correlativo_actual` int NOT NULL DEFAULT '0',
  `longitud_correlativo` int NOT NULL DEFAULT '8',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series_serie_empresa_id_sucursal_id_unique` (`serie`,`empresa_id`,`sucursal_id`),
  KEY `series_empresa_id_foreign` (`empresa_id`),
  KEY `series_sucursal_id_foreign` (`sucursal_id`),
  KEY `series_tipo_documento_empresa_id_sucursal_id_activo_index` (`tipo_documento`,`empresa_id`,`sucursal_id`,`activo`),
  CONSTRAINT `series_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `series_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla series: Sin datos en el rango de fechas


-- Estructura de tabla `sessions`
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sessions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `sessions` (completo)
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
('LcHSbQmpzfsgc64cjhZJp1NrNqtzZOpwDnwrHGK9', '2', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', '1764352213');


-- Estructura de tabla `sucursales`
DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE `sucursales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sucursales_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `sucursales_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sucursales: Sin datos en el rango de fechas


-- Estructura de tabla `template_customizations`
DROP TABLE IF EXISTS `template_customizations`;
CREATE TABLE `template_customizations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `primary_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#7367F0',
  `skin` int NOT NULL DEFAULT '0',
  `theme` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `semi_dark` tinyint(1) NOT NULL DEFAULT '0',
  `content_layout` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'compact',
  `header_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `menu_collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `navbar_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sticky',
  `text_direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ltr',
  `footer_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `dropdown_on_hover` tinyint(1) NOT NULL DEFAULT '0',
  `layout_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'vertical',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla template_customizations: Sin datos en el rango de fechas


-- Estructura de tabla `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `bio` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notifications_email` tinyint(1) NOT NULL DEFAULT '1',
  `notifications_sms` tinyint(1) NOT NULL DEFAULT '0',
  `notifications_push` tinyint(1) NOT NULL DEFAULT '1',
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verification_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` json DEFAULT NULL,
  `two_factor_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `verification_code_sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `empresa_id` bigint unsigned DEFAULT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_devices` json DEFAULT NULL,
  `common_locations` json DEFAULT NULL,
  `total_session_time` int NOT NULL DEFAULT '0',
  `security_alerts` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `api_token` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_api_token_unique` (`api_token`),
  KEY `users_empresa_id_foreign` (`empresa_id`),
  KEY `users_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `users_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla users: Sin datos en el rango de fechas


-- Estructura de tabla `wishlists`
DROP TABLE IF EXISTS `wishlists`;
CREATE TABLE `wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wishlists_user_id_producto_id_unique` (`user_id`,`producto_id`),
  KEY `wishlists_producto_id_foreign` (`producto_id`),
  CONSTRAINT `wishlists_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wishlists_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla wishlists: Sin datos en el rango de fechas

