-- Respaldo filtrado por fechas (2025-11-28 a 2025-11-28)
-- Generado: 2025-11-28 13:29:01


-- Estructura de tabla `active_sessions`
DROP TABLE IF EXISTS `active_sessions`;
CREATE TABLE `active_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `last_activity` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `login_at` timestamp NULL DEFAULT NULL,
  `logout_at` timestamp NULL DEFAULT NULL,
  `is_current` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `active_sessions_user_id_session_id_index` (`user_id`,`session_id`),
  CONSTRAINT `active_sessions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `active_sessions` (filtrado)
INSERT INTO `active_sessions` (`id`, `user_id`, `session_id`, `ip_address`, `user_agent`, `location`, `latitude`, `longitude`, `last_activity`, `login_at`, `logout_at`, `is_current`, `is_active`, `created_at`, `updated_at`) VALUES
('13', '2', '64I9Zcj3TbreJF8uOKeqaEcXsOVw1iLyKUtYdIoz', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, '10.43988480', '-66.86638080', '2025-11-28 09:34:59', NULL, NULL, '0', '1', '2025-11-28 09:34:59', '2025-11-28 09:34:59');


-- Estructura de tabla `activity_log`
DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE `activity_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject_id` bigint unsigned DEFAULT NULL,
  `causer_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` bigint unsigned DEFAULT NULL,
  `properties` json DEFAULT NULL,
  `batch_uuid` char(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla activity_log: Sin datos en el rango de fechas


-- Estructura de tabla `bancos`
DROP TABLE IF EXISTS `bancos`;
CREATE TABLE `bancos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bancos_codigo_unique` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla bancos: Sin datos en el rango de fechas


-- Estructura de tabla `batch_movements`
DROP TABLE IF EXISTS `batch_movements`;
CREATE TABLE `batch_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `batch_id` bigint unsigned NOT NULL,
  `type` enum('in','out','adjustment','expired','returned') COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `reason` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `batch_movements_user_id_foreign` (`user_id`),
  KEY `batch_movements_empresa_id_foreign` (`empresa_id`),
  KEY `batch_movements_batch_id_type_index` (`batch_id`,`type`),
  KEY `batch_movements_created_at_index` (`created_at`),
  CONSTRAINT `batch_movements_batch_id_foreign` FOREIGN KEY (`batch_id`) REFERENCES `product_batches` (`id`) ON DELETE CASCADE,
  CONSTRAINT `batch_movements_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `batch_movements_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla batch_movements: Sin datos en el rango de fechas


-- Estructura de tabla `cache`
DROP TABLE IF EXISTS `cache`;
CREATE TABLE `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache: Sin datos


-- Estructura de tabla `cache_locks`
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cache_locks: Sin columnas de fecha, respaldando todos los datos
-- Tabla cache_locks: Sin datos


-- Estructura de tabla `cajas`
DROP TABLE IF EXISTS `cajas`;
CREATE TABLE `cajas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `fecha` date NOT NULL,
  `numero_corte` int NOT NULL DEFAULT '1',
  `monto_inicial` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_efectivo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_transferencias` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_tarjetas` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_ingresos` decimal(10,2) NOT NULL DEFAULT '0.00',
  `monto_final` decimal(10,2) NOT NULL DEFAULT '0.00',
  `estado` enum('abierta','cerrada') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'abierta',
  `fecha_apertura` timestamp NOT NULL,
  `fecha_cierre` timestamp NULL DEFAULT NULL,
  `observaciones_apertura` text COLLATE utf8mb4_unicode_ci,
  `observaciones_cierre` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cajas_user_id_foreign` (`user_id`),
  KEY `cajas_fecha_estado_index` (`fecha`,`estado`),
  KEY `cajas_empresa_id_foreign` (`empresa_id`),
  KEY `cajas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `cajas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla cajas: Sin datos en el rango de fechas


-- Estructura de tabla `categorias`
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE `categorias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categorias_slug_unique` (`slug`),
  KEY `categorias_empresa_id_foreign` (`empresa_id`),
  KEY `categorias_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `categorias_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categorias_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla categorias: Sin datos en el rango de fechas


-- Estructura de tabla `clientes`
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE `clientes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombres` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text COLLATE utf8mb4_unicode_ci,
  `documento_identidad` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientes_empresa_id_foreign` (`empresa_id`),
  KEY `clientes_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `clientes_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla clientes: Sin datos en el rango de fechas


-- Estructura de tabla `comprobantes`
DROP TABLE IF EXISTS `comprobantes`;
CREATE TABLE `comprobantes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha_emision` datetime NOT NULL,
  `serie` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` json NOT NULL,
  `comprobanteable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobanteable_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `comprobantes_numero_unique` (`numero`),
  KEY `comprobantes_comprobanteable_type_comprobanteable_id_index` (`comprobanteable_type`,`comprobanteable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla comprobantes: Sin datos en el rango de fechas


-- Estructura de tabla `detalle_pedidos`
DROP TABLE IF EXISTS `detalle_pedidos`;
CREATE TABLE `detalle_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `productoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detalle_pedidos_empresaid_foreign` (`empresaId`),
  KEY `detalle_pedidos_userid_foreign` (`userId`),
  KEY `detalle_pedidos_productoid_foreign` (`productoId`),
  KEY `detalle_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `detalle_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_productoid_foreign` FOREIGN KEY (`productoId`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla detalle_pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `empleado_pedido`
DROP TABLE IF EXISTS `empleado_pedido`;
CREATE TABLE `empleado_pedido` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empleadoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleado_pedido_empleadoid_pedidoid_unique` (`empleadoId`,`pedidoId`),
  KEY `empleado_pedido_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `empleado_pedido_empleadoid_foreign` FOREIGN KEY (`empleadoId`) REFERENCES `empleados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleado_pedido_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleado_pedido: Sin datos en el rango de fechas


-- Estructura de tabla `empleados`
DROP TABLE IF EXISTS `empleados`;
CREATE TABLE `empleados` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_documento` enum('cedula','pasaporte','rif') COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('masculino','femenino','otro') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text COLLATE utf8mb4_unicode_ci,
  `cargo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `departamento` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `salario` decimal(10,2) DEFAULT NULL,
  `fecha_ingreso` date NOT NULL,
  `fecha_salida` date DEFAULT NULL,
  `estado_civil` enum('soltero','casado','divorciado','viudo') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacto_emergencia` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono_emergencia` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observaciones` text COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleados_codigo_unique` (`codigo`),
  UNIQUE KEY `empleados_documento_unique` (`documento`),
  UNIQUE KEY `empleados_email_unique` (`email`),
  KEY `empleados_empresa_id_foreign` (`empresa_id`),
  KEY `empleados_sucursal_id_foreign` (`sucursal_id`),
  KEY `empleados_user_id_foreign` (`user_id`),
  CONSTRAINT `empleados_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empleados: Sin datos en el rango de fechas


-- Estructura de tabla `empresas`
DROP TABLE IF EXISTS `empresas`;
CREATE TABLE `empresas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pais_id` bigint unsigned DEFAULT NULL,
  `razon_social` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` text COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `representante_legal` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empresas_documento_unique` (`documento`),
  KEY `empresas_pais_id_foreign` (`pais_id`),
  CONSTRAINT `empresas_pais_id_foreign` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla empresas: Sin datos en el rango de fechas


-- Estructura de tabla `exchange_rates`
DROP TABLE IF EXISTS `exchange_rates`;
CREATE TABLE `exchange_rates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `usd_rate` decimal(10,4) NOT NULL,
  `eur_rate` decimal(10,4) DEFAULT NULL,
  `source` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `fetch_time` time NOT NULL,
  `raw_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exchange_rates_date_fetch_time_unique` (`date`,`fetch_time`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla exchange_rates: Sin datos en el rango de fechas


-- Estructura de tabla `failed_jobs`
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla failed_jobs: Sin datos en el rango de fechas


-- Estructura de tabla `historico_pedidos`
DROP TABLE IF EXISTS `historico_pedidos`;
CREATE TABLE `historico_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `descripcion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historico_pedidos_empresaid_foreign` (`empresaId`),
  KEY `historico_pedidos_userid_foreign` (`userId`),
  KEY `historico_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `historico_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla historico_pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `images`
DROP TABLE IF EXISTS `images`;
CREATE TABLE `images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned NOT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_producto_id_foreign` (`producto_id`),
  KEY `images_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `images_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `images_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `images` (filtrado)
INSERT INTO `images` (`id`, `path`, `thumbnail_path`, `alt_text`, `is_primary`, `order`, `producto_id`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
('55', 'productos/1764337416_0.jpg', NULL, NULL, '0', '0', '42', '1', '1', '2025-11-28 09:43:36', '2025-11-28 09:43:36'),
('58', 'productos/1764337767_0.jpg', NULL, NULL, '0', '0', '43', '1', '1', '2025-11-28 09:49:27', '2025-11-28 09:49:27'),
('59', 'productos/1764337943_0.jpg', NULL, NULL, '0', '0', '44', '1', '1', '2025-11-28 09:52:23', '2025-11-28 09:52:23'),
('60', 'productos/1764338134_0.jpg', NULL, NULL, '0', '0', '46', '1', '1', '2025-11-28 09:55:34', '2025-11-28 09:55:34'),
('61', 'productos/1764338160_0.jpg', NULL, NULL, '0', '0', '47', '1', '1', '2025-11-28 09:56:00', '2025-11-28 09:56:00'),
('62', 'productos/1764338245_0.jpg', NULL, NULL, '0', '0', '48', '1', '1', '2025-11-28 09:57:25', '2025-11-28 09:57:25'),
('64', 'productos/1764338349_0.webp', NULL, NULL, '0', '0', '50', '1', '1', '2025-11-28 09:59:09', '2025-11-28 09:59:09'),
('65', 'productos/1764338526_0.jpg', NULL, NULL, '0', '0', '51', '1', '1', '2025-11-28 10:02:06', '2025-11-28 10:02:06'),
('66', 'productos/i4x5dqeFlSrw5alZ3YeEuL7RZ56EKJiY4ktApYB9.jpg', NULL, 'Cigarrillos Consul', '0', '0', '272', '0', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('67', 'productos/1764340900_0.jpg', NULL, NULL, '0', '0', '272', '1', '1', '2025-11-28 10:41:40', '2025-11-28 10:41:40'),
('68', 'productos/1764341410_0.jpg', NULL, NULL, '0', '0', '273', '1', '1', '2025-11-28 10:50:10', '2025-11-28 10:50:10'),
('69', 'productos/1764342731_0.jpg', NULL, NULL, '0', '0', '60', '1', '1', '2025-11-28 11:12:11', '2025-11-28 11:12:11'),
('70', 'productos/1764343424_0.jpg', NULL, NULL, '0', '0', '61', '1', '1', '2025-11-28 11:23:44', '2025-11-28 11:23:44'),
('71', 'productos/1764343479_0.jpg', NULL, NULL, '0', '0', '63', '1', '1', '2025-11-28 11:24:39', '2025-11-28 11:24:39'),
('72', 'productos/1764343555_0.jpg', NULL, NULL, '0', '0', '59', '1', '1', '2025-11-28 11:25:55', '2025-11-28 11:25:55'),
('73', 'productos/1764343834_0.jpg', NULL, NULL, '0', '0', '58', '1', '1', '2025-11-28 11:30:34', '2025-11-28 11:30:34'),
('74', 'productos/1764344060_0.jpg', NULL, NULL, '0', '0', '66', '1', '1', '2025-11-28 11:34:21', '2025-11-28 11:34:21'),
('75', 'productos/1764345114_0.jpg', NULL, NULL, '0', '0', '200', '1', '1', '2025-11-28 11:51:54', '2025-11-28 11:51:54'),
('76', 'productos/1764345151_0.jpg', NULL, NULL, '0', '0', '201', '1', '1', '2025-11-28 11:52:31', '2025-11-28 11:52:31'),
('77', 'productos/1764345185_0.jpg', NULL, NULL, '0', '0', '202', '1', '1', '2025-11-28 11:53:05', '2025-11-28 11:53:05'),
('78', 'productos/1764345261_0.jpg', NULL, NULL, '0', '0', '185', '1', '1', '2025-11-28 11:54:21', '2025-11-28 11:54:21'),
('79', 'productos/1764345290_0.jpg', NULL, NULL, '0', '0', '186', '1', '1', '2025-11-28 11:54:50', '2025-11-28 11:54:50'),
('80', 'productos/1764337416_0.jpg', ' NULL', ' NULL', '0', '0', '42', '1', '1', '2025-11-28 09:43:36', '2025-11-28 09:43:36'),
('81', 'productos/1764350555_0.jpg', NULL, NULL, '0', '0', '85', '1', '1', '2025-11-28 13:22:35', '2025-11-28 13:22:35');


-- Estructura de tabla `inventory_movements`
DROP TABLE IF EXISTS `inventory_movements`;
CREATE TABLE `inventory_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `type` enum('ingreso','salida','devolucion','ajuste','venta','compra') COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `quantity_before` int NOT NULL,
  `quantity_after` int NOT NULL,
  `unit_cost` decimal(10,2) DEFAULT NULL,
  `total_cost` decimal(10,2) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_movements_user_id_foreign` (`user_id`),
  KEY `inventory_movements_empresa_id_foreign` (`empresa_id`),
  KEY `inventory_movements_producto_id_created_at_index` (`producto_id`,`created_at`),
  KEY `inventory_movements_type_created_at_index` (`type`,`created_at`),
  KEY `inventory_movements_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `inventory_movements_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `inventory_movements_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_movements_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `inventory_movements_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla inventory_movements: Sin datos en el rango de fechas


-- Estructura de tabla `job_batches`
DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla job_batches: Sin datos en el rango de fechas


-- Estructura de tabla `jobs`
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla jobs: Sin datos en el rango de fechas


-- Estructura de tabla `marcas`
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE `marcas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `marcas_slug_unique` (`slug`),
  KEY `marcas_empresa_id_foreign` (`empresa_id`),
  KEY `marcas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `marcas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `marcas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `marcas` (filtrado)
INSERT INTO `marcas` (`id`, `nombre`, `slug`, `descripcion`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
('106', 'Ibiza', 'ibiza', 'Productos Ibiza', '1', '1', '1', '2025-11-28 10:16:50', '2025-11-28 10:16:51'),
('107', 'Consul', 'consul', 'Productos Consul', '1', '1', '1', '2025-11-28 10:38:00', '2025-11-28 10:38:03');


-- Estructura de tabla `migrations`
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla migrations: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `migrations` (completo)
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
('1', '0001_01_01_000000_create_users_table', '1'),
('2', '0001_01_01_000001_create_cache_table', '1'),
('3', '0001_01_01_000002_create_jobs_table', '1'),
('4', '2023_10_21_000000_add_two_factor_columns_to_users_table', '1'),
('5', '2024_01_01_000000_create_template_customizations_table', '1'),
('6', '2025_10_17_000000_add_verification_code_to_users_table', '1'),
('7', '2025_10_17_000001_create_active_sessions_table', '1'),
('8', '2025_10_17_000002_add_fields_to_active_sessions_table', '1'),
('9', '2025_10_17_205657_create_empresas_table', '1'),
('10', '2025_10_17_214709_create_sucursales_table', '1'),
('11', '2025_10_20_132700_add_empresa_id_to_users_table', '1'),
('12', '2025_10_20_171800_add_profile_fields_to_users_table', '1'),
('13', '2025_10_20_200325_create_permission_tables', '1'),
('14', '2025_10_22_201649_add_telefono_and_email_to_empresas_table', '1'),
('15', '2025_10_24_162929_add_module_to_permissions_table', '1'),
('16', '2025_10_27_020859_create_notifications_table', '1'),
('17', '2025_10_27_022318_create_activity_log_table', '1'),
('18', '2025_10_27_022319_add_event_column_to_activity_log_table', '1'),
('19', '2025_10_27_022320_add_batch_uuid_column_to_activity_log_table', '1'),
('20', '2025_10_29_123000_create_comprobantes_table', '1'),
('21', '2025_11_01_000000_create_series_table', '1'),
('22', '2025_11_03_000001_create_cajas_table', '1'),
('23', '2025_11_03_160220_create_exchange_rates_table', '1'),
('24', '2025_11_03_161309_fix_exchange_rates_source_column', '1'),
('25', '2025_11_03_162823_add_numero_corte_to_cajas_table', '1'),
('26', '2025_11_05_090016_create_reunions_table', '1'),
('27', '2025_11_05_100000_remove_unique_constraint_from_cajas_table', '1'),
('28', '2025_11_06_090055_create_pais_table', '1'),
('29', '2025_11_06_090208_add_pais_id_to_empresas_table', '1'),
('30', '2025_11_10_120000_create_clientes_table', '1'),
('31', '2025_11_10_150121_create_marcas_table', '1'),
('32', '2025_11_10_150141_create_categorias_table', '1'),
('33', '2025_11_10_154642_create_productos_table', '1'),
('34', '2025_11_10_155453_create_images_table', '1'),
('35', '2025_11_10_155454_add_fields_to_images_table', '1'),
('36', '2025_11_10_160000_create_producto_variants_table', '1'),
('37', '2025_11_10_160001_add_image_fields_to_producto_variants_table', '1'),
('38', '2025_11_10_160002_add_sku_price_adjustment_quantity_to_producto_variants_table', '1'),
('39', '2025_11_10_160003_add_additional_fields_to_productos_table', '1'),
('40', '2025_11_10_160004_create_producto_inventory_settings_table', '1'),
('41', '2025_11_10_160005_create_producto_seo_table', '1'),
('42', '2025_11_13_000001_create_reviews_table', '1'),
('43', '2025_11_13_122414_create_wishlists_table', '1'),
('44', '2025_11_13_143714_create_search_index_for_products_table', '1'),
('45', '2025_11_14_083315_create_pedidos_table', '1'),
('46', '2025_11_14_083326_create_detalle_pedidos_table', '1'),
('47', '2025_11_14_121623_create_movimiento_pedido_table', '1'),
('48', '2025_11_14_152802_add_username_and_telephone_to_users_table', '1'),
('49', '2025_11_14_160052_add_note_to_pedidos_table', '1'),
('50', '2025_11_14_200523_create_pedido_pago_table', '1'),
('51', '2025_11_14_200524_add_total_bs_to_pedido_pago_table', '1'),
('52', '2025_11_15_000001_create_bancos_table', '1'),
('53', '2025_11_15_000002_create_referencias_bancarias_table', '1'),
('54', '2025_11_15_122143_add_tipo_atencion_to_historico_pedidos', '1'),
('55', '2025_11_15_125248_add_nota_to_pedido_pago', '1'),
('56', '2025_11_16_204410_add_location_fields_to_active_sessions_table', '1'),
('57', '2025_11_16_204411_create_empleados_table', '1'),
('58', '2025_11_17_000000_create_empleado_pedido_table', '1'),
('59', '2025_11_17_005213_add_caja_id_to_pedido_pago_table', '1'),
('60', '2025_11_24_085341_create_personal_access_tokens_table', '1'),
('61', '2025_11_24_090034_add_api_token_to_users_table', '1'),
('62', '2025_11_24_103514_add_unique_constraint_to_wishlists_table', '1'),
('63', '2025_11_24_125702_add_fecha_entrega_to_pedidos_table', '1'),
('64', '2025_11_24_130441_create_resenas_table', '1'),
('65', '2025_12_19_000000_add_simbolo_moneda_to_pais_table', '1'),
('66', '2025_11_26_123000_create_pedido_historial_table', '2'),
('67', '2025_01_27_000000_add_profile_fields_to_users_table', '3'),
('68', '2025_11_26_220850_create_product_reviews_table', '3'),
('69', '2025_11_27_101754_ensure_empleado_pedido_table_exists', '3'),
('70', '2025_11_26_000000_add_precio_bs_to_producto_variants_table', '4'),
('71', '2024_01_01_000001_create_inventory_movements_table', '5'),
('72', '2024_01_01_000002_add_sucursal_id_to_inventory_movements', '6'),
('73', '2025_01_15_000000_add_batch_fields_to_productos_table', '7'),
('74', '2025_01_15_000001_create_product_batches_table', '8'),
('75', '2025_01_15_000002_create_batch_movements_table', '8');


-- Estructura de tabla `model_has_permissions`
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Tabla model_has_permissions: Sin datos


-- Estructura de tabla `model_has_roles`
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla model_has_roles: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `model_has_roles` (completo)
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
('1', 'App\\Models\\User', '1'),
('2', 'App\\Models\\User', '2'),
('4', 'App\\Models\\User', '3'),
('5', 'App\\Models\\User', '4'),
('5', 'App\\Models\\User', '5'),
('5', 'App\\Models\\User', '6'),
('5', 'App\\Models\\User', '7'),
('5', 'App\\Models\\User', '8'),
('5', 'App\\Models\\User', '9');


-- Estructura de tabla `notifications`
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_user_id_read_at_index` (`user_id`,`read_at`),
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla notifications: Sin datos en el rango de fechas


-- Estructura de tabla `pais`
DROP TABLE IF EXISTS `pais`;
CREATE TABLE `pais` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso2` varchar(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso3` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_telefonico` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moneda_principal` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `simbolo_moneda` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idioma_principal` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continente` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zona_horaria` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `formato_fecha` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dd/mm/yyyy',
  `formato_moneda` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.234,56',
  `impuesto_predeterminado` decimal(5,2) NOT NULL DEFAULT '0.00',
  `separador_miles` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `separador_decimales` varchar(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `decimales_moneda` int NOT NULL DEFAULT '2',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pais_codigo_iso2_unique` (`codigo_iso2`),
  UNIQUE KEY `pais_codigo_iso3_unique` (`codigo_iso3`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pais: Sin datos en el rango de fechas


-- Estructura de tabla `password_reset_tokens`
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla password_reset_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_historial`
DROP TABLE IF EXISTS `pedido_historial`;
CREATE TABLE `pedido_historial` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `estado` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `usuario_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_historial_pedido_id_foreign` (`pedido_id`),
  KEY `pedido_historial_usuario_id_foreign` (`usuario_id`),
  CONSTRAINT `pedido_historial_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_historial_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedido_historial: Sin datos en el rango de fechas


-- Estructura de tabla `pedido_pago`
DROP TABLE IF EXISTS `pedido_pago`;
CREATE TABLE `pedido_pago` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `caja_id` bigint unsigned DEFAULT NULL,
  `fecha` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` decimal(15,2) DEFAULT NULL,
  `referencia` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metodo_pago` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `nota` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDENTE',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_pago_empresaid_foreign` (`empresaId`),
  KEY `pedido_pago_userid_foreign` (`userId`),
  KEY `pedido_pago_pedidoid_foreign` (`pedidoId`),
  KEY `pedido_pago_caja_id_foreign` (`caja_id`),
  CONSTRAINT `pedido_pago_caja_id_foreign` FOREIGN KEY (`caja_id`) REFERENCES `cajas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pedido_pago_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedido_pago: Sin datos en el rango de fechas


-- Estructura de tabla `pedidos`
DROP TABLE IF EXISTS `pedidos`;
CREATE TABLE `pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `fecha_entrega` timestamp NULL DEFAULT NULL,
  `total_usd` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo_pago` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ubicacion` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitud` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitud` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nota` text COLLATE utf8mb4_unicode_ci,
  `estado` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedidos_empresaid_foreign` (`empresaId`),
  KEY `pedidos_userid_foreign` (`userId`),
  CONSTRAINT `pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla pedidos: Sin datos en el rango de fechas


-- Estructura de tabla `permissions`
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`),
  KEY `permissions_module_index` (`module`)
) ENGINE=InnoDB AUTO_INCREMENT=178 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `permissions` (filtrado)
INSERT INTO `permissions` (`id`, `name`, `module`, `guard_name`, `created_at`, `updated_at`) VALUES
('174', 'access database backup', 'monitoreo', 'web', '2025-11-28 12:20:43', '2025-11-28 12:20:43'),
('175', 'create database backup', 'monitoreo', 'web', '2025-11-28 12:20:43', '2025-11-28 12:20:43'),
('176', 'access database import', 'monitoreo', 'web', '2025-11-28 12:20:43', '2025-11-28 12:20:43'),
('177', 'create database import', 'monitoreo', 'web', '2025-11-28 12:20:43', '2025-11-28 12:20:43');


-- Estructura de tabla `personal_access_tokens`
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_expires_at_index` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla personal_access_tokens: Sin datos en el rango de fechas


-- Estructura de tabla `product_batches`
DROP TABLE IF EXISTS `product_batches`;
CREATE TABLE `product_batches` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `batch_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `initial_quantity` int NOT NULL,
  `current_quantity` int NOT NULL,
  `manufacturing_date` date NOT NULL,
  `expiry_date` date NOT NULL,
  `supplier` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cost_per_unit` decimal(10,2) DEFAULT NULL,
  `status` enum('active','expired','recalled','sold_out') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'active',
  `notes` text COLLATE utf8mb4_unicode_ci,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_batches_empresa_id_foreign` (`empresa_id`),
  KEY `product_batches_producto_id_batch_number_index` (`producto_id`,`batch_number`),
  KEY `product_batches_expiry_date_status_index` (`expiry_date`,`status`),
  CONSTRAINT `product_batches_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `product_batches_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_batches: Sin datos en el rango de fechas


-- Estructura de tabla `product_reviews`
DROP TABLE IF EXISTS `product_reviews`;
CREATE TABLE `product_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` tinyint unsigned NOT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci,
  `verified_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_reviews_producto_id_user_id_unique` (`producto_id`,`user_id`),
  KEY `product_reviews_user_id_foreign` (`user_id`),
  KEY `product_reviews_producto_id_is_approved_index` (`producto_id`,`is_approved`),
  CONSTRAINT `product_reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla product_reviews: Sin datos en el rango de fechas


-- Estructura de tabla `producto_inventory_settings`
DROP TABLE IF EXISTS `producto_inventory_settings`;
CREATE TABLE `producto_inventory_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `low_stock_threshold` int NOT NULL DEFAULT '5',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_inventory_settings_producto_id_index` (`producto_id`),
  KEY `producto_inventory_settings_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_inventory_settings_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_inventory_settings_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_inventory_settings` (filtrado)
INSERT INTO `producto_inventory_settings` (`id`, `producto_id`, `track_inventory`, `allow_backorder`, `inventory_policy`, `low_stock_threshold`, `empresa_id`, `created_at`, `updated_at`) VALUES
('1', '272', '1', '0', 'deny', '5', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10');


-- Estructura de tabla `producto_seo`
DROP TABLE IF EXISTS `producto_seo`;
CREATE TABLE `producto_seo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_seo_producto_id_index` (`producto_id`),
  KEY `producto_seo_empresa_id_index` (`empresa_id`),
  KEY `producto_seo_sku_index` (`sku`),
  KEY `producto_seo_barcode_index` (`barcode`),
  CONSTRAINT `producto_seo_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_seo_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_seo` (filtrado)
INSERT INTO `producto_seo` (`id`, `producto_id`, `sku`, `barcode`, `meta_title`, `meta_description`, `tags`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
('11', '42', 'CHIMO-EL-APURENO-IZGI', '', '', '', '', '0', '1', '2025-11-28 09:43:04', '2025-11-28 09:43:36'),
('12', '43', 'CHIMO-EL-TIGRITO-AMARILLO-DZIS', '', '', '', '', '0', '1', '2025-11-28 09:44:56', '2025-11-28 09:44:56'),
('13', '44', 'CIGARRILLOS-NOVA-LUCKY-STRIKE-SUTS', '', '', '', '', '0', '1', '2025-11-28 09:52:23', '2025-11-28 09:52:23'),
('14', '46', 'CIGARROS-ECLIPSE-LUCKY-STRIKE-JD8V', '', '', '', '', '0', '1', '2025-11-28 09:55:34', '2025-11-28 09:55:34'),
('15', '47', 'CIGARROS-10UND-BELMONT-3RYX', '', '', '', '', '0', '1', '2025-11-28 09:56:00', '2025-11-28 09:56:00'),
('16', '271', '', '', '', '', '', '0', '1', '2025-11-28 09:56:48', '2025-11-28 09:56:48'),
('17', '48', 'CIGARROS-20UND-BELMONT-YZCD', '', '', '', '', '0', '1', '2025-11-28 09:57:25', '2025-11-28 09:57:25'),
('19', '50', 'CIGARROS-VICEROY-12PP', '', '', '', '', '0', '1', '2025-11-28 09:59:09', '2025-11-28 09:59:09'),
('20', '51', 'CIGARROS-20UND-UNIVERSAL-QUXC', '', '', '', '', '0', '1', '2025-11-28 10:02:06', '2025-11-28 10:02:06'),
('21', '272', 'CIGARRILLOS-CONSUL-4PJP', '', '', '', '', '0', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('22', '273', 'CIGARRILLOS-PALL-MALL-ZZTR', '', '', '', '', '0', '1', '2025-11-28 10:50:10', '2025-11-28 10:50:10'),
('23', '60', 'PRINGLES-QUESO-CHEDDAR-DHDD', '', '', '', '', '0', '1', '2025-11-28 11:12:11', '2025-11-28 11:12:11'),
('24', '61', 'PRINGLES-BARBACOA-BBQ-GAVH', '', '', '', '', '0', '1', '2025-11-28 11:23:44', '2025-11-28 11:23:44'),
('25', '63', 'PRINGLES-PIZZA-QAVT', '', '', '', '', '0', '1', '2025-11-28 11:24:39', '2025-11-28 11:24:39'),
('26', '59', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '', '', '', '', '0', '1', '2025-11-28 11:25:55', '2025-11-28 11:25:55'),
('27', '58', 'PRINGLES-ORIGINAL-GVGB', '', '', '', '', '0', '1', '2025-11-28 11:30:34', '2025-11-28 11:30:34'),
('28', '66', 'TOSTONES-CON-AJO-TOM-ZVZI', '', '', '', '', '0', '1', '2025-11-28 11:34:21', '2025-11-28 11:34:21'),
('29', '200', 'GATORADE-AZUL-8XC0', '', '', '', '', '0', '1', '2025-11-28 11:51:54', '2025-11-28 11:51:54'),
('30', '201', 'GATORADE-MANDARINA-EZMH', '', '', '', '', '0', '1', '2025-11-28 11:52:31', '2025-11-28 11:52:31'),
('31', '202', 'GATORADE-TROPICAL-UVHH', '', '', '', '', '0', '1', '2025-11-28 11:53:05', '2025-11-28 11:53:05'),
('32', '185', 'JUGO-SPEED-KBUD', '', '', '', '', '0', '1', '2025-11-28 11:54:21', '2025-11-28 11:54:21'),
('33', '186', 'JUGO-SPEED-LATA-6B2X', '', '', '', '', '0', '1', '2025-11-28 11:54:50', '2025-11-28 11:54:50'),
('34', '85', 'PAPEL-HIGIENICO-LUCIANO-8AUB', '', '', '', '', '0', '1', '2025-11-28 13:22:35', '2025-11-28 13:22:35');


-- Estructura de tabla `producto_variants`
DROP TABLE IF EXISTS `producto_variants`;
CREATE TABLE `producto_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` json NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `image_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_thumbnail_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_variants_producto_id_index` (`producto_id`),
  KEY `producto_variants_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_variants_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_variants_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `producto_variants` (filtrado)
INSERT INTO `producto_variants` (`id`, `producto_id`, `name`, `values`, `sku`, `price_adjustment`, `precio_bs`, `quantity`, `image_path`, `image_thumbnail_path`, `alt_text`, `empresa_id`, `created_at`, `updated_at`) VALUES
('72', '42', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-APURENO-IZGI', '0.00', '0.00', '1000', NULL, NULL, 'Cantidad: 1 und - Chimo el apureño', '1', '2025-11-21 01:13:56', '2025-11-28 09:56:26'),
('73', '43', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CHIMO-EL-TIGRITO-AMARILLO-DZIS', '0.00', '0.00', '200', NULL, NULL, 'Cantidad: 1 und - Chimo El Tigrito Amarillo', '1', '2025-11-21 01:13:56', '2025-11-28 09:49:27'),
('74', '44', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARRILLOS-NOVA-LUCKY-STRIKE-SUTS', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarrillos Nova Lucky Strike Cosmic', '1', '2025-11-21 01:13:56', '2025-11-28 09:52:23'),
('76', '46', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARROS-ECLIPSE-LUCKY-STRIKE-JD8V', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarros Eclipse Lucky Strike', '1', '2025-11-21 01:13:56', '2025-11-28 09:55:34'),
('77', '47', 'Cantidad: 10 und', '{\"Cantidad: 10 und\": \"10 und\"}', 'CIGARROS-10UND-BELMONT-3RYX', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 10 und - Cigarros 10und Belmont', '1', '2025-11-21 01:13:56', '2025-11-28 09:56:00'),
('78', '48', 'Cantidad: 20 und', '{\"Cantidad: 20 und\": \"20 und\"}', 'CIGARROS-20UND-BELMONT-YZCD', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Belmont', '1', '2025-11-21 01:13:56', '2025-11-28 09:57:25'),
('80', '50', 'Cantidad: 1 und', '{\"Cantidad: 1 und\": \"1 und\"}', 'CIGARROS-VICEROY-12PP', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 1 und - Cigarros Viceroy', '1', '2025-11-21 01:13:56', '2025-11-28 09:59:09'),
('81', '51', 'Cantidad: 20 und', '{\"Cantidad: 20 und\": \"20 und\"}', 'CIGARROS-20UND-UNIVERSAL-QUXC', '0.00', '0.00', '100', NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Universal', '1', '2025-11-21 01:13:56', '2025-11-28 10:02:06'),
('88', '58', 'peso', '{\"Peso\": \"100g\"}', 'PRINGLES-ORIGINAL-GVGB', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Original', '1', '2025-11-21 01:13:56', '2025-11-28 11:31:40'),
('90', '59', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Crema y Cebolla', '1', '2025-11-21 01:13:56', '2025-11-28 11:29:53'),
('92', '60', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-QUESO-CHEDDAR-DHDD', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Queso Cheddar', '1', '2025-11-21 01:13:57', '2025-11-28 11:14:02'),
('94', '61', 'peso', '{\"Peso\": \"110g, 100g\"}', 'PRINGLES-BARBACOA-BBQ-GAVH', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Barbacoa BBQ', '1', '2025-11-21 01:13:57', '2025-11-28 11:27:37'),
('98', '63', 'peso', '{\"Peso\": \"110g\"}', 'PRINGLES-PIZZA-QAVT', '0.00', '0.00', '100', NULL, NULL, 'Peso: 110g - Pringles Pizza', '1', '2025-11-21 01:13:57', '2025-11-28 11:28:51'),
('130', '85', 'presentacion', '{\"Presentacion\": \"Paquete de 4 rollos\"}', 'PAPEL-HIGIENICO-LUCIANO-8AUB', '0.00', '0.00', '100', NULL, NULL, 'Presentación: Paquete de 4 rollos - Papel Higienico Luciano', '1', '2025-11-21 01:13:57', '2025-11-28 13:22:35'),
('250', '185', 'volumen', '{\"Volumen\": \"1L\"}', 'JUGO-SPEED-KBUD', '0.00', '0.00', '70', NULL, NULL, 'Volumen: 1LT - Jugo Speed', '1', '2025-11-21 01:13:57', '2025-11-28 11:57:27'),
('406', '272', 'unidades', '{\"Unidades\": \"20 unidades\"}', 'CIGARRILLOS-CONSUL-4PJP', '0.00', '0.00', '5000', NULL, NULL, '', '1', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('407', '273', 'unidades', '{\"Unidades\": \"20 unidades\"}', 'CIGARRILLOS-PALL-MALL-ZZTR', '0.00', '0.00', '0', 'productos/1764342336_variant_0.jpg', 'productos/thumb_1764342336_variant_0.jpg', '', '1', '2025-11-28 10:50:11', '2025-11-28 11:05:36'),
('408', '273', 'unidades', '{\"Unidades\": \"10 unidades\"}', 'CIGARRILLOS-PALL-MALL-ZZTR', '0.00', '0.00', '0', 'productos/1764341758_variant_1.jpg', 'productos/thumb_1764341758_variant_1.jpg', '', '1', '2025-11-28 10:54:01', '2025-11-28 11:05:36'),
('409', '60', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-QUESO-CHEDDAR-DHDD', '0.00', '0.00', '0', 'productos/1764342842_variant_1.jpg', 'productos/thumb_1764342842_variant_1.jpg', '', '1', '2025-11-28 11:14:02', '2025-11-28 11:14:02'),
('410', '61', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-BARBACOA-BBQ-GAVH', '0.00', '0.00', '0', 'productos/1764343657_variant_1.jpg', 'productos/thumb_1764343657_variant_1.jpg', '', '1', '2025-11-28 11:27:37', '2025-11-28 11:27:37'),
('411', '59', 'peso', '\"{\\\"Peso\\\":\\\"71g\\\"}\"', 'PRINGLES-CREMA-Y-CEBOLLA-9TGM', '0.00', '0.00', '0', 'productos/1764343793_variant_1.jpg', 'productos/thumb_1764343793_variant_1.jpg', '', '1', '2025-11-28 11:29:53', '2025-11-28 11:29:53'),
('412', '58', 'peso', '{\"Peso\": \"71g\"}', 'PRINGLES-ORIGINAL-GVGB', '0.00', '0.00', '0', 'productos/1764343873_variant_1.jpg', 'productos/thumb_1764343873_variant_1.jpg', '', '1', '2025-11-28 11:31:13', '2025-11-28 11:31:40'),
('413', '66', 'peso', '{\"Peso\": \"140g\"}', 'TOSTONES-CON-AJO-TOM-ZVZI', '0.00', '0.00', '0', NULL, NULL, '', '1', '2025-11-28 11:34:21', '2025-11-28 11:38:08'),
('414', '66', 'peso', '{\"Peso\": \"28g\"}', 'TOSTONES-CON-AJO-TOM-ZVZI', '7.00', '8.00', '0', 'productos/1764344177_variant_1.jpg', 'productos/thumb_1764344177_variant_1.jpg', '', '1', '2025-11-28 11:36:17', '2025-11-28 11:38:08');


-- Estructura de tabla `productos`
DROP TABLE IF EXISTS `productos`;
CREATE TABLE `productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `batch_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `requires_batch_tracking` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `tags` text COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text COLLATE utf8mb4_unicode_ci,
  `has_variants` tinyint(1) NOT NULL DEFAULT '0',
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `quantity` int NOT NULL DEFAULT '0',
  `quantity_alert` int NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `categoria_id` bigint unsigned NOT NULL,
  `marca_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productos_code_unique` (`code`),
  KEY `productos_empresa_id_index` (`empresa_id`),
  KEY `productos_categoria_id_index` (`categoria_id`),
  KEY `productos_marca_id_index` (`marca_id`),
  KEY `productos_name_index` (`name`),
  KEY `productos_price_index` (`price`),
  KEY `productos_quantity_index` (`quantity`),
  KEY `productos_status_quantity_index` (`status`,`quantity`),
  CONSTRAINT `productos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=274 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Datos de tabla `productos` (filtrado)
INSERT INTO `productos` (`id`, `code`, `sku`, `barcode`, `batch_number`, `expiry_date`, `requires_batch_tracking`, `name`, `price`, `precio_bs`, `description`, `tags`, `meta_title`, `meta_description`, `has_variants`, `track_inventory`, `featured`, `allow_backorder`, `inventory_policy`, `quantity`, `quantity_alert`, `status`, `empresa_id`, `categoria_id`, `marca_id`, `created_at`, `updated_at`) VALUES
('11', 'SAL-71890', NULL, NULL, NULL, NULL, '0', 'Salsa de Tomate', '1.50', '52.50', 'Salsa de tomate tradicional', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '90', '10', '0', '1', '1', '1', '2025-11-21 01:13:56', '2025-11-28 11:32:47'),
('38', 'ARR-64433', NULL, NULL, NULL, NULL, '0', 'Arroz Blanco Pringles', '2.60', '91.00', 'Arroz blanco de alta calidad', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '13', '2025-11-21 01:13:56', '2025-11-28 11:24:58'),
('39', 'HAR-69736', NULL, NULL, NULL, NULL, '0', 'Harina de Maíz Precocida Pringles', '2.30', '80.50', 'Harina de maíz precocida para arepas', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '13', '2025-11-21 01:13:56', '2025-11-28 11:25:03'),
('40', 'ARR-98862', NULL, NULL, NULL, NULL, '0', 'Arroz Blanco Tom', '2.70', '94.50', 'Arroz blanco de alta calidad', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '14', '2025-11-21 01:13:56', '2025-11-28 11:32:47'),
('41', 'HAR-27341', NULL, NULL, NULL, NULL, '0', 'Harina de Maíz Precocida Tom', '2.40', '84.00', 'Harina de maíz precocida para arepas', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '150', '10', '0', '1', '1', '14', '2025-11-21 01:13:56', '2025-11-28 11:32:48'),
('44', 'CIG-75268', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Nova Lucky Strike', '3.65', '127.75', 'Cigarrillos Nova Lucky Strike (COSMIC)', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '1', '1', '2', '15', '2025-11-21 01:13:56', '2025-11-28 09:52:23'),
('45', 'CIG-10525', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Lucky Strike Red', '3.39', '118.65', 'Cigarrillos Lucky Strike Red', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '2', '15', '2025-11-21 01:13:56', '2025-11-28 09:55:16'),
('60', 'PRI-79083', NULL, NULL, NULL, NULL, '0', 'Pringles Queso Cheddar', '2.50', '87.50', 'Papas fritas sabor queso cheddar', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:12:11'),
('61', 'PRI-61948', NULL, NULL, NULL, NULL, '0', 'Pringles Barbacoa BBQ', '2.50', '87.50', 'Papas fritas sabor barbacoa BBQ', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:10'),
('62', 'PRI-54900', NULL, NULL, NULL, NULL, '0', 'Pringles Ranch', '2.50', '87.50', 'Papas fritas sabor ranch en presentación de 110g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:13'),
('63', 'PRI-81096', NULL, NULL, NULL, NULL, '0', 'Pringles Pizza', '2.50', '87.50', 'Papas fritas sabor a pizza ', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '180', '10', '1', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:28:51'),
('64', 'PRI-22822', NULL, NULL, NULL, NULL, '0', 'Pringles Enchilada', '2.70', '94.50', 'Papas fritas sabor enchilada en presentación de 124g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:25:09'),
('65', 'PRI-25450', NULL, NULL, NULL, NULL, '0', 'Pringles Habanero', '2.70', '94.50', 'Papas fritas sabor habanero en presentación de 124g', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '3', '13', '2025-11-21 01:13:57', '2025-11-28 11:24:59'),
('67', 'TOS-92373', NULL, NULL, NULL, NULL, '0', 'Tostones Natural Tom', '1.43', '50.05', 'Tostones naturales sin condimentos', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '300', '10', '0', '1', '3', '14', '2025-11-21 01:13:57', '2025-11-28 11:33:04'),
('213', 'DOR-12919', NULL, NULL, NULL, NULL, '0', 'Doritos Nacho Cheese', '2.25', '78.75', 'Tortilla chips sabor queso nacho', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '80', '10', '0', '1', '7', '28', '2025-11-21 01:13:57', '2025-11-28 11:22:03'),
('215', 'DOR-29446', NULL, NULL, NULL, NULL, '0', 'Doritos Mega Queso', '2.45', '85.75', 'Tortilla chips mega queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '70', '10', '0', '1', '7', '28', '2025-11-21 01:13:57', '2025-11-28 11:22:04'),
('216', 'CHE-78983', NULL, NULL, NULL, NULL, '0', 'Cheese Tris 50g', '1.25', '43.75', 'Snack de queso triangular', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '100', '10', '0', '1', '7', '56', '2025-11-21 01:13:57', '2025-11-28 11:22:08'),
('218', 'PUF-62852', NULL, NULL, NULL, NULL, '0', 'Puffy Sabor a Queso', '1.15', '40.25', 'Snack inflado sabor queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '90', '10', '0', '1', '7', '89', '2025-11-21 01:13:57', '2025-11-28 11:22:11'),
('219', 'PUF-10480', NULL, NULL, NULL, NULL, '0', 'Puffy Sabor a Tomate con Albahaca', '1.15', '40.25', 'Snack inflado sabor tomate albahaca', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '85', '10', '0', '1', '7', '89', '2025-11-21 01:13:57', '2025-11-28 11:32:46'),
('224', 'RUF-16260', NULL, NULL, NULL, NULL, '0', 'Ruffles Queso y Cebolla', '2.10', '73.50', 'Papas fritas onduladas sabor queso y cebolla', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '75', '10', '0', '1', '7', '30', '2025-11-21 01:13:57', '2025-11-28 11:22:15'),
('225', 'CHE-61807', NULL, NULL, NULL, NULL, '0', 'Cheetos Crunchy', '1.95', '68.25', 'Snacks de maíz sabor queso cheddar', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '85', '10', '0', '1', '7', '31', '2025-11-21 01:13:57', '2025-11-28 11:22:17'),
('230', 'RIT-86777', NULL, NULL, NULL, NULL, '0', 'Ritz Crackers Queso', '2.35', '82.25', 'Galletas saladas con sabor a queso', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '70', '10', '0', '1', '7', '33', '2025-11-21 01:13:57', '2025-11-28 11:22:18'),
('272', 'PROD-000272', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Consul', '0.00', '0.00', 'Cigarrillos Consul', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '2', '107', '2025-11-28 10:41:40', '2025-11-28 10:43:10'),
('273', 'PROD-1764341310', NULL, NULL, NULL, NULL, '0', 'Cigarrillos Pall Mall', '0.00', '0.00', 'Cigarrillos Pall Mall', NULL, NULL, NULL, '0', '1', '0', '0', 'deny', '5000', '10', '1', '1', '2', '18', '2025-11-28 10:48:30', '2025-11-28 10:50:10');


-- Estructura de tabla `referencias_bancarias`
DROP TABLE IF EXISTS `referencias_bancarias`;
CREATE TABLE `referencias_bancarias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `tipo_pago` enum('pago_movil','transferencia') COLLATE utf8mb4_unicode_ci NOT NULL,
  `banco_id` bigint unsigned NOT NULL,
  `documento` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_cuenta` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_cuenta` enum('ahorro','corriente') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referencia` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_restante` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `referencias_bancarias_pedido_id_foreign` (`pedido_id`),
  KEY `referencias_bancarias_banco_id_foreign` (`banco_id`),
  CONSTRAINT `referencias_bancarias_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `bancos` (`id`),
  CONSTRAINT `referencias_bancarias_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla referencias_bancarias: Sin datos en el rango de fechas


-- Estructura de tabla `resenas`
DROP TABLE IF EXISTS `resenas`;
CREATE TABLE `resenas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `calificacion` tinyint unsigned NOT NULL COMMENT '1-5 estrellas',
  `comentario` text COLLATE utf8mb4_unicode_ci,
  `aprobada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resenas_user_id_foreign` (`user_id`),
  KEY `resenas_producto_id_foreign` (`producto_id`),
  KEY `resenas_pedido_id_producto_id_index` (`pedido_id`,`producto_id`),
  KEY `resenas_calificacion_index` (`calificacion`),
  KEY `resenas_aprobada_index` (`aprobada`),
  CONSTRAINT `resenas_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla resenas: Sin datos en el rango de fechas


-- Estructura de tabla `reunions`
DROP TABLE IF EXISTS `reunions`;
CREATE TABLE `reunions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text COLLATE utf8mb4_unicode_ci,
  `fecha_inicio` datetime NOT NULL,
  `fecha_fin` datetime NOT NULL,
  `ubicacion` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` enum('programada','en_curso','finalizada','cancelada') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'programada',
  `color` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#007bff',
  `participantes` json DEFAULT NULL,
  `creado_por` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reunions_creado_por_foreign` (`creado_por`),
  KEY `reunions_empresa_id_foreign` (`empresa_id`),
  KEY `reunions_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `reunions_creado_por_foreign` FOREIGN KEY (`creado_por`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reunions: Sin datos en el rango de fechas


-- Estructura de tabla `reviews`
DROP TABLE IF EXISTS `reviews`;
CREATE TABLE `reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL DEFAULT '5',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_empresa_id_foreign` (`empresa_id`),
  KEY `reviews_producto_id_approved_index` (`producto_id`,`approved`),
  KEY `reviews_user_id_index` (`user_id`),
  CONSTRAINT `reviews_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla reviews: Sin datos en el rango de fechas


-- Estructura de tabla `role_has_permissions`
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla role_has_permissions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `role_has_permissions` (completo)
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
('1', '1'),
('2', '1'),
('3', '1'),
('4', '1'),
('5', '1'),
('6', '1'),
('7', '1'),
('8', '1'),
('9', '1'),
('10', '1'),
('11', '1'),
('12', '1'),
('13', '1'),
('14', '1'),
('15', '1'),
('16', '1'),
('17', '1'),
('18', '1'),
('19', '1'),
('20', '1'),
('21', '1'),
('22', '1'),
('23', '1'),
('24', '1'),
('25', '1'),
('26', '1'),
('27', '1'),
('28', '1'),
('29', '1'),
('30', '1'),
('31', '1'),
('32', '1'),
('33', '1'),
('34', '1'),
('35', '1'),
('36', '1'),
('37', '1'),
('38', '1'),
('39', '1'),
('40', '1'),
('41', '1'),
('42', '1'),
('43', '1'),
('44', '1'),
('45', '1'),
('46', '1'),
('47', '1'),
('48', '1'),
('49', '1'),
('50', '1'),
('51', '1'),
('52', '1'),
('53', '1'),
('54', '1'),
('55', '1'),
('56', '1'),
('57', '1'),
('58', '1'),
('59', '1'),
('60', '1'),
('61', '1'),
('62', '1'),
('63', '1'),
('64', '1'),
('65', '1'),
('66', '1'),
('67', '1'),
('68', '1'),
('69', '1'),
('70', '1'),
('71', '1'),
('72', '1'),
('73', '1'),
('74', '1'),
('75', '1'),
('76', '1'),
('77', '1'),
('78', '1'),
('79', '1'),
('80', '1'),
('81', '1'),
('82', '1'),
('83', '1'),
('84', '1'),
('85', '1'),
('86', '1'),
('87', '1'),
('88', '1'),
('89', '1'),
('90', '1'),
('91', '1'),
('92', '1'),
('93', '1'),
('94', '1'),
('95', '1'),
('96', '1'),
('97', '1'),
('98', '1'),
('99', '1'),
('100', '1'),
('101', '1'),
('102', '1'),
('103', '1'),
('104', '1'),
('105', '1'),
('106', '1'),
('107', '1'),
('108', '1'),
('109', '1'),
('110', '1'),
('111', '1'),
('112', '1'),
('113', '1'),
('114', '1'),
('115', '1'),
('116', '1'),
('117', '1'),
('118', '1'),
('119', '1'),
('120', '1'),
('121', '1'),
('122', '1'),
('123', '1'),
('124', '1'),
('125', '1'),
('126', '1'),
('127', '1'),
('128', '1'),
('129', '1'),
('130', '1'),
('131', '1'),
('132', '1'),
('133', '1'),
('134', '1'),
('135', '1'),
('136', '1'),
('137', '1'),
('138', '1'),
('139', '1'),
('140', '1'),
('141', '1'),
('142', '1'),
('143', '1'),
('144', '1'),
('145', '1'),
('146', '1'),
('147', '1'),
('148', '1'),
('149', '1'),
('150', '1'),
('151', '1'),
('152', '1'),
('153', '1'),
('154', '1'),
('155', '1'),
('156', '1'),
('157', '1'),
('158', '1'),
('159', '1'),
('160', '1'),
('161', '1'),
('162', '1'),
('163', '1'),
('164', '1'),
('165', '1'),
('166', '1'),
('167', '1'),
('168', '1'),
('169', '1'),
('170', '1'),
('171', '1'),
('172', '1'),
('173', '1'),
('174', '1'),
('175', '1'),
('176', '1'),
('177', '1'),
('1', '2'),
('2', '2'),
('3', '2'),
('4', '2'),
('5', '2'),
('6', '2'),
('7', '2'),
('8', '2'),
('9', '2'),
('10', '2'),
('11', '2'),
('12', '2'),
('13', '2'),
('14', '2'),
('15', '2'),
('16', '2'),
('17', '2'),
('18', '2'),
('19', '2'),
('20', '2'),
('22', '2'),
('23', '2'),
('24', '2'),
('25', '2'),
('27', '2'),
('28', '2'),
('29', '2'),
('30', '2'),
('31', '2'),
('32', '2'),
('33', '2'),
('34', '2'),
('35', '2'),
('36', '2'),
('37', '2'),
('38', '2'),
('39', '2'),
('40', '2'),
('41', '2'),
('42', '2'),
('43', '2'),
('44', '2'),
('45', '2'),
('46', '2'),
('47', '2'),
('48', '2'),
('49', '2'),
('50', '2'),
('51', '2'),
('52', '2'),
('53', '2'),
('54', '2'),
('55', '2'),
('56', '2'),
('57', '2'),
('58', '2'),
('59', '2'),
('60', '2'),
('61', '2'),
('62', '2'),
('63', '2'),
('64', '2'),
('65', '2'),
('66', '2'),
('67', '2'),
('68', '2'),
('69', '2'),
('70', '2'),
('71', '2'),
('72', '2'),
('73', '2'),
('74', '2'),
('75', '2'),
('76', '2'),
('77', '2'),
('78', '2'),
('79', '2'),
('80', '2'),
('81', '2'),
('82', '2'),
('83', '2'),
('84', '2'),
('85', '2'),
('86', '2'),
('87', '2'),
('88', '2'),
('89', '2'),
('90', '2'),
('91', '2'),
('92', '2'),
('93', '2'),
('94', '2'),
('95', '2'),
('96', '2'),
('97', '2'),
('98', '2'),
('99', '2'),
('100', '2'),
('101', '2'),
('102', '2'),
('103', '2'),
('104', '2'),
('105', '2'),
('106', '2'),
('107', '2'),
('108', '2'),
('109', '2'),
('110', '2'),
('111', '2'),
('112', '2'),
('113', '2'),
('114', '2'),
('115', '2'),
('116', '2'),
('117', '2'),
('118', '2'),
('119', '2'),
('120', '2'),
('121', '2'),
('122', '2'),
('123', '2'),
('124', '2'),
('125', '2'),
('126', '2'),
('127', '2'),
('128', '2'),
('129', '2'),
('130', '2'),
('131', '2'),
('132', '2'),
('133', '2'),
('134', '2'),
('135', '2'),
('136', '2'),
('137', '2'),
('138', '2'),
('139', '2'),
('140', '2'),
('141', '2'),
('142', '2'),
('143', '2'),
('144', '2'),
('145', '2'),
('146', '2'),
('147', '2'),
('148', '2'),
('149', '2'),
('150', '2'),
('151', '2'),
('152', '2'),
('153', '2'),
('154', '2'),
('155', '2'),
('156', '2'),
('157', '2'),
('158', '2'),
('159', '2'),
('160', '2'),
('161', '2'),
('162', '2'),
('163', '2'),
('164', '2'),
('165', '2'),
('166', '2'),
('167', '2'),
('168', '2'),
('169', '2'),
('170', '2'),
('171', '2'),
('172', '2'),
('173', '2'),
('174', '2'),
('175', '2'),
('176', '2'),
('177', '2'),
('43', '3'),
('44', '3'),
('45', '3'),
('46', '3'),
('47', '3'),
('48', '3'),
('49', '3'),
('50', '3'),
('69', '3'),
('70', '3'),
('71', '3'),
('72', '3'),
('73', '3'),
('74', '3'),
('75', '3'),
('76', '3'),
('77', '3'),
('78', '3'),
('79', '3'),
('137', '4'),
('138', '4'),
('139', '4'),
('140', '4'),
('141', '4'),
('142', '4'),
('143', '4'),
('144', '4'),
('145', '4'),
('146', '4'),
('147', '4'),
('148', '4'),
('149', '4'),
('150', '4'),
('151', '4'),
('137', '5'),
('138', '5'),
('139', '5'),
('140', '5'),
('141', '5'),
('142', '5'),
('143', '5'),
('144', '5'),
('145', '5'),
('146', '5'),
('147', '5'),
('148', '5'),
('149', '5');


-- Estructura de tabla `roles`
DROP TABLE IF EXISTS `roles`;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla roles: Sin datos en el rango de fechas


-- Estructura de tabla `series`
DROP TABLE IF EXISTS `series`;
CREATE TABLE `series` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo_documento` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `correlativo_actual` int NOT NULL DEFAULT '0',
  `longitud_correlativo` int NOT NULL DEFAULT '8',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series_serie_empresa_id_sucursal_id_unique` (`serie`,`empresa_id`,`sucursal_id`),
  KEY `series_empresa_id_foreign` (`empresa_id`),
  KEY `series_sucursal_id_foreign` (`sucursal_id`),
  KEY `series_tipo_documento_empresa_id_sucursal_id_activo_index` (`tipo_documento`,`empresa_id`,`sucursal_id`,`activo`),
  CONSTRAINT `series_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `series_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla series: Sin datos en el rango de fechas


-- Estructura de tabla `sessions`
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sessions: Sin columnas de fecha, respaldando todos los datos
-- Datos de tabla `sessions` (completo)
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
('64I9Zcj3TbreJF8uOKeqaEcXsOVw1iLyKUtYdIoz', '2', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', '1764350938');


-- Estructura de tabla `sucursales`
DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE `sucursales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `nombre` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sucursales_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `sucursales_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla sucursales: Sin datos en el rango de fechas


-- Estructura de tabla `template_customizations`
DROP TABLE IF EXISTS `template_customizations`;
CREATE TABLE `template_customizations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `primary_color` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#7367F0',
  `skin` int NOT NULL DEFAULT '0',
  `theme` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `semi_dark` tinyint(1) NOT NULL DEFAULT '0',
  `content_layout` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'compact',
  `header_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `menu_collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `navbar_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sticky',
  `text_direction` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ltr',
  `footer_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `dropdown_on_hover` tinyint(1) NOT NULL DEFAULT '0',
  `layout_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'vertical',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla template_customizations: Sin datos en el rango de fechas


-- Estructura de tabla `users`
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `bio` text COLLATE utf8mb4_unicode_ci,
  `notifications_email` tinyint(1) NOT NULL DEFAULT '1',
  `notifications_sms` tinyint(1) NOT NULL DEFAULT '0',
  `notifications_push` tinyint(1) NOT NULL DEFAULT '1',
  `telefono` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verification_code` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_secret` text COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` json DEFAULT NULL,
  `two_factor_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `verification_code_sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `empresa_id` bigint unsigned DEFAULT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `avatar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_devices` json DEFAULT NULL,
  `common_locations` json DEFAULT NULL,
  `total_session_time` int NOT NULL DEFAULT '0',
  `security_alerts` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `api_token` varchar(80) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_api_token_unique` (`api_token`),
  KEY `users_empresa_id_foreign` (`empresa_id`),
  KEY `users_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `users_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla users: Sin datos en el rango de fechas


-- Estructura de tabla `wishlists`
DROP TABLE IF EXISTS `wishlists`;
CREATE TABLE `wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wishlists_user_id_producto_id_unique` (`user_id`,`producto_id`),
  KEY `wishlists_producto_id_foreign` (`producto_id`),
  CONSTRAINT `wishlists_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wishlists_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabla wishlists: Sin datos en el rango de fechas

