-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Versión del servidor:         8.0.30 - MySQL Community Server - GPL
-- SO del servidor:              Win64
-- HeidiSQL Versión:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Volcando estructura para tabla laravel.active_sessions
DROP TABLE IF EXISTS `active_sessions`;
CREATE TABLE IF NOT EXISTS `active_sessions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `session_id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ip_address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `last_activity` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `login_at` timestamp NULL DEFAULT NULL,
  `logout_at` timestamp NULL DEFAULT NULL,
  `is_current` tinyint(1) NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `active_sessions_user_id_session_id_index` (`user_id`,`session_id`),
  CONSTRAINT `active_sessions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.active_sessions: ~14 rows (aproximadamente)
DELETE FROM `active_sessions`;
INSERT INTO `active_sessions` (`id`, `user_id`, `session_id`, `ip_address`, `user_agent`, `location`, `latitude`, `longitude`, `last_activity`, `login_at`, `logout_at`, `is_current`, `is_active`, `created_at`, `updated_at`) VALUES
	(1, 5, 'ia28W38lr74LlrErhLHLtkL4Q1WSNQbmlPIud4oQ', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49626360, -66.88133390, '2025-11-26 14:20:26', NULL, NULL, 0, 1, '2025-11-26 14:20:26', '2025-11-26 14:20:26'),
	(2, 5, 'bXcsD5d3qlVsvbtTlsF3XFHXJjtmgipJdaOwHOsw', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.43988480, -66.87293440, '2025-11-26 14:21:29', NULL, NULL, 0, 1, '2025-11-26 14:21:29', '2025-11-26 14:21:29'),
	(3, 2, 'uOWkwtILIiTtDHvxhMAzQaUUBqkFP4p1I9IzwWoa', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49625200, -66.88106900, '2025-11-26 14:22:58', NULL, NULL, 0, 1, '2025-11-26 14:22:58', '2025-11-26 14:22:58'),
	(4, 9, 'V4248tAyut71j8F31qfEClP25v2LdqOyfoFivXJA', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49625380, -66.88133010, '2025-11-26 15:33:48', NULL, NULL, 0, 1, '2025-11-26 15:33:48', '2025-11-26 15:33:48'),
	(5, 2, 'hOWtZDJvo9sMGqzw2j1FWCW6QFLGyzFqpAGgOuuY', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49626200, -66.88133560, '2025-11-26 16:03:33', NULL, NULL, 0, 1, '2025-11-26 16:03:33', '2025-11-26 16:03:33'),
	(6, 2, 'lrEWpLqe5CV8OU3AEsHBftFRr631kvgByVxFYife', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49627180, -66.88105333, '2025-11-26 20:20:38', NULL, NULL, 0, 1, '2025-11-26 20:20:38', '2025-11-26 20:20:38'),
	(7, 2, 'Q8XR8Y0MVcMQlP7tnLnJbE4Xo6fb2PclsjFxrp8Q', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49625480, -66.88133070, '2025-11-27 13:29:59', NULL, NULL, 0, 1, '2025-11-27 13:29:59', '2025-11-27 13:29:59'),
	(8, 9, 'fCSV9h0bRNfWAbvim5lID2W5MQxKmfZMzTsXCjQF', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49625480, -66.88133070, '2025-11-27 13:31:21', NULL, NULL, 0, 1, '2025-11-27 13:31:21', '2025-11-27 13:31:21'),
	(9, 9, 'bqbTRFnDOXgykxPzKklNJvlNPtoO8k3c46bAQjnN', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49626420, -66.88133660, '2025-11-27 14:20:56', NULL, NULL, 0, 1, '2025-11-27 14:20:56', '2025-11-27 14:20:56'),
	(10, 9, 'niEnEzp0JkEZZhwH03VNXrpTEyeqPiKremGLs51B', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, NULL, NULL, '2025-11-27 14:29:53', NULL, NULL, 0, 1, '2025-11-27 14:29:53', '2025-11-27 14:29:53'),
	(11, 9, 'h9njrWYX2ubmsc57ib4dTfO13tkR4GkzXhR6A3Td', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, NULL, NULL, '2025-11-27 16:47:48', NULL, NULL, 0, 1, '2025-11-27 16:47:48', '2025-11-27 16:47:48'),
	(12, 2, 'u6dsf1FoPRgYVjpQpgt00VFHhDBL63z5AXHVs9L1', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49626250, -66.88133620, '2025-11-27 17:11:44', NULL, NULL, 0, 1, '2025-11-27 17:11:44', '2025-11-27 17:11:44'),
	(13, 2, 'zFYD59MERvu2DnD9yljxAqXvTggG4Ih296AebLXi', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49367650, -66.90529020, '2025-11-27 23:09:53', NULL, NULL, 0, 1, '2025-11-27 23:09:53', '2025-11-27 23:09:53'),
	(14, 2, 'LcHSbQmpzfsgc64cjhZJp1NrNqtzZOpwDnwrHGK9', '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', NULL, 10.49626410, -66.88133670, '2025-11-28 17:43:45', NULL, NULL, 0, 1, '2025-11-28 17:43:45', '2025-11-28 17:43:45');

-- Volcando estructura para tabla laravel.activity_log
DROP TABLE IF EXISTS `activity_log`;
CREATE TABLE IF NOT EXISTS `activity_log` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject_id` bigint unsigned DEFAULT NULL,
  `causer_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `causer_id` bigint unsigned DEFAULT NULL,
  `properties` json DEFAULT NULL,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `subject` (`subject_type`,`subject_id`),
  KEY `causer` (`causer_type`,`causer_id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.activity_log: ~32 rows (aproximadamente)
DELETE FROM `activity_log`;
INSERT INTO `activity_log` (`id`, `log_name`, `description`, `subject_type`, `event`, `subject_id`, `causer_type`, `causer_id`, `properties`, `batch_uuid`, `created_at`, `updated_at`) VALUES
	(1, 'default', 'created', 'App\\Models\\Pais', 'created', 1, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Argentina", "continente": "América del Sur", "codigo_iso2": "AR", "codigo_iso3": "ARG", "idioma_principal": "es", "moneda_principal": "ARS", "codigo_telefonico": "+54"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(2, 'default', 'created', 'App\\Models\\Pais', 'created', 2, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Bolivia", "continente": "América del Sur", "codigo_iso2": "BO", "codigo_iso3": "BOL", "idioma_principal": "es", "moneda_principal": "BOB", "codigo_telefonico": "+591"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(3, 'default', 'created', 'App\\Models\\Pais', 'created', 3, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Brasil", "continente": "América del Sur", "codigo_iso2": "BR", "codigo_iso3": "BRA", "idioma_principal": "pt", "moneda_principal": "BRL", "codigo_telefonico": "+55"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(4, 'default', 'created', 'App\\Models\\Pais', 'created', 4, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Chile", "continente": "América del Sur", "codigo_iso2": "CL", "codigo_iso3": "CHL", "idioma_principal": "es", "moneda_principal": "CLP", "codigo_telefonico": "+56"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(5, 'default', 'created', 'App\\Models\\Pais', 'created', 5, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Colombia", "continente": "América del Sur", "codigo_iso2": "CO", "codigo_iso3": "COL", "idioma_principal": "es", "moneda_principal": "COP", "codigo_telefonico": "+57"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(6, 'default', 'created', 'App\\Models\\Pais', 'created', 6, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Costa Rica", "continente": "América Central", "codigo_iso2": "CR", "codigo_iso3": "CRI", "idioma_principal": "es", "moneda_principal": "CRC", "codigo_telefonico": "+506"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(7, 'default', 'created', 'App\\Models\\Pais', 'created', 7, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Cuba", "continente": "El Caribe", "codigo_iso2": "CU", "codigo_iso3": "CUB", "idioma_principal": "es", "moneda_principal": "CUP", "codigo_telefonico": "+53"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(8, 'default', 'created', 'App\\Models\\Pais', 'created', 8, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Ecuador", "continente": "América del Sur", "codigo_iso2": "EC", "codigo_iso3": "ECU", "idioma_principal": "es", "moneda_principal": "USD", "codigo_telefonico": "+593"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(9, 'default', 'created', 'App\\Models\\Pais', 'created', 9, NULL, NULL, '{"attributes": {"activo": true, "nombre": "El Salvador", "continente": "América Central", "codigo_iso2": "SV", "codigo_iso3": "SLV", "idioma_principal": "es", "moneda_principal": "USD", "codigo_telefonico": "+503"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(10, 'default', 'created', 'App\\Models\\Pais', 'created', 10, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Guatemala", "continente": "América Central", "codigo_iso2": "GT", "codigo_iso3": "GTM", "idioma_principal": "es", "moneda_principal": "GTQ", "codigo_telefonico": "+502"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(11, 'default', 'created', 'App\\Models\\Pais', 'created', 11, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Honduras", "continente": "América Central", "codigo_iso2": "HN", "codigo_iso3": "HND", "idioma_principal": "es", "moneda_principal": "HNL", "codigo_telefonico": "+504"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(12, 'default', 'created', 'App\\Models\\Pais', 'created', 12, NULL, NULL, '{"attributes": {"activo": true, "nombre": "México", "continente": "América del Norte", "codigo_iso2": "MX", "codigo_iso3": "MEX", "idioma_principal": "es", "moneda_principal": "MXN", "codigo_telefonico": "+52"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(13, 'default', 'created', 'App\\Models\\Pais', 'created', 13, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Nicaragua", "continente": "América Central", "codigo_iso2": "NI", "codigo_iso3": "NIC", "idioma_principal": "es", "moneda_principal": "NIO", "codigo_telefonico": "+505"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(14, 'default', 'created', 'App\\Models\\Pais', 'created', 14, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Panamá", "continente": "América Central", "codigo_iso2": "PA", "codigo_iso3": "PAN", "idioma_principal": "es", "moneda_principal": "USD", "codigo_telefonico": "+507"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(15, 'default', 'created', 'App\\Models\\Pais', 'created', 15, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Paraguay", "continente": "América del Sur", "codigo_iso2": "PY", "codigo_iso3": "PRY", "idioma_principal": "es", "moneda_principal": "PYG", "codigo_telefonico": "+595"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(16, 'default', 'created', 'App\\Models\\Pais', 'created', 16, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Perú", "continente": "América del Sur", "codigo_iso2": "PE", "codigo_iso3": "PER", "idioma_principal": "es", "moneda_principal": "PEN", "codigo_telefonico": "+51"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(17, 'default', 'created', 'App\\Models\\Pais', 'created', 17, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Puerto Rico", "continente": "El Caribe", "codigo_iso2": "PR", "codigo_iso3": "PRI", "idioma_principal": "es", "moneda_principal": "USD", "codigo_telefonico": "+1"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(18, 'default', 'created', 'App\\Models\\Pais', 'created', 18, NULL, NULL, '{"attributes": {"activo": true, "nombre": "República Dominicana", "continente": "El Caribe", "codigo_iso2": "DO", "codigo_iso3": "DOM", "idioma_principal": "es", "moneda_principal": "DOP", "codigo_telefonico": "+1"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(19, 'default', 'created', 'App\\Models\\Pais', 'created', 19, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Uruguay", "continente": "América del Sur", "codigo_iso2": "UY", "codigo_iso3": "URY", "idioma_principal": "es", "moneda_principal": "UYU", "codigo_telefonico": "+598"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(20, 'default', 'created', 'App\\Models\\Pais', 'created', 20, NULL, NULL, '{"attributes": {"activo": true, "nombre": "Venezuela", "continente": "América del Sur", "codigo_iso2": "VE", "codigo_iso3": "VEN", "idioma_principal": "es", "moneda_principal": "VES", "codigo_telefonico": "+58"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(21, 'default', 'created', 'App\\Models\\Empresa', 'created', 1, NULL, NULL, '{"attributes": {"status": true, "direccion": "Av. Principal 123", "documento": "1234567890", "razon_social": "Devtechvnzla C.A", "representante_legal": "Theizer Gonzalez"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(22, 'default', 'created', 'App\\Models\\Sucursal', 'created', 1, NULL, NULL, '{"attributes": {"nombre": "Sucursal Devtechvnzla C.A", "status": true, "telefono": "1234567890", "direccion": "Av. Principal 123"}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(23, 'default', 'created', 'App\\Models\\User', 'created', 1, NULL, NULL, '{"attributes": {"name": "Super Admin Devtechvnzla C.A", "email": "superadmin@devtechvnzla.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(24, 'default', 'created', 'App\\Models\\User', 'created', 2, NULL, NULL, '{"attributes": {"name": "Admin Devtechvnzla C.A", "email": "admin@devtechvnzla.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(25, 'default', 'created', 'App\\Models\\User', 'created', 3, NULL, NULL, '{"attributes": {"name": "User Cliente Devtechvnzla C.A", "email": "cliente@devtechvnzla.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(26, 'default', 'created', 'App\\Models\\User', 'created', 4, NULL, NULL, '{"attributes": {"name": "User Empleado Devtechvnzla C.A", "email": "userempleado@devtechvnzla.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(27, 'default', 'created', 'App\\Models\\User', 'created', 5, NULL, NULL, '{"attributes": {"name": "Carlos Rodríguez Pérez", "email": "carlos.rodriguez@empresa.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(28, 'default', 'created', 'App\\Models\\User', 'created', 6, NULL, NULL, '{"attributes": {"name": "Ana González López", "email": "ana.gonzalez@empresa.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(29, 'default', 'created', 'App\\Models\\User', 'created', 7, NULL, NULL, '{"attributes": {"name": "Luis Martínez Sánchez", "email": "luis.martinez@empresa.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05'),
	(30, 'default', 'created', 'App\\Models\\User', 'created', 8, NULL, NULL, '{"attributes": {"name": "María Fernández Torres", "email": "maria.fernandez@empresa.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05'),
	(31, 'default', 'created', 'App\\Models\\User', 'created', 9, NULL, NULL, '{"attributes": {"name": "Jorge Pérez Ramírez", "email": "jorge.perez@empresa.com", "status": 1, "empresa_id": 1, "sucursal_id": 1}}', NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05'),
	(32, 'default', 'created', 'App\\Models\\User', 'created', 11, NULL, NULL, '{"attributes": {"name": "Administrador", "email": "admin@example.com", "status": 1, "empresa_id": null, "sucursal_id": null}}', NULL, '2025-11-26 19:07:06', '2025-11-26 19:07:06');

-- Volcando estructura para tabla laravel.bancos
DROP TABLE IF EXISTS `bancos`;
CREATE TABLE IF NOT EXISTS `bancos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `bancos_codigo_unique` (`codigo`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.bancos: ~21 rows (aproximadamente)
DELETE FROM `bancos`;
INSERT INTO `bancos` (`id`, `nombre`, `codigo`, `activo`, `created_at`, `updated_at`) VALUES
	(1, 'Banco de Venezuela', '0102', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(2, 'Banco Venezolano de Crédito', '0104', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(3, 'Banco Mercantil', '0105', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(4, 'Banco Provincial', '0108', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(5, 'Bancaribe', '0114', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(6, 'Banco Exterior', '0115', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(7, 'Banco Occidental de Descuento', '0116', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(8, 'Banco Caroní', '0128', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(9, 'Banesco', '0134', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(10, 'Banco Sofitasa', '0137', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(11, 'Banco Plaza', '0138', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(12, 'Banco de la Gente Emprendedora', '0146', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(13, 'Banco del Pueblo Soberano', '0149', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(14, 'Banco Fondo Común', '0151', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(15, 'Banco del Tesoro', '0163', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(16, 'Banco Agrícola de Venezuela', '0166', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(17, 'Banco Bicentenario', '0175', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(18, 'Banco Activo', '0171', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(19, 'Bancrecer', '0168', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(20, 'Mi Banco', '0169', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(21, 'Banco Nacional de Crédito', '0191', 1, '2025-11-26 14:20:04', '2025-11-26 14:20:04');

-- Volcando estructura para tabla laravel.cache
DROP TABLE IF EXISTS `cache`;
CREATE TABLE IF NOT EXISTS `cache` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.cache: ~0 rows (aproximadamente)
DELETE FROM `cache`;

-- Volcando estructura para tabla laravel.cache_locks
DROP TABLE IF EXISTS `cache_locks`;
CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.cache_locks: ~0 rows (aproximadamente)
DELETE FROM `cache_locks`;

-- Volcando estructura para tabla laravel.cajas
DROP TABLE IF EXISTS `cajas`;
CREATE TABLE IF NOT EXISTS `cajas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `fecha` date NOT NULL,
  `numero_corte` int NOT NULL DEFAULT '1',
  `monto_inicial` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_efectivo` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_transferencias` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_tarjetas` decimal(10,2) NOT NULL DEFAULT '0.00',
  `total_ingresos` decimal(10,2) NOT NULL DEFAULT '0.00',
  `monto_final` decimal(10,2) NOT NULL DEFAULT '0.00',
  `estado` enum('abierta','cerrada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'abierta',
  `fecha_apertura` timestamp NOT NULL,
  `fecha_cierre` timestamp NULL DEFAULT NULL,
  `observaciones_apertura` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `observaciones_cierre` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cajas_user_id_foreign` (`user_id`),
  KEY `cajas_fecha_estado_index` (`fecha`,`estado`),
  KEY `cajas_empresa_id_foreign` (`empresa_id`),
  KEY `cajas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `cajas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cajas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.cajas: ~2 rows (aproximadamente)
DELETE FROM `cajas`;
INSERT INTO `cajas` (`id`, `empresa_id`, `sucursal_id`, `user_id`, `fecha`, `numero_corte`, `monto_inicial`, `total_efectivo`, `total_transferencias`, `total_tarjetas`, `total_ingresos`, `monto_final`, `estado`, `fecha_apertura`, `fecha_cierre`, `observaciones_apertura`, `observaciones_cierre`, `created_at`, `updated_at`) VALUES
	(1, 1, 1, 2, '2025-11-26', 1, 0.00, 92.00, 3.95, 0.00, 95.95, 95.95, 'abierta', '2025-11-26 14:23:29', NULL, '', NULL, '2025-11-26 14:23:29', '2025-11-26 16:13:32'),
	(2, 1, 1, 2, '2025-11-27', 1, 0.00, 1.05, 95.50, 0.00, 96.55, 96.55, 'abierta', '2025-11-27 13:30:56', NULL, 'Caja automática para pedido #5', NULL, '2025-11-27 13:30:56', '2025-11-27 14:20:23');

-- Volcando estructura para tabla laravel.categorias
DROP TABLE IF EXISTS `categorias`;
CREATE TABLE IF NOT EXISTS `categorias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categorias_slug_unique` (`slug`),
  KEY `categorias_empresa_id_foreign` (`empresa_id`),
  KEY `categorias_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `categorias_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categorias_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.categorias: ~11 rows (aproximadamente)
DELETE FROM `categorias`;
INSERT INTO `categorias` (`id`, `nombre`, `slug`, `descripcion`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
	(1, 'Víveres', 'viveres', 'Productos de despensa básica', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(2, 'Cigarrilos', 'cigarrilos', 'Productos de tabaco y cigarros', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(3, 'Confitería', 'confiteria', 'Productos de confitería', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(4, 'Lavandería', 'lavanderia', 'Productos para lavandería', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(5, 'Higiene Personal', 'higiene-personal', 'Productos de cuidado e higiene personal', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(6, 'Bebidas', 'bebidas', 'Bebidas refrescantes y gaseosas', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(7, 'Snacks', 'snacks', 'Productos de snacks y botanas', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(8, 'Desayuno', 'desayuno', 'Productos para el desayuno', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(9, 'Cuidado del Bebé', 'cuidado-del-bebe', 'Productos para el cuidado del bebé', 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(10, 'Mascotas', 'Mascotas', 'Todo lo relacionado a mascotas', 1, 1, 1, '2025-11-21 06:07:53', '2025-11-21 06:07:53'),
	(11, 'Hogar', 'Hogar', 'Todo lo relacionado con el hogar', 1, 1, 1, '2025-11-28 02:55:05', '2025-11-28 02:55:06');

-- Volcando estructura para tabla laravel.clientes
DROP TABLE IF EXISTS `clientes`;
CREATE TABLE IF NOT EXISTS `clientes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `documento_identidad` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `clientes_empresa_id_foreign` (`empresa_id`),
  KEY `clientes_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `clientes_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `clientes_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.clientes: ~0 rows (aproximadamente)
DELETE FROM `clientes`;

-- Volcando estructura para tabla laravel.comprobantes
DROP TABLE IF EXISTS `comprobantes`;
CREATE TABLE IF NOT EXISTS `comprobantes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `numero` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fecha_emision` datetime NOT NULL,
  `serie` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `contenido` json NOT NULL,
  `comprobanteable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comprobanteable_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `comprobantes_numero_unique` (`numero`),
  KEY `comprobantes_comprobanteable_type_comprobanteable_id_index` (`comprobanteable_type`,`comprobanteable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.comprobantes: ~0 rows (aproximadamente)
DELETE FROM `comprobantes`;

-- Volcando estructura para tabla laravel.detalle_pedidos
DROP TABLE IF EXISTS `detalle_pedidos`;
CREATE TABLE IF NOT EXISTS `detalle_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `price` decimal(20,2) NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `productoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `detalle_pedidos_empresaid_foreign` (`empresaId`),
  KEY `detalle_pedidos_userid_foreign` (`userId`),
  KEY `detalle_pedidos_productoid_foreign` (`productoId`),
  KEY `detalle_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `detalle_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_productoid_foreign` FOREIGN KEY (`productoId`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `detalle_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.detalle_pedidos: ~14 rows (aproximadamente)
DELETE FROM `detalle_pedidos`;
INSERT INTO `detalle_pedidos` (`id`, `fecha`, `total_usd`, `total_bs`, `quantity`, `price`, `empresaId`, `userId`, `productoId`, `pedidoId`, `created_at`, `updated_at`) VALUES
	(1, '2025-11-26 11:32:24', '3.95', '3.95', 1, 3.95, 1, 2, 258, 1, '2025-11-26 15:32:24', '2025-11-26 15:32:24'),
	(2, '2025-11-26 12:03:08', '16.25', '16.25', 5, 3.25, 1, 2, 254, 2, '2025-11-26 16:03:08', '2025-11-26 16:03:08'),
	(3, '2025-11-26 12:03:08', '18', '18', 4, 4.50, 1, 2, 255, 2, '2025-11-26 16:03:08', '2025-11-26 16:03:08'),
	(4, '2025-11-26 12:03:08', '17', '17', 4, 4.25, 1, 2, 256, 2, '2025-11-26 16:03:08', '2025-11-26 16:03:08'),
	(5, '2025-11-26 12:03:08', '23', '23', 4, 5.75, 1, 2, 257, 2, '2025-11-26 16:03:08', '2025-11-26 16:03:08'),
	(6, '2025-11-26 12:13:08', '4.25', '4.25', 1, 4.25, 1, 2, 256, 3, '2025-11-26 16:13:08', '2025-11-26 16:13:08'),
	(7, '2025-11-26 12:13:08', '5', '5', 1, 5.00, 1, 2, 251, 3, '2025-11-26 16:13:08', '2025-11-26 16:13:08'),
	(8, '2025-11-26 12:13:08', '8.5', '8.5', 1, 8.50, 1, 2, 247, 3, '2025-11-26 16:13:08', '2025-11-26 16:13:08'),
	(9, '2025-11-26 14:24:37', '15', '15', 3, 5.00, 1, 2, 252, 4, '2025-11-26 18:24:37', '2025-11-26 18:24:37'),
	(10, '2025-11-26 14:24:37', '17.25', '17.25', 3, 5.75, 1, 2, 257, 4, '2025-11-26 18:24:37', '2025-11-26 18:24:37'),
	(11, '2025-11-26 14:24:37', '19.35', '19.35', 3, 6.45, 1, 2, 258, 4, '2025-11-26 18:24:37', '2025-11-26 18:24:37'),
	(12, '2025-11-26 14:24:37', '25.5', '25.5', 3, 8.50, 1, 2, 246, 4, '2025-11-26 18:24:37', '2025-11-26 18:24:37'),
	(13, '2025-11-27 09:30:30', '1.05', '1.05', 1, 1.05, 1, 2, 199, 5, '2025-11-27 13:30:30', '2025-11-27 13:30:30'),
	(14, '2025-11-27 10:19:31', '18.4', '18.4', 1, 18.40, 1, 2, 103, 6, '2025-11-27 14:19:31', '2025-11-27 14:19:31');

-- Volcando estructura para tabla laravel.empleados
DROP TABLE IF EXISTS `empleados`;
CREATE TABLE IF NOT EXISTS `empleados` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nombres` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `apellidos` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tipo_documento` enum('cedula','pasaporte','rif') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fecha_nacimiento` date DEFAULT NULL,
  `genero` enum('masculino','femenino','otro') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cargo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `departamento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `salario` decimal(10,2) DEFAULT NULL,
  `fecha_ingreso` date NOT NULL,
  `fecha_salida` date DEFAULT NULL,
  `estado_civil` enum('soltero','casado','divorciado','viudo') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contacto_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono_emergencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `observaciones` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleados_codigo_unique` (`codigo`),
  UNIQUE KEY `empleados_documento_unique` (`documento`),
  UNIQUE KEY `empleados_email_unique` (`email`),
  KEY `empleados_empresa_id_foreign` (`empresa_id`),
  KEY `empleados_sucursal_id_foreign` (`sucursal_id`),
  KEY `empleados_user_id_foreign` (`user_id`),
  CONSTRAINT `empleados_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleados_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.empleados: ~5 rows (aproximadamente)
DELETE FROM `empleados`;
INSERT INTO `empleados` (`id`, `codigo`, `nombres`, `apellidos`, `documento`, `tipo_documento`, `email`, `telefono`, `fecha_nacimiento`, `genero`, `direccion`, `cargo`, `departamento`, `salario`, `fecha_ingreso`, `fecha_salida`, `estado_civil`, `contacto_emergencia`, `telefono_emergencia`, `observaciones`, `status`, `empresa_id`, `sucursal_id`, `user_id`, `created_at`, `updated_at`) VALUES
	(1, 'EMP0001', 'Carlos', 'Rodríguez Pérez', '12345678', 'cedula', 'carlos.rodriguez@empresa.com', '0412-1234567', '1985-05-15', 'masculino', 'Calle Los Olmos, Urbanización Los Ángeles', 'Gerente de Ventas', 'Ventas', 2500.00, '2023-01-15', NULL, 'casado', 'María Rodríguez', '0412-7654321', 'Empleado con experiencia en ventas internacionales', 1, 1, 1, 5, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(2, 'EMP0002', 'Ana', 'González López', '87654321', 'cedula', 'ana.gonzalez@empresa.com', '0414-7654321', '1990-08-22', 'femenino', 'Avenida Bolívar, Torre Central Piso 5', 'Supervisora de Almacén', 'Logística', 1800.00, '2023-03-10', NULL, 'soltero', 'José González', '0414-1234567', 'Responsable de inventario y control de stock', 1, 1, 1, 6, '2025-11-26 14:20:04', '2025-11-26 14:20:04'),
	(3, 'EMP0003', 'Luis', 'Martínez Sánchez', '11223344', 'cedula', 'luis.martinez@empresa.com', '0426-9876543', '1988-12-10', 'masculino', 'Calle Miranda, Quinta Los Rosales', 'Asistente Administrativo', 'Administración', 1500.00, '2023-06-01', NULL, 'casado', 'Carmen Sánchez', '0426-3216549', 'Apoyo en tareas administrativas y atención al cliente', 1, 1, 1, 7, '2025-11-26 14:20:05', '2025-11-26 14:20:05'),
	(4, 'EMP0004', 'María', 'Fernández Torres', '55667788', 'cedula', 'maria.fernandez@empresa.com', '0412-5556677', '1992-04-18', 'femenino', 'Urbanización Las Palmas, Casa 25', 'Cajera', 'Caja', 1200.00, '2024-01-15', NULL, 'soltero', 'Rosa Torres', '0412-7778899', 'Manejo de caja y atención al público', 1, 1, 1, 8, '2025-11-26 14:20:05', '2025-11-26 14:20:05'),
	(5, 'EMP0005', 'Jorge', 'Pérez Ramírez', '99887766', 'cedula', 'jorge.perez@empresa.com', '0424-3332211', '1983-09-05', 'masculino', 'Avenida Los Próceres, Edificio Los Jardines', 'Vendedor', 'Ventas', 1400.00, '2023-11-20', NULL, 'casado', 'Diana Ramírez', '0424-8889900', 'Atención en mostrador y ventas telefónicas', 1, 1, 1, 9, '2025-11-26 14:20:05', '2025-11-26 14:20:05');

-- Volcando estructura para tabla laravel.empleado_pedido
DROP TABLE IF EXISTS `empleado_pedido`;
CREATE TABLE IF NOT EXISTS `empleado_pedido` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empleadoId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empleado_pedido_empleadoid_pedidoid_unique` (`empleadoId`,`pedidoId`),
  KEY `empleado_pedido_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `empleado_pedido_empleadoid_foreign` FOREIGN KEY (`empleadoId`) REFERENCES `empleados` (`id`) ON DELETE CASCADE,
  CONSTRAINT `empleado_pedido_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.empleado_pedido: ~6 rows (aproximadamente)
DELETE FROM `empleado_pedido`;
INSERT INTO `empleado_pedido` (`id`, `empleadoId`, `pedidoId`, `created_at`, `updated_at`) VALUES
	(1, 5, 1, NULL, NULL),
	(2, 5, 2, NULL, NULL),
	(3, 5, 3, NULL, NULL),
	(4, 5, 5, NULL, NULL),
	(5, 5, 4, NULL, NULL),
	(6, 5, 6, NULL, NULL);

-- Volcando estructura para tabla laravel.empresas
DROP TABLE IF EXISTS `empresas`;
CREATE TABLE IF NOT EXISTS `empresas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pais_id` bigint unsigned DEFAULT NULL,
  `razon_social` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `representante_legal` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `empresas_documento_unique` (`documento`),
  KEY `empresas_pais_id_foreign` (`pais_id`),
  CONSTRAINT `empresas_pais_id_foreign` FOREIGN KEY (`pais_id`) REFERENCES `pais` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.empresas: ~0 rows (aproximadamente)
DELETE FROM `empresas`;
INSERT INTO `empresas` (`id`, `pais_id`, `razon_social`, `documento`, `direccion`, `latitud`, `longitud`, `representante_legal`, `telefono`, `email`, `status`, `created_at`, `updated_at`) VALUES
	(1, 20, 'Devtechvnzla C.A', '1234567890', 'Av. Principal 123', NULL, NULL, 'Theizer Gonzalez', '1234567890', '1234567890', 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02');

-- Volcando estructura para tabla laravel.exchange_rates
DROP TABLE IF EXISTS `exchange_rates`;
CREATE TABLE IF NOT EXISTS `exchange_rates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `usd_rate` decimal(10,4) NOT NULL,
  `eur_rate` decimal(10,4) DEFAULT NULL,
  `source` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fetch_time` time NOT NULL,
  `raw_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `exchange_rates_date_fetch_time_unique` (`date`,`fetch_time`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.exchange_rates: ~2 rows (aproximadamente)
DELETE FROM `exchange_rates`;
INSERT INTO `exchange_rates` (`id`, `date`, `usd_rate`, `eur_rate`, `source`, `fetch_time`, `raw_data`, `created_at`, `updated_at`) VALUES
	(1, '2025-11-26', 243.5727, 281.7600, 'dolarvzla', '10:23:19', '{"source": "dolarvzla", "eur_rate": 281.7600279, "usd_rate": 243.5727}', '2025-11-26 14:23:19', '2025-11-26 14:23:19'),
	(2, '2025-11-27', 245.6697, 284.8810, 'dolarvzla', '19:16:05', '{"source": "dolarvzla", "eur_rate": 284.88104081, "usd_rate": 245.6697}', '2025-11-27 13:30:06', '2025-11-27 23:16:05');

-- Volcando estructura para tabla laravel.failed_jobs
DROP TABLE IF EXISTS `failed_jobs`;
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.failed_jobs: ~0 rows (aproximadamente)
DELETE FROM `failed_jobs`;

-- Volcando estructura para tabla laravel.historico_pedidos
DROP TABLE IF EXISTS `historico_pedidos`;
CREATE TABLE IF NOT EXISTS `historico_pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `descripcion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `historico_pedidos_empresaid_foreign` (`empresaId`),
  KEY `historico_pedidos_userid_foreign` (`userId`),
  KEY `historico_pedidos_pedidoid_foreign` (`pedidoId`),
  CONSTRAINT `historico_pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `historico_pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.historico_pedidos: ~18 rows (aproximadamente)
DELETE FROM `historico_pedidos`;
INSERT INTO `historico_pedidos` (`id`, `fecha`, `descripcion`, `titulo`, `empresaId`, `userId`, `pedidoId`, `created_at`, `updated_at`) VALUES
	(1, '2025-11-26 11:32:24', 'El pedido #: 1 Se ha realizado.', 'Orden creada', 1, 2, 1, '2025-11-26 15:32:24', '2025-11-26 15:32:24'),
	(2, '2025-11-26', 'Pago confirmado - 💳 **Método de pago:**\n1. Pago Móvil: $ 3,95 / 3.95Bs', 'Pago Confirmado', 1, 2, 1, '2025-11-26 15:32:59', '2025-11-26 15:32:59'),
	(3, '2025-11-26', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 1, '2025-11-26 15:33:11', '2025-11-26 15:33:11'),
	(4, '2025-11-26 12:03:08', 'El pedido #: 3 Se ha realizado.', 'Orden creada', 1, 2, 2, '2025-11-26 16:03:08', '2025-11-26 16:03:08'),
	(5, '2025-11-26', 'Pago confirmado - 💳 **Método de pago:**\n1. Efectivo: $ 74,25 / 74.25Bs', 'Pago Confirmado', 1, 2, 2, '2025-11-26 16:03:42', '2025-11-26 16:03:42'),
	(6, '2025-11-26', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 2, '2025-11-26 16:03:56', '2025-11-26 16:03:56'),
	(7, '2025-11-26 12:13:08', 'El pedido #: 4 Se ha realizado.', 'Orden creada', 1, 2, 3, '2025-11-26 16:13:08', '2025-11-26 16:13:08'),
	(8, '2025-11-26', 'Pago confirmado - 💳 **Método de pago:**\n1. Efectivo: $ 17,75 / 17.75Bs', 'Pago Confirmado', 1, 2, 3, '2025-11-26 16:13:32', '2025-11-26 16:13:32'),
	(9, '2025-11-26', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 3, '2025-11-26 16:13:38', '2025-11-26 16:13:38'),
	(10, '2025-11-26 14:24:37', 'El pedido #: 0005 Se ha realizado.', 'Orden creada', 1, 2, 4, '2025-11-26 18:24:37', '2025-11-26 18:24:37'),
	(11, '2025-11-27 09:30:30', 'El pedido #: 0006 Se ha realizado.', 'Orden creada', 1, 2, 5, '2025-11-27 13:30:30', '2025-11-27 13:30:30'),
	(12, '2025-11-27', 'Pago confirmado - 💳 **Método de pago:**\n1. Efectivo Bs: $ 1,05 / 1.05Bs', 'Pago Confirmado', 1, 2, 5, '2025-11-27 13:30:56', '2025-11-27 13:30:56'),
	(13, '2025-11-27', 'Pago confirmado - 💳 **Método de pago:**\n1. Pago Móvil: $ 77,10 / 77.10Bs', 'Pago Confirmado', 1, 2, 4, '2025-11-27 13:30:59', '2025-11-27 13:30:59'),
	(14, '2025-11-27', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 5, '2025-11-27 13:31:05', '2025-11-27 13:31:05'),
	(15, '2025-11-27', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 4, '2025-11-27 13:31:11', '2025-11-27 13:31:11'),
	(16, '2025-11-27 10:19:31', 'El pedido #: 0007 Se ha realizado.', 'Orden creada', 1, 2, 6, '2025-11-27 14:19:31', '2025-11-27 14:19:31'),
	(17, '2025-11-27', 'Pago confirmado - 💳 **Método de pago:**\n1. Pago Móvil: $ 18,40 / 18.40Bs', 'Pago Confirmado', 1, 2, 6, '2025-11-27 14:20:23', '2025-11-27 14:20:23'),
	(18, '2025-11-27', 'Empleado asignado: Jorge', 'Empleado Asignado', 1, 2, 6, '2025-11-27 14:20:32', '2025-11-27 14:20:32');

-- Volcando estructura para tabla laravel.images
DROP TABLE IF EXISTS `images`;
CREATE TABLE IF NOT EXISTS `images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_primary` tinyint(1) NOT NULL DEFAULT '0',
  `order` int NOT NULL DEFAULT '0',
  `producto_id` bigint unsigned NOT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `images_producto_id_foreign` (`producto_id`),
  KEY `images_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `images_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `images_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=136 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.images: ~119 rows (aproximadamente)
DELETE FROM `images`;
INSERT INTO `images` (`id`, `path`, `thumbnail_path`, `alt_text`, `is_primary`, `order`, `producto_id`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
	(1, 'productos/4/images/1763688254_0.jpg', NULL, NULL, 0, 0, 4, 1, 1, '2025-11-21 09:24:14', '2025-11-21 09:24:14'),
	(4, 'productos/151/images/1763688841_0.jpg', NULL, NULL, 0, 0, 151, 1, 1, '2025-11-21 09:34:01', '2025-11-21 09:34:01'),
	(5, 'productos/154/images/1763689280_0.jpg', NULL, NULL, 0, 0, 154, 1, 1, '2025-11-21 09:41:20', '2025-11-21 09:41:20'),
	(6, 'productos/6/images/1763689432_0.jpg', NULL, NULL, 0, 0, 6, 1, 1, '2025-11-21 09:43:52', '2025-11-21 09:43:52'),
	(7, 'productos/260/images/1763689583_0.jpg', NULL, NULL, 0, 0, 260, 1, 1, '2025-11-21 09:46:23', '2025-11-21 09:46:23'),
	(8, 'productos/8/images/1763689679_0.jpg', NULL, NULL, 0, 0, 8, 1, 1, '2025-11-21 09:47:59', '2025-11-21 09:47:59'),
	(9, 'productos/130/images/1763689855_0.jpg', NULL, NULL, 0, 0, 130, 1, 1, '2025-11-21 09:50:55', '2025-11-21 09:50:55'),
	(10, 'productos/131/images/1763689892_0.jpg', NULL, NULL, 0, 0, 131, 1, 1, '2025-11-21 09:51:32', '2025-11-21 09:51:32'),
	(11, 'productos/125/images/1763689964_0.jpg', NULL, NULL, 0, 0, 125, 1, 1, '2025-11-21 09:52:44', '2025-11-21 09:52:44'),
	(13, 'productos/261/1763690083_0.jpg', NULL, NULL, 0, 0, 261, 1, 1, '2025-11-21 09:54:43', '2025-11-21 09:54:43'),
	(15, 'productos/262/1763690151_0.jpg', NULL, 'Cubitos Maggi', 0, 0, 262, 1, 1, '2025-11-21 09:55:51', '2025-11-21 09:55:51'),
	(17, 'productos/263/1763690237_0.jpg', NULL, 'Diablito Under Wood 115G', 0, 0, 263, 1, 1, '2025-11-21 09:57:17', '2025-11-21 09:57:17'),
	(18, 'productos/264/images/1763690364_0.jpg', NULL, NULL, 0, 0, 264, 1, 1, '2025-11-21 09:59:24', '2025-11-21 09:59:24'),
	(20, 'productos/265/1763691356_0.jpg', NULL, 'Don Kat Adulto', 0, 0, 265, 1, 1, '2025-11-21 10:15:56', '2025-11-21 10:15:56'),
	(21, 'productos/166/images/1763691724_0.jpg', NULL, NULL, 0, 0, 166, 1, 1, '2025-11-21 10:22:04', '2025-11-21 10:22:04'),
	(22, 'productos/165/images/1763691771_0.jpg', NULL, NULL, 0, 0, 165, 1, 1, '2025-11-21 10:22:51', '2025-11-21 10:22:51'),
	(23, 'productos/167/images/1763691818_0.jpg', NULL, NULL, 0, 0, 167, 1, 1, '2025-11-21 10:23:38', '2025-11-21 10:23:38'),
	(25, 'productos/266/1763692291_0.jpg', NULL, 'Huevo Santa Maria doble 12x1', 0, 0, 266, 1, 1, '2025-11-21 10:31:31', '2025-11-21 10:31:31'),
	(26, 'productos/128/images/1763693013_0.jpg', NULL, NULL, 0, 0, 128, 1, 1, '2025-11-21 10:43:33', '2025-11-21 10:43:33'),
	(27, 'productos/129/images/1763693093_0.jpg', NULL, NULL, 0, 0, 129, 1, 1, '2025-11-21 10:44:53', '2025-11-21 10:44:53'),
	(28, 'productos/176/images/1763693178_0.jpg', NULL, NULL, 0, 0, 176, 1, 1, '2025-11-21 10:46:18', '2025-11-21 10:46:18'),
	(29, 'productos/175/images/1763693649_0.jpg', NULL, NULL, 0, 0, 175, 1, 1, '2025-11-21 10:54:09', '2025-11-21 10:54:09'),
	(30, 'productos/147/images/1763693874_0.jpg', NULL, NULL, 0, 0, 147, 1, 1, '2025-11-21 10:57:54', '2025-11-21 10:57:54'),
	(31, 'productos/173/images/1763694088_0.jpg', NULL, NULL, 0, 0, 173, 1, 1, '2025-11-21 11:01:29', '2025-11-21 11:01:29'),
	(32, 'productos/174/images/1763694121_0.jpg', NULL, NULL, 0, 0, 174, 1, 1, '2025-11-21 11:02:01', '2025-11-21 11:02:01'),
	(33, 'productos/145/images/1763694812_0.jpg', NULL, NULL, 0, 0, 145, 1, 1, '2025-11-21 11:13:32', '2025-11-21 11:13:32'),
	(35, 'productos/267/1763695104_0.jpg', NULL, 'Mantequilla Deline, 250 MG', 0, 0, 267, 1, 1, '2025-11-21 11:18:24', '2025-11-21 11:18:24'),
	(36, 'productos/268/images/1763695235_0.jpg', NULL, NULL, 0, 0, 268, 1, 1, '2025-11-21 11:20:35', '2025-11-21 11:20:35'),
	(37, 'productos/12/images/1763695400_0.jpg', NULL, NULL, 0, 0, 12, 1, 1, '2025-11-21 11:23:20', '2025-11-21 11:23:20'),
	(39, 'productos/269/1763695598_0.jpg', NULL, 'Mirringo Adulto', 0, 0, 269, 1, 1, '2025-11-21 11:26:38', '2025-11-21 11:26:38'),
	(40, 'productos/96/images/1763695648_0.jpg', NULL, NULL, 0, 0, 96, 1, 1, '2025-11-21 11:27:28', '2025-11-21 11:27:28'),
	(41, 'productos/109/images/1763695817_0.jpg', NULL, NULL, 0, 0, 109, 1, 1, '2025-11-21 11:30:17', '2025-11-21 11:30:17'),
	(42, 'productos/110/images/1763695860_0.jpg', NULL, NULL, 0, 0, 110, 1, 1, '2025-11-21 11:31:00', '2025-11-21 11:31:00'),
	(43, 'productos/112/images/1763695948_0.jpg', NULL, NULL, 0, 0, 112, 1, 1, '2025-11-21 11:32:28', '2025-11-21 11:32:28'),
	(44, 'productos/113/images/1763695985_0.jpg', NULL, NULL, 0, 0, 113, 1, 1, '2025-11-21 11:33:05', '2025-11-21 11:33:05'),
	(45, 'productos/114/images/1763696018_0.jpg', NULL, NULL, 0, 0, 114, 1, 1, '2025-11-21 11:33:38', '2025-11-21 11:33:38'),
	(47, 'productos/270/1763696363_0.webp', NULL, 'Nutribella15 Acondicionador Nutrición 12x1  Devuelve la Belleza Natural', 0, 0, 270, 1, 1, '2025-11-21 11:39:23', '2025-11-21 11:39:23'),
	(49, 'productos/271/1763696499_0.webp', NULL, 'Nutribella15 Acondicionador Termoproteccion 12x1', 0, 0, 271, 1, 1, '2025-11-21 11:41:39', '2025-11-21 11:41:39'),
	(50, 'productos/110/images/1763696740_0.jpg', NULL, NULL, 0, 0, 110, 1, 1, '2025-11-21 11:45:40', '2025-11-21 11:45:40'),
	(51, 'productos/118/images/1763696783_0.jpg', NULL, NULL, 0, 0, 118, 1, 1, '2025-11-21 11:46:23', '2025-11-21 11:46:23'),
	(52, 'productos/121/images/1763697478_0.jpg', NULL, NULL, 0, 0, 121, 1, 1, '2025-11-21 11:57:58', '2025-11-21 11:57:58'),
	(53, 'productos/259/images/1764249224_0.jpg', NULL, NULL, 0, 0, 259, 1, 1, '2025-11-27 17:13:44', '2025-11-27 17:13:44'),
	(54, 'productos/100/images/1764285759_0.jpg', NULL, NULL, 0, 0, 100, 1, 1, '2025-11-28 03:22:39', '2025-11-28 03:22:39'),
	(56, 'productos/83/images/1764285979_0.jpg', NULL, NULL, 0, 0, 83, 1, 1, '2025-11-28 03:26:19', '2025-11-28 03:26:19'),
	(57, 'productos/82/images/1764286396_0.jpg', NULL, NULL, 0, 0, 82, 1, 1, '2025-11-27 23:33:16', '2025-11-27 23:33:16'),
	(58, 'productos/81/images/1764286545_0.jpg', NULL, NULL, 0, 0, 81, 1, 1, '2025-11-27 23:35:45', '2025-11-27 23:35:45'),
	(59, 'productos/80/images/1764286577_0.jpg', NULL, NULL, 0, 0, 80, 1, 1, '2025-11-27 23:36:17', '2025-11-27 23:36:17'),
	(60, 'productos/79/images/1764286599_0.jpg', NULL, NULL, 0, 0, 79, 1, 1, '2025-11-27 23:36:39', '2025-11-27 23:36:39'),
	(61, 'productos/76/images/1764286827_0.jpg', NULL, NULL, 0, 0, 76, 1, 1, '2025-11-27 23:40:27', '2025-11-27 23:40:27'),
	(62, 'productos/75/images/1764286847_0.jpg', NULL, NULL, 0, 0, 75, 1, 1, '2025-11-27 23:40:47', '2025-11-27 23:40:47'),
	(63, 'productos/74/images/1764286949_0.jpg', NULL, NULL, 0, 0, 74, 1, 1, '2025-11-27 23:42:29', '2025-11-27 23:42:29'),
	(64, 'productos/179/images/1764287371_0.jpg', NULL, NULL, 0, 0, 179, 1, 1, '2025-11-27 23:49:32', '2025-11-27 23:49:32'),
	(65, 'productos/178/images/1764287423_0.jpg', NULL, NULL, 0, 0, 178, 1, 1, '2025-11-27 23:50:24', '2025-11-27 23:50:24'),
	(66, 'productos/177/images/1764287491_0.jpg', NULL, NULL, 0, 0, 177, 1, 1, '2025-11-27 23:51:31', '2025-11-27 23:51:31'),
	(67, 'productos/203/images/1764289900_0.webp', NULL, NULL, 0, 0, 203, 1, 1, '2025-11-28 00:31:41', '2025-11-28 00:31:41'),
	(68, 'productos/204/images/1764290012_0.webp', NULL, NULL, 0, 0, 204, 1, 1, '2025-11-28 00:33:32', '2025-11-28 00:33:32'),
	(69, 'productos/272/images/1764290800_0.jpg', NULL, NULL, 0, 0, 272, 1, 1, '2025-11-28 00:46:40', '2025-11-28 00:46:40'),
	(70, 'productos/188/images/1764292197_0.jpg', NULL, NULL, 0, 0, 188, 1, 1, '2025-11-28 01:09:57', '2025-11-28 01:09:57'),
	(71, 'productos/124/images/1764292255_0.jpg', NULL, NULL, 0, 0, 124, 1, 1, '2025-11-28 01:10:55', '2025-11-28 01:10:55'),
	(72, 'productos/123/images/1764292300_0.jpg', NULL, NULL, 0, 0, 123, 1, 1, '2025-11-28 01:11:40', '2025-11-28 01:11:40'),
	(73, 'productos/122/images/1764292325_0.jpg', NULL, NULL, 0, 0, 122, 1, 1, '2025-11-28 01:12:06', '2025-11-28 01:12:06'),
	(74, 'productos/99/images/1764292431_0.jpg', NULL, NULL, 0, 0, 99, 1, 1, '2025-11-28 01:13:51', '2025-11-28 01:13:51'),
	(75, 'productos/98/images/1764292457_0.jpg', NULL, NULL, 0, 0, 98, 1, 1, '2025-11-28 01:14:18', '2025-11-28 01:14:18'),
	(76, 'productos/97/images/1764292480_0.jpg', NULL, NULL, 0, 0, 97, 1, 1, '2025-11-28 01:14:40', '2025-11-28 01:14:40'),
	(77, 'productos/84/images/1764292639_0.jpg', NULL, NULL, 0, 0, 84, 1, 1, '2025-11-28 01:17:19', '2025-11-28 01:17:19'),
	(79, 'productos/86/images/1764292838_0.jpg', NULL, NULL, 0, 0, 86, 1, 1, '2025-11-28 01:20:38', '2025-11-28 01:20:38'),
	(80, 'productos/90/images/1764293190_0.jpg', NULL, NULL, 0, 0, 90, 1, 1, '2025-11-28 01:26:30', '2025-11-28 01:26:30'),
	(81, 'productos/91/images/1764293219_0.jpg', NULL, NULL, 0, 0, 91, 1, 1, '2025-11-28 01:27:00', '2025-11-28 01:27:00'),
	(82, 'productos/93/images/1764293457_0.jpg', NULL, NULL, 0, 0, 93, 1, 1, '2025-11-28 01:30:57', '2025-11-28 01:30:57'),
	(83, 'productos/94/images/1764293488_0.jpg', NULL, NULL, 0, 0, 94, 1, 1, '2025-11-28 01:31:28', '2025-11-28 01:31:28'),
	(84, 'productos/215/images/1764293717_0.jpg', NULL, NULL, 0, 0, 215, 1, 1, '2025-11-28 01:35:17', '2025-11-28 01:35:17'),
	(85, 'productos/216/images/1764293815_0.jpg', NULL, NULL, 0, 0, 216, 1, 1, '2025-11-28 01:36:55', '2025-11-28 01:36:55'),
	(86, 'productos/51/images/1764293850_0.jpg', NULL, NULL, 0, 0, 51, 1, 1, '2025-11-28 01:37:30', '2025-11-28 01:37:30'),
	(87, 'productos/172/images/1764294303_0.webp', NULL, NULL, 0, 0, 172, 1, 1, '2025-11-28 01:45:03', '2025-11-28 01:45:03'),
	(90, 'productos/111/images/1764295663_0.webp', NULL, NULL, 0, 0, 111, 1, 1, '2025-11-28 02:07:43', '2025-11-28 02:07:43'),
	(91, 'productos/115/images/1764295690_0.webp', NULL, NULL, 0, 0, 115, 1, 1, '2025-11-28 02:08:10', '2025-11-28 02:08:10'),
	(92, 'productos/273/FLd8bDK6YqwthbjfifkiRGw88pZHBRqccmhN4M2H.jpg', NULL, 'Panelada', 0, 0, 273, 0, 1, '2025-11-28 02:11:34', '2025-11-28 02:11:34'),
	(93, 'productos/273/1764295894_0.jpg', NULL, NULL, 0, 0, 273, 1, 1, '2025-11-28 02:11:34', '2025-11-28 02:11:34'),
	(94, 'productos/244/images/1764296032_0.webp', NULL, NULL, 0, 0, 244, 1, 1, '2025-11-28 02:13:52', '2025-11-28 02:13:52'),
	(95, 'productos/245/images/1764296124_0.jpg', NULL, NULL, 0, 0, 245, 1, 1, '2025-11-28 02:15:24', '2025-11-28 02:15:24'),
	(96, 'productos/246/images/1764296179_0.webp', NULL, NULL, 0, 0, 246, 1, 1, '2025-11-28 02:16:19', '2025-11-28 02:16:19'),
	(97, 'productos/247/images/1764296213_0.jpg', NULL, NULL, 0, 0, 247, 1, 1, '2025-11-28 02:16:53', '2025-11-28 02:16:53'),
	(98, 'productos/248/images/1764296235_0.jpg', NULL, NULL, 0, 0, 248, 1, 1, '2025-11-28 02:17:15', '2025-11-28 02:17:15'),
	(99, 'productos/249/images/1764296553_0.jpg', NULL, NULL, 0, 0, 249, 1, 1, '2025-11-28 02:22:33', '2025-11-28 02:22:33'),
	(100, 'productos/250/images/1764296587_0.jpg', NULL, NULL, 0, 0, 250, 1, 1, '2025-11-28 02:23:07', '2025-11-28 02:23:07'),
	(101, 'productos/251/images/1764296767_0.webp', NULL, NULL, 0, 0, 251, 1, 1, '2025-11-28 02:26:07', '2025-11-28 02:26:07'),
	(102, 'productos/252/images/1764296824_0.webp', NULL, NULL, 0, 0, 252, 1, 1, '2025-11-28 02:27:04', '2025-11-28 02:27:04'),
	(103, 'productos/253/images/1764296882_0.webp', NULL, NULL, 0, 0, 253, 1, 1, '2025-11-28 02:28:02', '2025-11-28 02:28:02'),
	(104, 'productos/274/eDb7AsCnssPEQUPcIlhvY2Uz8x4jj8KuGZZr0iFh.jpg', NULL, 'Pasta Allegri ricatones', 0, 0, 274, 0, 1, '2025-11-28 02:30:34', '2025-11-28 02:30:34'),
	(105, 'productos/274/1764297034_0.jpg', NULL, NULL, 0, 0, 274, 1, 1, '2025-11-28 02:30:34', '2025-11-28 02:30:34'),
	(106, 'productos/275/images/1764297134_0.jpg', NULL, NULL, 0, 0, 275, 1, 1, '2025-11-28 02:32:14', '2025-11-28 02:32:14'),
	(107, 'productos/276/images/1764297197_0.jpg', NULL, NULL, 0, 0, 276, 1, 1, '2025-11-28 02:33:17', '2025-11-28 02:33:17'),
	(108, 'productos/277/images/1764297293_0.jpg', NULL, NULL, 0, 0, 277, 1, 1, '2025-11-28 02:34:53', '2025-11-28 02:34:53'),
	(109, 'productos/278/images/1764297379_0.jpg', NULL, NULL, 0, 0, 278, 1, 1, '2025-11-28 02:36:19', '2025-11-28 02:36:19'),
	(110, 'productos/279/images/1764297421_0.jpg', NULL, NULL, 0, 0, 279, 1, 1, '2025-11-28 02:37:01', '2025-11-28 02:37:01'),
	(111, 'productos/280/images/1764297513_0.jpg', NULL, NULL, 0, 0, 280, 1, 1, '2025-11-28 02:38:33', '2025-11-28 02:38:33'),
	(112, 'productos/281/images/1764297557_0.jpg', NULL, NULL, 0, 0, 281, 1, 1, '2025-11-28 02:39:17', '2025-11-28 02:39:17'),
	(113, 'productos/68/images/1764297661_0.jpg', NULL, NULL, 0, 0, 68, 1, 1, '2025-11-28 02:41:01', '2025-11-28 02:41:01'),
	(114, 'productos/69/images/1764297697_0.jpg', NULL, NULL, 0, 0, 69, 1, 1, '2025-11-28 02:41:37', '2025-11-28 02:41:37'),
	(115, 'productos/70/images/1764297727_0.jpg', NULL, NULL, 0, 0, 70, 1, 1, '2025-11-28 02:42:07', '2025-11-28 02:42:07'),
	(116, 'productos/71/images/1764297792_0.png', NULL, NULL, 0, 0, 71, 1, 1, '2025-11-28 02:43:12', '2025-11-28 02:43:12'),
	(117, 'productos/187/images/1764297863_0.jpg', NULL, NULL, 0, 0, 187, 1, 1, '2025-11-28 02:44:23', '2025-11-28 02:44:23'),
	(118, 'productos/219/images/1764297952_0.jpg', NULL, NULL, 0, 0, 219, 1, 1, '2025-11-28 02:45:52', '2025-11-28 02:45:52'),
	(119, 'productos/218/images/1764297982_0.jpg', NULL, NULL, 0, 0, 218, 1, 1, '2025-11-28 02:46:22', '2025-11-28 02:46:22'),
	(120, 'productos/217/images/1764298005_0.jpg', NULL, NULL, 0, 0, 217, 1, 1, '2025-11-28 02:46:45', '2025-11-28 02:46:45'),
	(121, 'productos/11/images/1764298092_0.jpg', NULL, NULL, 0, 0, 11, 1, 1, '2025-11-28 02:48:13', '2025-11-28 02:48:13'),
	(122, 'productos/31/images/1764298219_0.jpg', NULL, NULL, 0, 0, 31, 1, 1, '2025-11-28 02:50:19', '2025-11-28 02:50:19'),
	(123, 'productos/220/images/1764298261_0.jpg', NULL, NULL, 0, 0, 220, 1, 1, '2025-11-28 02:51:01', '2025-11-28 02:51:01'),
	(124, 'productos/126/images/1764298346_0.jpg', NULL, NULL, 0, 0, 126, 1, 1, '2025-11-28 02:52:26', '2025-11-28 02:52:26'),
	(125, 'productos/127/images/1764298367_0.jpg', NULL, NULL, 0, 0, 127, 1, 1, '2025-11-28 02:52:47', '2025-11-28 02:52:47'),
	(126, 'productos/282/lRDpUue8pSf8QK7Ipgm8d0FuNz7MqoqNhkhIx2cK.jpg', NULL, 'Super Pega', 0, 0, 282, 0, 1, '2025-11-28 02:55:39', '2025-11-28 02:55:39'),
	(127, 'productos/282/1764298539_0.jpg', NULL, NULL, 0, 0, 282, 1, 1, '2025-11-28 02:55:39', '2025-11-28 02:55:39'),
	(128, 'productos/72/images/1764298607_0.jpg', NULL, NULL, 0, 0, 72, 1, 1, '2025-11-28 02:56:47', '2025-11-28 02:56:47'),
	(129, 'productos/101/images/1764298783_0.webp', NULL, NULL, 0, 0, 101, 1, 1, '2025-11-28 02:59:43', '2025-11-28 02:59:43'),
	(130, 'productos/102/images/1764298859_0.jpg', NULL, NULL, 0, 0, 102, 1, 1, '2025-11-28 03:00:59', '2025-11-28 03:00:59'),
	(131, 'productos/103/images/1764298908_0.webp', NULL, NULL, 0, 0, 103, 1, 1, '2025-11-28 03:01:48', '2025-11-28 03:01:48'),
	(132, 'productos/104/images/1764298959_0.webp', NULL, NULL, 0, 0, 104, 1, 1, '2025-11-28 03:02:40', '2025-11-28 03:02:40'),
	(134, 'productos/107/images/1764299086_0.webp', NULL, NULL, 0, 0, 107, 1, 1, '2025-11-28 03:04:46', '2025-11-28 03:04:46'),
	(135, 'productos/108/images/1764299146_0.png', NULL, NULL, 0, 0, 108, 1, 1, '2025-11-28 03:05:46', '2025-11-28 03:05:46');

-- Volcando estructura para tabla laravel.inventory_movements
DROP TABLE IF EXISTS `inventory_movements`;
CREATE TABLE IF NOT EXISTS `inventory_movements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `type` enum('ingreso','salida','devolucion','ajuste','venta','compra') COLLATE utf8mb4_unicode_ci NOT NULL,
  `quantity` int NOT NULL,
  `quantity_before` int NOT NULL,
  `quantity_after` int NOT NULL,
  `unit_cost` decimal(10,2) DEFAULT NULL,
  `total_cost` decimal(10,2) DEFAULT NULL,
  `reference` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventory_movements_user_id_foreign` (`user_id`),
  KEY `inventory_movements_empresa_id_foreign` (`empresa_id`),
  KEY `inventory_movements_sucursal_id_foreign` (`sucursal_id`),
  KEY `inventory_movements_producto_id_created_at_index` (`producto_id`,`created_at`),
  KEY `inventory_movements_type_created_at_index` (`type`,`created_at`),
  CONSTRAINT `inventory_movements_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`),
  CONSTRAINT `inventory_movements_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventory_movements_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`),
  CONSTRAINT `inventory_movements_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.inventory_movements: ~0 rows (aproximadamente)
DELETE FROM `inventory_movements`;

-- Volcando estructura para tabla laravel.jobs
DROP TABLE IF EXISTS `jobs`;
CREATE TABLE IF NOT EXISTS `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.jobs: ~14 rows (aproximadamente)
DELETE FROM `jobs`;
INSERT INTO `jobs` (`id`, `queue`, `payload`, `attempts`, `reserved_at`, `available_at`, `created_at`) VALUES
	(10, 'default', '{"uuid":"5c64628e-603f-4a3f-b99a-8b03255ed68e","displayName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"30,60,120","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","command":"O:40:\\"App\\\\Jobs\\\\SendOrderAssignmentNotification\\":2:{s:9:\\"\\u0000*\\u0000pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:5:{i:0;s:4:\\"user\\";i:1;s:12:\\"user.empresa\\";i:2;s:17:\\"user.empresa.pais\\";i:3;s:8:\\"detalles\\";i:4;s:17:\\"detalles.producto\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:11:\\"\\u0000*\\u0000empleado\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:19:\\"App\\\\Models\\\\Empleado\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:1:{i:0;s:4:\\"user\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}"},"createdAt":1764250265,"delay":null}', 0, NULL, 1764250265, 1764250265),
	(11, 'default', '{"uuid":"7a5cfe2d-8382-4b64-b779-b2bf52a6ba12","displayName":"App\\\\Events\\\\PedidoActualizado","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:28:\\"App\\\\Events\\\\PedidoActualizado\\":2:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:4:{i:0;s:4:\\"user\\";i:1;s:8:\\"detalles\\";i:2;s:17:\\"detalles.producto\\";i:3;s:9:\\"empleados\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:6:\\"accion\\";s:17:\\"empleado_asignado\\";}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764250266,"delay":null}', 0, NULL, 1764250266, 1764250266),
	(12, 'default', '{"uuid":"6a442a5b-75b1-4021-ba60-51ac0b7c9a39","displayName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"30,60,120","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","command":"O:40:\\"App\\\\Jobs\\\\SendOrderAssignmentNotification\\":2:{s:9:\\"\\u0000*\\u0000pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:4;s:9:\\"relations\\";a:5:{i:0;s:4:\\"user\\";i:1;s:12:\\"user.empresa\\";i:2;s:17:\\"user.empresa.pais\\";i:3;s:8:\\"detalles\\";i:4;s:17:\\"detalles.producto\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:11:\\"\\u0000*\\u0000empleado\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:19:\\"App\\\\Models\\\\Empleado\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:1:{i:0;s:4:\\"user\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}"},"createdAt":1764250271,"delay":null}', 0, NULL, 1764250271, 1764250271),
	(13, 'default', '{"uuid":"5d8bc2d5-7444-48c7-a6ed-464e538fd280","displayName":"App\\\\Events\\\\PedidoActualizado","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:28:\\"App\\\\Events\\\\PedidoActualizado\\":2:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:4;s:9:\\"relations\\";a:4:{i:0;s:4:\\"user\\";i:1;s:8:\\"detalles\\";i:2;s:17:\\"detalles.producto\\";i:3;s:9:\\"empleados\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:6:\\"accion\\";s:17:\\"empleado_asignado\\";}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764250271,"delay":null}', 0, NULL, 1764250271, 1764250271),
	(14, 'default', '{"uuid":"67545e5d-c6f8-44bb-886c-713e7fcb2f6c","displayName":"App\\\\Jobs\\\\SendOrderWhatsAppNotification","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"30,60,120","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendOrderWhatsAppNotification","command":"O:38:\\"App\\\\Jobs\\\\SendOrderWhatsAppNotification\\":1:{s:9:\\"\\u0000*\\u0000pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:5:{i:0;s:4:\\"user\\";i:1;s:12:\\"user.empresa\\";i:2;s:17:\\"user.empresa.pais\\";i:3;s:8:\\"detalles\\";i:4;s:17:\\"detalles.producto\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}"},"createdAt":1764253171,"delay":null}', 0, NULL, 1764253171, 1764253171),
	(15, 'default', '{"uuid":"28cca7c7-e067-4103-8fce-c85402cecac1","displayName":"App\\\\Events\\\\PedidoUpdated","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:24:\\"App\\\\Events\\\\PedidoUpdated\\":1:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:0:{}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764253223,"delay":null}', 0, NULL, 1764253223, 1764253223),
	(16, 'default', '{"uuid":"e3ae6cda-1811-424b-b558-3aabe3f89edf","displayName":"App\\\\Events\\\\PedidoActualizado","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:28:\\"App\\\\Events\\\\PedidoActualizado\\":2:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:3:{i:0;s:5:\\"pagos\\";i:1;s:4:\\"user\\";i:2;s:9:\\"empleados\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:6:\\"accion\\";s:15:\\"pago_confirmado\\";}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764253223,"delay":null}', 0, NULL, 1764253223, 1764253223),
	(17, 'default', '{"uuid":"10399de0-0c24-46a6-9e8d-f7c40a9e7826","displayName":"App\\\\Events\\\\PedidoUpdated","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:24:\\"App\\\\Events\\\\PedidoUpdated\\":1:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:0:{}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764253232,"delay":null}', 0, NULL, 1764253232, 1764253232),
	(18, 'default', '{"uuid":"b851be14-c21b-4665-983d-64a048e82980","displayName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"30,60,120","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendOrderAssignmentNotification","command":"O:40:\\"App\\\\Jobs\\\\SendOrderAssignmentNotification\\":2:{s:9:\\"\\u0000*\\u0000pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:5:{i:0;s:4:\\"user\\";i:1;s:12:\\"user.empresa\\";i:2;s:17:\\"user.empresa.pais\\";i:3;s:8:\\"detalles\\";i:4;s:17:\\"detalles.producto\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:11:\\"\\u0000*\\u0000empleado\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:19:\\"App\\\\Models\\\\Empleado\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:1:{i:0;s:4:\\"user\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}"},"createdAt":1764253232,"delay":null}', 0, NULL, 1764253232, 1764253232),
	(19, 'default', '{"uuid":"ec6d34a7-ceca-4d63-b943-505168b2163f","displayName":"App\\\\Jobs\\\\SendOrderWhatsAppNotification","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"30,60,120","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendOrderWhatsAppNotification","command":"O:38:\\"App\\\\Jobs\\\\SendOrderWhatsAppNotification\\":1:{s:9:\\"\\u0000*\\u0000pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:5;s:9:\\"relations\\";a:5:{i:0;s:4:\\"user\\";i:1;s:12:\\"user.empresa\\";i:2;s:17:\\"user.empresa.pais\\";i:3;s:8:\\"detalles\\";i:4;s:17:\\"detalles.producto\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}"},"createdAt":1764250230,"delay":null}', 1, NULL, 1764253262, 1764253232),
	(20, 'default', '{"uuid":"a8cfd044-c4bf-4214-a596-3f86b0c8fdea","displayName":"App\\\\Events\\\\PedidoActualizado","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:28:\\"App\\\\Events\\\\PedidoActualizado\\":2:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:4:{i:0;s:4:\\"user\\";i:1;s:8:\\"detalles\\";i:2;s:17:\\"detalles.producto\\";i:3;s:9:\\"empleados\\";}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:6:\\"accion\\";s:17:\\"empleado_asignado\\";}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764253232,"delay":null}', 0, NULL, 1764253232, 1764253232),
	(21, 'default', '{"uuid":"faa5391f-20e6-4425-bc38-fe8e4a1ea70f","displayName":"App\\\\Events\\\\PedidoUpdated","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:24:\\"App\\\\Events\\\\PedidoUpdated\\":1:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:0:{}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764255909,"delay":null}', 0, NULL, 1764255909, 1764255909),
	(22, 'default', '{"uuid":"db88031b-fb11-467c-b667-993a61517628","displayName":"App\\\\Events\\\\PedidoUpdated","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":null,"maxExceptions":null,"failOnTimeout":false,"backoff":null,"timeout":null,"retryUntil":null,"data":{"commandName":"Illuminate\\\\Broadcasting\\\\BroadcastEvent","command":"O:38:\\"Illuminate\\\\Broadcasting\\\\BroadcastEvent\\":17:{s:5:\\"event\\";O:24:\\"App\\\\Events\\\\PedidoUpdated\\":1:{s:6:\\"pedido\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:17:\\"App\\\\Models\\\\Pedido\\";s:2:\\"id\\";i:6;s:9:\\"relations\\";a:0:{}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}}s:5:\\"tries\\";N;s:7:\\"timeout\\";N;s:7:\\"backoff\\";N;s:13:\\"maxExceptions\\";N;s:23:\\"deleteWhenMissingModels\\";b:1;s:10:\\"connection\\";N;s:5:\\"queue\\";N;s:12:\\"messageGroup\\";N;s:12:\\"deduplicator\\";N;s:5:\\"delay\\";N;s:11:\\"afterCommit\\";N;s:10:\\"middleware\\";a:0:{}s:7:\\"chained\\";a:0:{}s:15:\\"chainConnection\\";N;s:10:\\"chainQueue\\";N;s:19:\\"chainCatchCallbacks\\";N;}"},"createdAt":1764255914,"delay":null}', 0, NULL, 1764255914, 1764255914),
	(23, 'default', '{"uuid":"7361a2a8-a47f-4a98-b892-5ec5792fe27e","displayName":"App\\\\Jobs\\\\SendPasswordResetWhatsApp","job":"Illuminate\\\\Queue\\\\CallQueuedHandler@call","maxTries":3,"maxExceptions":null,"failOnTimeout":false,"backoff":"10,30,60","timeout":null,"retryUntil":null,"data":{"commandName":"App\\\\Jobs\\\\SendPasswordResetWhatsApp","command":"O:34:\\"App\\\\Jobs\\\\SendPasswordResetWhatsApp\\":2:{s:7:\\"\\u0000*\\u0000user\\";O:45:\\"Illuminate\\\\Contracts\\\\Database\\\\ModelIdentifier\\":5:{s:5:\\"class\\";s:15:\\"App\\\\Models\\\\User\\";s:2:\\"id\\";i:3;s:9:\\"relations\\";a:0:{}s:10:\\"connection\\";s:5:\\"mysql\\";s:15:\\"collectionClass\\";N;}s:14:\\"\\u0000*\\u0000newPassword\\";s:8:\\"79268166\\";}"},"createdAt":1764284538,"delay":null}', 0, NULL, 1764284538, 1764284538);

-- Volcando estructura para tabla laravel.job_batches
DROP TABLE IF EXISTS `job_batches`;
CREATE TABLE IF NOT EXISTS `job_batches` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int NOT NULL,
  `pending_jobs` int NOT NULL,
  `failed_jobs` int NOT NULL,
  `failed_job_ids` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int DEFAULT NULL,
  `created_at` int NOT NULL,
  `finished_at` int DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.job_batches: ~0 rows (aproximadamente)
DELETE FROM `job_batches`;

-- Volcando estructura para tabla laravel.marcas
DROP TABLE IF EXISTS `marcas`;
CREATE TABLE IF NOT EXISTS `marcas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `marcas_slug_unique` (`slug`),
  KEY `marcas_empresa_id_foreign` (`empresa_id`),
  KEY `marcas_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `marcas_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `marcas_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=106 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.marcas: ~105 rows (aproximadamente)
DELETE FROM `marcas`;
INSERT INTO `marcas` (`id`, `nombre`, `slug`, `descripcion`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
	(1, 'Polar', 'polar', 'Productos Polar', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(2, 'Mary', 'mary', 'Productos Mary', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(3, 'Santoni', 'santoni', 'Productos Santoni', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(4, 'Santa Monica', 'santa-monica', 'Productos Santa Monica', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(5, 'Amanecer', 'amanecer', 'Productos Amanecer', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(6, 'Capri', 'capri', 'Productos Capri', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(7, 'Allegri', 'allegri', 'Productos Allegri', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(8, 'Dobón', 'dobon', 'Productos Dobón', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(9, 'Pampero', 'pampero', 'Productos Pampero', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(10, 'Iberia', 'iberia', 'Productos Iberia', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(11, 'Boka', 'boka', 'Productos Boka', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(12, 'Coamo', 'coamo', 'Productos Coamo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(13, 'Pringles', 'pringles', 'Productos Pringles', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(14, 'Tom', 'tom', 'Productos Tom', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(15, 'Lucky Strike', 'lucky-strike', 'Productos Lucky Strike', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(16, 'Belmont', 'belmont', 'Productos Belmont', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(17, 'Chimo', 'chimo', 'Productos Chimo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(18, 'Pall Mall', 'pall-mall', 'Productos Pall Mall', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(19, 'Viceroy', 'viceroy', 'Productos Viceroy', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(20, 'Nova', 'nova', 'Productos Nova', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(21, 'Eclipse', 'eclipse', 'Productos Eclipse', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(22, 'Universal', 'universal', 'Productos Universal', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(23, 'Alive', 'alive', 'Productos Alive', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(24, 'Oso Blanco', 'oso-blanco', 'Productos Oso Blanco', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(25, 'Nutribela', 'nutribela', 'Productos Nutribela', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(26, 'Marlboro', 'marlboro', 'Productos Marlboro', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(27, 'Camel', 'camel', 'Productos Camel', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(28, 'Doritos', 'doritos', 'Productos Doritos', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(29, 'Lays', 'lays', 'Productos Lays', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(30, 'Ruffles', 'ruffles', 'Productos Ruffles', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(31, 'Cheetos', 'cheetos', 'Productos Cheetos', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(32, 'Oreo', 'oreo', 'Productos Oreo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(33, 'Ritz', 'ritz', 'Productos Ritz', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(34, 'Coca Cola', 'coca-cola', 'Productos Coca Cola', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(35, 'Pepsi', 'pepsi', 'Productos Pepsi', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(36, 'Sprite', 'sprite', 'Productos Sprite', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(37, 'Fanta', 'fanta', 'Productos Fanta', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(38, 'Nestlé', 'nestle', 'Productos Nestlé', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(39, 'Maggi', 'maggi', 'Productos Maggi', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(40, 'Knorr', 'knorr', 'Productos Knorr', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(41, 'Hellmanns', 'hellmanns', 'Productos Hellmanns', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(42, 'Heinz', 'heinz', 'Productos Heinz', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(43, 'Kelloggs', 'kelloggs', 'Productos Kelloggs', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(44, 'Quaker', 'quaker', 'Productos Quaker', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(45, 'Tapa Amarilla', 'tapa-amarilla', 'Productos Tapa Amarilla', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(46, 'Rexona', 'rexona', 'Productos Rexona', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(47, 'Carabobo', 'carabobo', 'Productos Carabobo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(48, 'Frut Cola', 'frut-cola', 'Productos Frut Cola', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(49, 'Minalba', 'minalba', 'Productos Minalba', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(50, 'Cool', 'cool', 'Productos Cool', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(51, 'Vista', 'vista', 'Productos Vista', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(52, 'Aldor', 'aldor', 'Productos Aldor', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(53, 'Alident', 'alident', 'Productos Alident', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(54, 'Montalbán', 'montalban', 'Productos Montalbán', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(55, 'Cerro del Santo', 'cerro-del-santo', 'Productos Cerro del Santo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(56, 'Cheese Tris', 'cheese-tris', 'Productos Cheese Tris', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(57, 'Carolina', 'carolina', 'Productos Carolina', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(58, 'Colgate', 'colgate', 'Productos Colgate', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(59, 'Cremor', 'cremor', 'Productos Cremor', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(60, 'Diablito Under Wood', 'diablito-under-wood', 'Productos Diablito Under Wood', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(61, 'Don Kat', 'don-kat', 'Productos Don Kat', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(62, 'Frubys', 'frubys', 'Productos Frubys', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(63, 'Frutea', 'frutea', 'Productos Frutea', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(64, 'Fruttsy', 'fruttsy', 'Productos Fruttsy', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(65, 'Frutys', 'frutys', 'Productos Frutys', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(66, 'Santa María', 'santa-maria', 'Productos Santa María', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(67, 'Anita', 'anita', 'Productos Anita', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(68, 'Frita', 'frita', 'Productos Frita', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(69, 'Jucosa', 'jucosa', 'Productos Jucosa', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(70, 'El Valle', 'el-valle', 'Productos El Valle', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(71, 'Lady Speed Stick', 'lady-speed-stick', 'Productos Lady Speed Stick', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(72, 'Aromax', 'aromax', 'Productos Aromax', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(73, 'Lipton', 'lipton', 'Productos Lipton', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(74, 'Deline', 'deline', 'Productos Deline', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(75, 'Mirringo', 'mirringo', 'Productos Mirringo', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(76, 'Natulac', 'natulac', 'Productos Natulac', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(77, 'Concordia', 'concordia', 'Productos Concordia', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(78, 'Baby Finger', 'baby-finger', 'Productos Baby Finger', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(79, 'Hugme', 'hugme', 'Productos Hugme', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(80, 'Pin Pop', 'pin-pop', 'Productos Pin Pop', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(81, 'Power Max', 'power-max', 'Productos Power Max', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(82, 'Ideal', 'ideal', 'Productos Ideal', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(83, 'La Lucha', 'la-lucha', 'Productos La Lucha', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(84, 'Blue Softy', 'blue-softy', 'Productos Blue Softy', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(85, 'Speed Stick', 'speed-stick', 'Productos Speed Stick', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(86, 'Suavitel', 'suavitel', 'Productos Suavitel', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(87, 'Super Pega', 'super-pega', 'Productos Super Pega', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(88, 'Tam Cikolatam', 'tam-cikolatam', 'Productos Tam Cikolatam', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(89, 'Puffy', 'puffy', 'Productos Puffy', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(90, 'Saltitacos', 'saltitacos', 'Productos Saltitacos', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(91, 'Fruton', 'fruton', 'Productos Fruton', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(92, 'Glup', 'glup', 'Productos Glup', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(93, 'Cristal', 'cristal', 'Productos Cristal', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(94, 'Valencia', 'valencia', 'Productos Valencia', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(95, 'Justy', 'justy', 'Productos Justy', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(96, 'Speed', 'speed', 'Productos Speed', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(97, 'Gatorade', 'gatorade', 'Productos Gatorade', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(98, 'Mi Brisa', 'mi-brisa', 'Productos Mi Brisa', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(99, 'Heal', 'heal', 'Productos Heal', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(100, 'Golden', 'golden', 'Productos Golden', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(101, 'Frescolita', 'frescolita', 'Productos Frescolita', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(102, 'Chinotto', 'chinotto', 'Productos Chinotto', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(103, 'Hit', 'hit', 'Productos Hit', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(104, 'Encendedor', 'encendedor', 'Productos Encendedor', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(105, 'Panelada', 'panelada', 'Productos Panelada', 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03');

-- Volcando estructura para tabla laravel.migrations
DROP TABLE IF EXISTS `migrations`;
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.migrations: ~72 rows (aproximadamente)
DELETE FROM `migrations`;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '0001_01_01_000000_create_users_table', 1),
	(2, '0001_01_01_000001_create_cache_table', 1),
	(3, '0001_01_01_000002_create_jobs_table', 1),
	(4, '2023_10_21_000000_add_two_factor_columns_to_users_table', 1),
	(5, '2024_01_01_000000_create_template_customizations_table', 1),
	(6, '2025_10_17_000000_add_verification_code_to_users_table', 1),
	(7, '2025_10_17_000001_create_active_sessions_table', 1),
	(8, '2025_10_17_000002_add_fields_to_active_sessions_table', 1),
	(9, '2025_10_17_205657_create_empresas_table', 1),
	(10, '2025_10_17_214709_create_sucursales_table', 1),
	(11, '2025_10_20_132700_add_empresa_id_to_users_table', 1),
	(12, '2025_10_20_171800_add_profile_fields_to_users_table', 1),
	(13, '2025_10_20_200325_create_permission_tables', 1),
	(14, '2025_10_22_201649_add_telefono_and_email_to_empresas_table', 1),
	(15, '2025_10_24_162929_add_module_to_permissions_table', 1),
	(16, '2025_10_27_020859_create_notifications_table', 1),
	(17, '2025_10_27_022318_create_activity_log_table', 1),
	(18, '2025_10_27_022319_add_event_column_to_activity_log_table', 1),
	(19, '2025_10_27_022320_add_batch_uuid_column_to_activity_log_table', 1),
	(20, '2025_10_29_123000_create_comprobantes_table', 1),
	(21, '2025_11_01_000000_create_series_table', 1),
	(22, '2025_11_03_000001_create_cajas_table', 1),
	(23, '2025_11_03_160220_create_exchange_rates_table', 1),
	(24, '2025_11_03_161309_fix_exchange_rates_source_column', 1),
	(25, '2025_11_03_162823_add_numero_corte_to_cajas_table', 1),
	(26, '2025_11_05_090016_create_reunions_table', 1),
	(27, '2025_11_05_100000_remove_unique_constraint_from_cajas_table', 1),
	(28, '2025_11_06_090055_create_pais_table', 1),
	(29, '2025_11_06_090208_add_pais_id_to_empresas_table', 1),
	(30, '2025_11_10_120000_create_clientes_table', 1),
	(31, '2025_11_10_150121_create_marcas_table', 1),
	(32, '2025_11_10_150141_create_categorias_table', 1),
	(33, '2025_11_10_154642_create_productos_table', 1),
	(34, '2025_11_10_155453_create_images_table', 1),
	(35, '2025_11_10_155454_add_fields_to_images_table', 1),
	(36, '2025_11_10_160000_create_producto_variants_table', 1),
	(37, '2025_11_10_160001_add_image_fields_to_producto_variants_table', 1),
	(38, '2025_11_10_160002_add_sku_price_adjustment_quantity_to_producto_variants_table', 1),
	(39, '2025_11_10_160003_add_additional_fields_to_productos_table', 1),
	(40, '2025_11_10_160004_create_producto_inventory_settings_table', 1),
	(41, '2025_11_10_160005_create_producto_seo_table', 1),
	(42, '2025_11_13_000001_create_reviews_table', 1),
	(43, '2025_11_13_122414_create_wishlists_table', 1),
	(44, '2025_11_13_143714_create_search_index_for_products_table', 1),
	(45, '2025_11_14_083315_create_pedidos_table', 1),
	(46, '2025_11_14_083326_create_detalle_pedidos_table', 1),
	(47, '2025_11_14_121623_create_movimiento_pedido_table', 1),
	(48, '2025_11_14_152802_add_username_and_telephone_to_users_table', 1),
	(49, '2025_11_14_160052_add_note_to_pedidos_table', 1),
	(50, '2025_11_14_200523_create_pedido_pago_table', 1),
	(51, '2025_11_14_200524_add_total_bs_to_pedido_pago_table', 1),
	(52, '2025_11_15_000001_create_bancos_table', 1),
	(53, '2025_11_15_000002_create_referencias_bancarias_table', 1),
	(54, '2025_11_15_122143_add_tipo_atencion_to_historico_pedidos', 1),
	(55, '2025_11_15_125248_add_nota_to_pedido_pago', 1),
	(56, '2025_11_16_204410_add_location_fields_to_active_sessions_table', 1),
	(57, '2025_11_16_204411_create_empleados_table', 1),
	(58, '2025_11_17_000000_create_empleado_pedido_table', 1),
	(59, '2025_11_17_005213_add_caja_id_to_pedido_pago_table', 1),
	(60, '2025_11_24_085341_create_personal_access_tokens_table', 1),
	(61, '2025_11_24_090034_add_api_token_to_users_table', 1),
	(62, '2025_11_24_103514_add_unique_constraint_to_wishlists_table', 1),
	(63, '2025_11_24_125702_add_fecha_entrega_to_pedidos_table', 1),
	(64, '2025_11_24_130441_create_resenas_table', 1),
	(65, '2025_12_19_000000_add_simbolo_moneda_to_pais_table', 1),
	(66, '2025_11_26_123000_create_pedido_historial_table', 2),
	(67, '2025_01_27_000000_add_profile_fields_to_users_table', 3),
	(68, '2025_11_26_220850_create_product_reviews_table', 3),
	(69, '2025_11_27_101754_ensure_empleado_pedido_table_exists', 3),
	(70, '2025_11_26_000000_add_precio_bs_to_producto_variants_table', 4),
	(71, '2024_01_01_000001_create_inventory_movements_table', 5),
	(72, '2025_11_26_000000_add_sucursal_id_to_products_table', 6);

-- Volcando estructura para tabla laravel.model_has_permissions
DROP TABLE IF EXISTS `model_has_permissions`;
CREATE TABLE IF NOT EXISTS `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.model_has_permissions: ~0 rows (aproximadamente)
DELETE FROM `model_has_permissions`;

-- Volcando estructura para tabla laravel.model_has_roles
DROP TABLE IF EXISTS `model_has_roles`;
CREATE TABLE IF NOT EXISTS `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.model_has_roles: ~9 rows (aproximadamente)
DELETE FROM `model_has_roles`;
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
	(1, 'App\\Models\\User', 1),
	(2, 'App\\Models\\User', 2),
	(4, 'App\\Models\\User', 3),
	(5, 'App\\Models\\User', 4),
	(5, 'App\\Models\\User', 5),
	(5, 'App\\Models\\User', 6),
	(5, 'App\\Models\\User', 7),
	(5, 'App\\Models\\User', 8),
	(5, 'App\\Models\\User', 9);

-- Volcando estructura para tabla laravel.notifications
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE IF NOT EXISTS `notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `data` json DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_user_id_read_at_index` (`user_id`,`read_at`),
  CONSTRAINT `notifications_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.notifications: ~0 rows (aproximadamente)
DELETE FROM `notifications`;

-- Volcando estructura para tabla laravel.pais
DROP TABLE IF EXISTS `pais`;
CREATE TABLE IF NOT EXISTS `pais` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso2` varchar(2) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_iso3` varchar(3) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo_telefonico` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `moneda_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `simbolo_moneda` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idioma_principal` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `continente` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zona_horaria` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `formato_fecha` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'dd/mm/yyyy',
  `formato_moneda` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1.234,56',
  `impuesto_predeterminado` decimal(5,2) NOT NULL DEFAULT '0.00',
  `separador_miles` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '.',
  `separador_decimales` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT ',',
  `decimales_moneda` int NOT NULL DEFAULT '2',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pais_codigo_iso2_unique` (`codigo_iso2`),
  UNIQUE KEY `pais_codigo_iso3_unique` (`codigo_iso3`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.pais: ~20 rows (aproximadamente)
DELETE FROM `pais`;
INSERT INTO `pais` (`id`, `nombre`, `codigo_iso2`, `codigo_iso3`, `codigo_telefonico`, `moneda_principal`, `simbolo_moneda`, `idioma_principal`, `continente`, `zona_horaria`, `formato_fecha`, `formato_moneda`, `impuesto_predeterminado`, `separador_miles`, `separador_decimales`, `decimales_moneda`, `activo`, `created_at`, `updated_at`) VALUES
	(1, 'Argentina', 'AR', 'ARG', '+54', 'ARS', '$', 'es', 'América del Sur', 'America/Argentina/Buenos_Aires', 'dd/mm/yyyy', '1.234,56', 21.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(2, 'Bolivia', 'BO', 'BOL', '+591', 'BOB', 'Bs.', 'es', 'América del Sur', 'America/La_Paz', 'dd/mm/yyyy', '1.234,56', 13.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(3, 'Brasil', 'BR', 'BRA', '+55', 'BRL', 'R$', 'pt', 'América del Sur', 'America/Sao_Paulo', 'dd/mm/yyyy', '1.234,56', 17.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(4, 'Chile', 'CL', 'CHL', '+56', 'CLP', '$', 'es', 'América del Sur', 'America/Santiago', 'dd-mm-yyyy', '1.234.567', 19.00, '.', '', 0, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(5, 'Colombia', 'CO', 'COL', '+57', 'COP', '$', 'es', 'América del Sur', 'America/Bogota', 'dd/mm/yyyy', '$1.234,56', 19.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(6, 'Costa Rica', 'CR', 'CRI', '+506', 'CRC', '₡', 'es', 'América Central', 'America/Costa_Rica', 'dd/mm/yyyy', '1.234,56', 13.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(7, 'Cuba', 'CU', 'CUB', '+53', 'CUP', '$', 'es', 'El Caribe', 'America/Havana', 'dd/mm/yyyy', '1.234,56', 10.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(8, 'Ecuador', 'EC', 'ECU', '+593', 'USD', '$', 'es', 'América del Sur', 'America/Guayaquil', 'dd/mm/yyyy', '$1.234,56', 12.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(9, 'El Salvador', 'SV', 'SLV', '+503', 'USD', '$', 'es', 'América Central', 'America/El_Salvador', 'dd/mm/yyyy', '$1.234,56', 13.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(10, 'Guatemala', 'GT', 'GTM', '+502', 'GTQ', 'Q', 'es', 'América Central', 'America/Guatemala', 'dd/mm/yyyy', 'Q1.234,56', 12.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(11, 'Honduras', 'HN', 'HND', '+504', 'HNL', 'L', 'es', 'América Central', 'America/Tegucigalpa', 'dd/mm/yyyy', 'L1.234,56', 15.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(12, 'México', 'MX', 'MEX', '+52', 'MXN', '$', 'es', 'América del Norte', 'America/Mexico_City', 'dd/mm/yyyy', '$1.234,56', 16.00, ',', '.', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(13, 'Nicaragua', 'NI', 'NIC', '+505', 'NIO', 'C$', 'es', 'América Central', 'America/Managua', 'dd/mm/yyyy', 'C$1.234,56', 15.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(14, 'Panamá', 'PA', 'PAN', '+507', 'USD', '$', 'es', 'América Central', 'America/Panama', 'dd/mm/yyyy', '$1.234,56', 7.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(15, 'Paraguay', 'PY', 'PRY', '+595', 'PYG', '₲', 'es', 'América del Sur', 'America/Asuncion', 'dd/mm/yyyy', '₲1.234,56', 10.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(16, 'Perú', 'PE', 'PER', '+51', 'PEN', 'S/.', 'es', 'América del Sur', 'America/Lima', 'dd/mm/yyyy', 'S/. 1.234,56', 18.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(17, 'Puerto Rico', 'PR', 'PRI', '+1', 'USD', '$', 'es', 'El Caribe', 'America/Puerto_Rico', 'mm/dd/yyyy', '$1,234.56', 11.50, ',', '.', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(18, 'República Dominicana', 'DO', 'DOM', '+1', 'DOP', 'RD$', 'es', 'El Caribe', 'America/Santo_Domingo', 'dd/mm/yyyy', 'RD$1.234,56', 18.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(19, 'Uruguay', 'UY', 'URY', '+598', 'UYU', '$U', 'es', 'América del Sur', 'America/Montevideo', 'dd/mm/yyyy', '$U 1.234,56', 22.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(20, 'Venezuela', 'VE', 'VEN', '+58', 'VES', '$', 'es', 'América del Sur', 'America/Caracas', 'dd/mm/yyyy', 'Bs. 1.234,56', 16.00, '.', ',', 2, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02');

-- Volcando estructura para tabla laravel.password_reset_tokens
DROP TABLE IF EXISTS `password_reset_tokens`;
CREATE TABLE IF NOT EXISTS `password_reset_tokens` (
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.password_reset_tokens: ~0 rows (aproximadamente)
DELETE FROM `password_reset_tokens`;

-- Volcando estructura para tabla laravel.pedidos
DROP TABLE IF EXISTS `pedidos`;
CREATE TABLE IF NOT EXISTS `pedidos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `fecha_entrega` timestamp NULL DEFAULT NULL,
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `codigo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `latitud` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `nota` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedidos_empresaid_foreign` (`empresaId`),
  KEY `pedidos_userid_foreign` (`userId`),
  CONSTRAINT `pedidos_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedidos_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.pedidos: ~6 rows (aproximadamente)
DELETE FROM `pedidos`;
INSERT INTO `pedidos` (`id`, `fecha`, `fecha_entrega`, `total_usd`, `total_bs`, `codigo`, `metodo_pago`, `ubicacion`, `longitud`, `latitud`, `nota`, `estado`, `empresaId`, `userId`, `created_at`, `updated_at`) VALUES
	(1, '2025-11-26 11:32:24', '2025-11-26 15:55:54', '3.95', '3.95', '1', 'Pago Móvil', 'Coordenadas: 10.496247, -66.881078. Por favor, corrige esta dirección.', '-66.88107824515', '10.49624673279', NULL, 'entregado', 1, 2, '2025-11-26 15:32:24', '2025-11-26 16:39:25'),
	(2, '2025-11-26 12:03:08', '2025-11-26 16:09:27', '74.25', '74.25', '3', 'Efectivo', 'Coordenadas: 10.496283, -66.881054. Por favor, corrige esta dirección.', '-66.881054156342', '10.496283182522', NULL, 'entregado', 1, 2, '2025-11-26 16:03:08', '2025-11-26 16:09:27'),
	(3, '2025-11-26 12:13:08', '2025-11-26 16:31:18', '17.75', '17.75', '4', 'Efectivo', 'Llegada, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.881053327039', '10.496271797425', NULL, 'entregado', 1, 2, '2025-11-26 16:13:08', '2025-11-26 16:31:18'),
	(4, '2025-11-26 14:24:37', '2025-11-27 13:33:03', '77.1', '77.1', '0005', 'Pago Móvil', 'Llegada, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.88107824514962', '10.496246732790322', NULL, 'entregado', 1, 2, '2025-11-26 18:24:37', '2025-11-27 13:33:03'),
	(5, '2025-11-27 09:30:30', '2025-11-27 13:33:26', '1.05', '1.05', '0006', 'Efectivo Bs', 'Bajo el Reloj, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.8813307', '10.4962548', NULL, 'entregado', 1, 2, '2025-11-27 13:30:30', '2025-11-27 13:33:26'),
	(6, '2025-11-27 10:19:31', '2025-11-27 15:05:14', '18.4', '18.4', '0007', 'Pago Móvil', 'Bajo el Reloj, Avenida Las Acacias, Las Delicias, Sabana Grande, Caracas, Parroquia El Recreo, Municipio Libertador, Distrito Metropolitano de Caracas, Distrito Capital, 1050, Venezuela', '-66.8813366', '10.4962642', NULL, 'entregado', 1, 2, '2025-11-27 14:19:31', '2025-11-27 15:05:14');

-- Volcando estructura para tabla laravel.pedido_historial
DROP TABLE IF EXISTS `pedido_historial`;
CREATE TABLE IF NOT EXISTS `pedido_historial` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `estado` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `usuario_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_historial_pedido_id_foreign` (`pedido_id`),
  KEY `pedido_historial_usuario_id_foreign` (`usuario_id`),
  CONSTRAINT `pedido_historial_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_historial_usuario_id_foreign` FOREIGN KEY (`usuario_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.pedido_historial: ~0 rows (aproximadamente)
DELETE FROM `pedido_historial`;

-- Volcando estructura para tabla laravel.pedido_pago
DROP TABLE IF EXISTS `pedido_pago`;
CREATE TABLE IF NOT EXISTS `pedido_pago` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `caja_id` bigint unsigned DEFAULT NULL,
  `fecha` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '2025-11-26',
  `total_usd` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_bs` decimal(15,2) DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metodo_pago` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresaId` bigint unsigned NOT NULL,
  `userId` bigint unsigned NOT NULL,
  `pedidoId` bigint unsigned NOT NULL,
  `nota` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'PENDENTE',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pedido_pago_empresaid_foreign` (`empresaId`),
  KEY `pedido_pago_userid_foreign` (`userId`),
  KEY `pedido_pago_pedidoid_foreign` (`pedidoId`),
  KEY `pedido_pago_caja_id_foreign` (`caja_id`),
  CONSTRAINT `pedido_pago_caja_id_foreign` FOREIGN KEY (`caja_id`) REFERENCES `cajas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `pedido_pago_empresaid_foreign` FOREIGN KEY (`empresaId`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_pedidoid_foreign` FOREIGN KEY (`pedidoId`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `pedido_pago_userid_foreign` FOREIGN KEY (`userId`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.pedido_pago: ~6 rows (aproximadamente)
DELETE FROM `pedido_pago`;
INSERT INTO `pedido_pago` (`id`, `caja_id`, `fecha`, `total_usd`, `total_bs`, `referencia`, `metodo_pago`, `empresaId`, `userId`, `pedidoId`, `nota`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, '2025-11-26', '3.95', 3.95, '8456', 'Pago Móvil', 1, 2, 1, '', 'Pagado', '2025-11-26 15:32:24', '2025-11-26 15:32:59'),
	(2, 1, '2025-11-26', '74.25', 74.25, NULL, 'Efectivo', 1, 2, 2, '', 'Pagado', '2025-11-26 16:03:08', '2025-11-26 16:03:42'),
	(3, 1, '2025-11-26', '17.75', 17.75, NULL, 'Efectivo', 1, 2, 3, '', 'Pagado', '2025-11-26 16:13:08', '2025-11-26 16:13:32'),
	(4, 2, '2025-11-26', '77.10', 77.10, '8569', 'Pago Móvil', 1, 2, 4, '', 'Pagado', '2025-11-26 18:24:37', '2025-11-27 13:30:59'),
	(5, 2, '2025-11-26', '1.05', 1.05, NULL, 'Efectivo Bs', 1, 2, 5, '', 'Pagado', '2025-11-27 13:30:30', '2025-11-27 13:30:56'),
	(6, 2, '2025-11-26', '18.40', 18.40, '5632', 'Pago Móvil', 1, 2, 6, '', 'Pagado', '2025-11-27 14:19:31', '2025-11-27 14:20:23');

-- Volcando estructura para tabla laravel.permissions
DROP TABLE IF EXISTS `permissions`;
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`),
  KEY `permissions_module_index` (`module`)
) ENGINE=InnoDB AUTO_INCREMENT=174 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.permissions: ~173 rows (aproximadamente)
DELETE FROM `permissions`;
INSERT INTO `permissions` (`id`, `name`, `module`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'access empresas', 'empresas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(2, 'create empresas', 'empresas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(3, 'edit empresas', 'empresas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(4, 'delete empresas', 'empresas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(5, 'access paises', 'paises', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(6, 'create paises', 'paises', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(7, 'edit paises', 'paises', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(8, 'delete paises', 'paises', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(9, 'access sucursales', 'sucursales', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(10, 'create sucursales', 'sucursales', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(11, 'edit sucursales', 'sucursales', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(12, 'delete sucursales', 'sucursales', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(13, 'access users', 'users', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(14, 'create users', 'users', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(15, 'edit users', 'users', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(16, 'delete users', 'users', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(17, 'access roles', 'roles', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(18, 'create roles', 'roles', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(19, 'edit roles', 'roles', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(20, 'delete roles', 'roles', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(21, 'assign roles', 'roles', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(22, 'access permissions', 'permissions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(23, 'create permissions', 'permissions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(24, 'edit permissions', 'permissions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(25, 'delete permissions', 'permissions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(26, 'assign permissions', 'permissions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(27, 'access school years', 'school_years', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(28, 'create school years', 'school_years', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(29, 'edit school years', 'school_years', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(30, 'delete school years', 'school_years', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(31, 'access school periods', 'school_periods', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(32, 'create school periods', 'school_periods', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(33, 'edit school periods', 'school_periods', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(34, 'delete school periods', 'school_periods', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(35, 'access educational levels', 'educational_levels', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(36, 'create educational levels', 'educational_levels', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(37, 'edit educational levels', 'educational_levels', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(38, 'delete educational levels', 'educational_levels', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(39, 'access turnos', 'turnos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(40, 'create turnos', 'turnos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(41, 'edit turnos', 'turnos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(42, 'delete turnos', 'turnos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(43, 'access students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(44, 'create students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(45, 'edit students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(46, 'delete students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(47, 'access student control', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(48, 'export students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(49, 'import students', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(50, 'view student historico', 'students', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(51, 'view active sessions', 'active_sessions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(52, 'delete active sessions', 'active_sessions', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(53, 'dashboard.metrics', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(54, 'dashboard.comparison', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(55, 'dashboard.employees', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(56, 'dashboard.performance', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(57, 'dashboard.inventory', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(58, 'dashboard.customers', 'dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(59, 'access niveles educativos', 'niveles_educativos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(60, 'create niveles educativos', 'niveles_educativos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(61, 'edit niveles educativos', 'niveles_educativos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(62, 'delete niveles educativos', 'niveles_educativos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(63, 'access monitoreo', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(64, 'view monitoreo servidor', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(65, 'view monitoreo base-datos', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(66, 'view monitoreo estudiantes', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(67, 'view monitoreo accesos', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(68, 'export monitoreo accesos', 'monitoreo', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(69, 'access matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(70, 'create matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(71, 'edit matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(72, 'delete matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(73, 'view matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(74, 'cambiar cuotas matriculas', 'matriculas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(75, 'access pagos', 'pagos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(76, 'create pagos', 'pagos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(77, 'edit pagos', 'pagos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(78, 'delete pagos', 'pagos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(79, 'view pagos', 'pagos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(80, 'access conceptos pago', 'conceptos_pago', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(81, 'create conceptos pago', 'conceptos_pago', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(82, 'edit conceptos pago', 'conceptos_pago', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(83, 'delete conceptos pago', 'conceptos_pago', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(84, 'view conceptos pago', 'conceptos_pago', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(85, 'access programas', 'programas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(86, 'create programas', 'programas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(87, 'edit programas', 'programas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(88, 'delete programas', 'programas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(89, 'view programas', 'programas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(90, 'access reportes', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(91, 'view estado cuentas', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(92, 'view resumen pagos', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(93, 'view morosidad', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(94, 'view ingresos totales', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(95, 'view historico matriculas', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(96, 'export reportes', 'reportes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(97, 'access activity log', 'activity_log', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(98, 'view activity log', 'activity_log', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(99, 'delete activity log', 'activity_log', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(100, 'export activity log', 'activity_log', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(101, 'access mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(102, 'create mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(103, 'edit mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(104, 'delete mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(105, 'send mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(106, 'receive mensajeria', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(107, 'manage mensajeria templates', 'mensajeria', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(108, 'access biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(109, 'create biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(110, 'edit biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(111, 'delete biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(112, 'upload biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(113, 'download biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(114, 'share biblioteca', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(115, 'manage biblioteca categories', 'biblioteca', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(116, 'access series', 'series', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(117, 'create series', 'series', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(118, 'edit series', 'series', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(119, 'delete series', 'series', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(120, 'access cajas', 'cajas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(121, 'create cajas', 'cajas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(122, 'edit cajas', 'cajas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(123, 'delete cajas', 'cajas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(124, 'view cajas', 'cajas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(125, 'view exchange-rates', 'exchange_rates', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(126, 'fetch exchange-rates', 'exchange_rates', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(127, 'manage exchange-rates', 'exchange_rates', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(128, 'access reuniones', 'reuniones', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(129, 'create reuniones', 'reuniones', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(130, 'edit reuniones', 'reuniones', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(131, 'delete reuniones', 'reuniones', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(132, 'view reuniones', 'reuniones', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(133, 'access late payment rules', 'late_payment_rules', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(134, 'create late payment rules', 'late_payment_rules', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(135, 'edit late payment rules', 'late_payment_rules', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(136, 'delete late payment rules', 'late_payment_rules', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(137, 'access pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(138, 'view pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(139, 'create pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(140, 'edit pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(141, 'delete pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(142, 'confirmar pago pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(143, 'asignar empleado pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(144, 'cancelar pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(145, 'finalizar entrega pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(146, 'revertir pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(147, 'view own pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(148, 'edit own pedidos', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(149, 'view own pedido', 'pedidos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(150, 'view own profile', 'clientes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(151, 'edit own profile', 'clientes', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(152, 'access categorias', 'categorias', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(153, 'create categorias', 'categorias', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(154, 'edit categorias', 'categorias', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(155, 'delete categorias', 'categorias', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(156, 'view categorias', 'categorias', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(157, 'access marcas', 'marcas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(158, 'create marcas', 'marcas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(159, 'edit marcas', 'marcas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(160, 'delete marcas', 'marcas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(161, 'view marcas', 'marcas', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(162, 'access productos', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(163, 'create productos', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(164, 'edit productos', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(165, 'delete productos', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(166, 'view productos', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(167, 'view product details', 'productos', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(168, 'access empleados', 'empleados', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(169, 'create empleados', 'empleados', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(170, 'edit empleados', 'empleados', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(171, 'delete empleados', 'empleados', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(172, 'view empleados', 'empleados', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(173, 'access whatsapp dashboard', 'whatsapp_dashboard', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02');

-- Volcando estructura para tabla laravel.personal_access_tokens
DROP TABLE IF EXISTS `personal_access_tokens`;
CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`),
  KEY `personal_access_tokens_expires_at_index` (`expires_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.personal_access_tokens: ~0 rows (aproximadamente)
DELETE FROM `personal_access_tokens`;

-- Volcando estructura para tabla laravel.productos
DROP TABLE IF EXISTS `productos`;
CREATE TABLE IF NOT EXISTS `productos` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) NOT NULL DEFAULT '0.00',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `has_variants` tinyint(1) NOT NULL DEFAULT '0',
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `quantity` int NOT NULL DEFAULT '0',
  `quantity_alert` int NOT NULL DEFAULT '0',
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `categoria_id` bigint unsigned NOT NULL,
  `marca_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `productos_code_unique` (`code`),
  KEY `productos_empresa_id_index` (`empresa_id`),
  KEY `productos_categoria_id_index` (`categoria_id`),
  KEY `productos_marca_id_index` (`marca_id`),
  KEY `productos_name_index` (`name`),
  KEY `productos_price_index` (`price`),
  KEY `productos_quantity_index` (`quantity`),
  KEY `productos_status_quantity_index` (`status`,`quantity`),
  KEY `productos_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `productos_categoria_id_foreign` FOREIGN KEY (`categoria_id`) REFERENCES `categorias` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_marca_id_foreign` FOREIGN KEY (`marca_id`) REFERENCES `marcas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `productos_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=283 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.productos: ~256 rows (aproximadamente)
DELETE FROM `productos`;
INSERT INTO `productos` (`id`, `code`, `sku`, `barcode`, `name`, `price`, `precio_bs`, `description`, `tags`, `meta_title`, `meta_description`, `has_variants`, `track_inventory`, `featured`, `allow_backorder`, `inventory_policy`, `quantity`, `quantity_alert`, `status`, `empresa_id`, `sucursal_id`, `categoria_id`, `marca_id`, `created_at`, `updated_at`) VALUES
	(1, 'ARR-65271', NULL, NULL, 'Arroz Blanco Polar', 1.50, 52.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(2, 'HAR-59845', NULL, NULL, 'Harina de Maíz Precocida Polar', 1.20, 42.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 200, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(3, 'HAR-23798', NULL, NULL, 'Harina de Trigo Pol', 1.20, 42.00, 'Harina de trigo 1kg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 200, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(4, 'ACE-59195', NULL, NULL, 'Aceite Coamo Oleo de soja 900ML', 2.00, 70.00, 'Aceite de soja 900ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 12, '2025-11-21 05:13:56', '2025-11-21 05:24:14'),
	(5, 'PAS-55602', NULL, NULL, 'Pasta Larga tipo Spaghetti Santa Rita', 0.90, 31.50, 'Pasta seca tipo spaghetti', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 110, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(6, 'AZU-38775', NULL, NULL, 'Azucar Amanecer IKG', 1.10, 38.50, 'Azucar Amanecer IKG', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 1, 5, '2025-11-21 05:13:56', '2025-11-21 05:43:52'),
	(7, 'SAL-61388', NULL, NULL, 'Sal de Mesa', 0.50, 17.50, 'Sal de mesa refinada', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(8, 'CAF-10244', NULL, NULL, 'Café Cerro del Santo 100 MG', 2.80, 98.00, 'Café Cerro del Santo 100 MG\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 55, '2025-11-21 05:13:56', '2025-11-21 05:47:59'),
	(9, 'LEC-17144', NULL, NULL, 'Leche en Polvo', 3.20, 112.00, 'Leche en polvo entera', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 125, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(10, 'GAL-30451', NULL, NULL, 'Galletas Saladas', 0.80, 28.00, 'Galletas saladas clásicas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 120, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(11, 'SAL-71890', NULL, NULL, 'Salsa de Tomate Ketchup heinz', 1.50, 52.50, 'Salsa de tomate Ketchup Heinz 397 ML', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 1, 42, '2025-11-21 05:13:56', '2025-11-28 02:48:12'),
	(12, 'MAY-85946', NULL, NULL, 'Mayonesa 175 MG', 1.80, 63.00, 'Mayonesa 175 MG', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 07:23:20'),
	(13, 'MER-24794', NULL, NULL, 'Mermelada Fresa', 2.20, 77.00, 'Mermelada de fresa', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(14, 'ATU-20155', NULL, NULL, 'Atún en Agua', 1.90, 66.50, 'Atún en agua', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(15, 'SAR-10321', NULL, NULL, 'Sardinas en Aceite', 1.60, 56.00, 'Sardinas en aceite vegetal', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 1, 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(16, 'ARR-84693', NULL, NULL, 'Arroz Blanco Mary', 1.40, 49.00, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 2, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(17, 'HAR-79011', NULL, NULL, 'Harina de Maíz Precocida Mary', 1.10, 38.50, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 2, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(18, 'ARR-29924', NULL, NULL, 'Arroz Blanco Santoni', 1.60, 56.00, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 3, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(19, 'HAR-21728', NULL, NULL, 'Harina de Maíz Precocida Santoni', 1.30, 45.50, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 3, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(20, 'ARR-42242', NULL, NULL, 'Arroz Blanco Santa Monica', 1.70, 59.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 4, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(21, 'HAR-37322', NULL, NULL, 'Harina de Maíz Precocida Santa Monica', 1.40, 49.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 4, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(22, 'ARR-94740', NULL, NULL, 'Arroz Blanco Amanecer', 1.80, 63.00, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 5, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(23, 'HAR-44080', NULL, NULL, 'Harina de Maíz Precocida Amanecer', 1.50, 52.50, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 5, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(24, 'ARR-38657', NULL, NULL, 'Arroz Blanco Capri', 1.90, 66.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 6, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(25, 'HAR-22032', NULL, NULL, 'Harina de Maíz Precocida Capri', 1.60, 56.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 6, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(28, 'ARR-18742', NULL, NULL, 'Arroz Blanco Dobón', 2.10, 73.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 8, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(29, 'HAR-92708', NULL, NULL, 'Harina de Maíz Precocida Dobón', 1.80, 63.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 8, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(31, 'HAR-41141', NULL, NULL, 'Salsa de tomate Pampero', 1.90, 66.50, 'Salsa de tomate Pampero 198 ML\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 9, '2025-11-21 05:13:56', '2025-11-28 02:50:19'),
	(32, 'ARR-93657', NULL, NULL, 'Arroz Blanco Iberia', 2.30, 80.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 10, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(33, 'HAR-81554', NULL, NULL, 'Harina de Maíz Precocida Iberia', 2.00, 70.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 10, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(34, 'ARR-94946', NULL, NULL, 'Arroz Blanco Boka', 2.40, 84.00, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 11, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(35, 'HAR-41120', NULL, NULL, 'Harina de Maíz Precocida Boka', 2.10, 73.50, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 11, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(36, 'ARR-84749', NULL, NULL, 'Arroz Blanco Coamo', 2.50, 87.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 12, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(37, 'HAR-94472', NULL, NULL, 'Harina de Maíz Precocida Coamo', 2.20, 77.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 12, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(38, 'ARR-64433', NULL, NULL, 'Arroz Blanco Pringles', 2.60, 91.00, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 13, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(39, 'HAR-69736', NULL, NULL, 'Harina de Maíz Precocida Pringles', 2.30, 80.50, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 13, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(40, 'ARR-98862', NULL, NULL, 'Arroz Blanco Tom', 2.70, 94.50, 'Arroz blanco de alta calidad', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 14, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(41, 'HAR-27341', NULL, NULL, 'Harina de Maíz Precocida Tom', 2.40, 84.00, 'Harina de maíz precocida para arepas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 1, 14, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(42, 'CHI-94826', NULL, NULL, 'Chimo el apureño', 1.43, 50.05, 'Chimo con extracto de tabaco y sabores naturales.', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 1000, 10, 1, 1, 1, 2, 17, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(43, 'CHI-53032', NULL, NULL, 'Chimo El Tigrito Amarillo', 0.51, 17.85, 'Chimo El Tigrito Amarillo', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 200, 10, 1, 1, 1, 2, 17, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(44, 'CIG-75268', NULL, NULL, 'Cigarrillos Nova Lucky Strike', 3.65, 127.75, 'Cigarrillos Nova Lucky Strike', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 15, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(45, 'CIG-10525', NULL, NULL, 'Cigarrillos Lucky Strike Red', 3.39, 118.65, 'Cigarrillos Lucky Strike Red', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 15, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(46, 'CIG-88703', NULL, NULL, 'Cigarros Eclipse Lucky Strike', 3.73, 130.55, 'Cigarros Eclipse Lucky Strike', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 15, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(47, 'CIG-97498', NULL, NULL, 'Cigarros 10und Belmont', 1.54, 53.90, 'Cigarros Belmont 10 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 16, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(48, 'CIG-53136', NULL, NULL, 'Cigarros 20und Belmont', 3.07, 107.45, 'Cigarros Belmont 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 16, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(49, 'CIG-51542', NULL, NULL, 'Cigarrillos Grandes Pall Mall', 3.05, 106.75, 'Cigarrillos Grandes Pall Mall', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 18, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(50, 'CIG-84279', NULL, NULL, 'Cigarros Viceroy', 2.12, 74.20, 'Cigarros Viceroy', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 19, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(51, 'CIG-63125', NULL, NULL, 'Cigarros 20und Universal', 2.09, 73.15, 'Cigarros Universal 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 22, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(52, 'CIG-91272', NULL, NULL, 'Cigarrillos Cosmic 20und', 3.73, 130.55, 'Cigarrillos Cosmic 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 2, 22, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(53, 'MAR-99584', NULL, NULL, 'Marlboro Red 20und', 4.25, 148.75, 'Cigarrillos Marlboro Red 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 2, 26, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(54, 'MAR-20471', NULL, NULL, 'Marlboro Gold 20und', 4.25, 148.75, 'Cigarrillos Marlboro Gold 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 2, 26, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(55, 'MAR-60670', NULL, NULL, 'Marlboro Menthol 20und', 4.25, 148.75, 'Cigarrillos Marlboro Menthol 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 2, 26, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(56, 'CAM-61713', NULL, NULL, 'Camel Blue 20und', 3.95, 138.25, 'Cigarrillos Camel Blue 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 2, 27, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(57, 'CAM-42385', NULL, NULL, 'Camel Yellow 20und', 3.95, 138.25, 'Cigarrillos Camel Yellow 20 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 2, 27, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(58, 'PRI-62606', NULL, NULL, 'Pringles Original', 2.50, 87.50, 'Papas fritas sabor original en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(59, 'PRI-81070', NULL, NULL, 'Pringles Crema y Cebolla', 2.50, 87.50, 'Papas fritas sabor crema y cebolla en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(60, 'PRI-79083', NULL, NULL, 'Pringles Queso Cheddar', 2.50, 87.50, 'Papas fritas sabor queso cheddar en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(61, 'PRI-61948', NULL, NULL, 'Pringles Barbacoa BBQ', 2.50, 87.50, 'Papas fritas sabor barbacoa BBQ en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(62, 'PRI-54900', NULL, NULL, 'Pringles Ranch', 2.50, 87.50, 'Papas fritas sabor ranch en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(63, 'PRI-81096', NULL, NULL, 'Pringles Pizza', 2.50, 87.50, 'Papas fritas sabor pizza en presentación de 110g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(64, 'PRI-22822', NULL, NULL, 'Pringles Enchilada', 2.70, 94.50, 'Papas fritas sabor enchilada en presentación de 124g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(65, 'PRI-25450', NULL, NULL, 'Pringles Habanero', 2.70, 94.50, 'Papas fritas sabor habanero en presentación de 124g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 3, 13, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(66, 'TOS-57056', NULL, NULL, 'Tostones con Ajo Tom', 1.43, 50.05, 'Deliciosos tostones con sabor a ajo', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 300, 10, 1, 1, 1, 3, 14, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(67, 'TOS-92373', NULL, NULL, 'Tostones Natural Tom', 1.43, 50.05, 'Tostones naturales sin condimentos', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 300, 10, 1, 1, 1, 3, 14, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(68, 'PIN-47805', NULL, NULL, 'Pin Pop Bomba Gigante 24x1', 12.50, 437.50, 'Caramelos bomba gigante caja de 24 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 30, 10, 1, 1, 1, 3, 80, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(69, 'PIN-25911', NULL, NULL, 'Pin Pop Bomba Gigante 48x1', 24.00, 840.00, 'Caramelos bomba gigante caja de 48 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 15, 10, 1, 1, 1, 3, 80, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(70, 'PIN-32822', NULL, NULL, 'Pin Pop Bomba Surtidos', 8.50, 297.50, 'Caramelos bomba sabores surtidos', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 3, 80, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(71, 'PIN-25106', NULL, NULL, 'Pin Pop Gigante Mora Fresa 24x1', 13.25, 463.75, 'Caramelos gigantes sabor mora fresa caja de 24', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 25, 10, 1, 1, 1, 3, 80, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(72, 'TAM-93842', NULL, NULL, 'Tam Cikolatam 83g', 2.85, 99.75, 'Chocolate Tam Cikolatam 83g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 3, 88, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(73, 'CLO-91036', NULL, NULL, 'Cloro Limpieza Extrema 1L', 2.15, 75.25, 'Cloro de limpieza extrema', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 4, 45, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(74, 'ALI-15607', NULL, NULL, 'Alive Azul', 2.50, 87.50, 'Detergente para todo tipo de ropa', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(75, 'ALI-65206', NULL, NULL, 'Alive Morado', 2.50, 87.50, 'Detergente Floral', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(76, 'ALI-49429', NULL, NULL, 'Alive Verde', 2.50, 87.50, 'Detergente Limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(79, 'ALI-77756', NULL, NULL, 'Alive Blanqueador', 2.60, 91.00, 'Detergente con Blanqueador', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-27 23:37:24'),
	(80, 'ALI-48412', NULL, NULL, 'Alive Rosado', 2.55, 89.25, 'Detergente rosado suavizante', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(81, 'ALI-48079', NULL, NULL, 'Alive Toallas Femeninas', 3.25, 113.75, 'Toallas sanitarias femeninas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(82, 'TOA-77598', NULL, NULL, 'Toallas Alive Nocturnas', 3.45, 120.75, 'Toallas sanitarias nocturnas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(83, 'TOA-47716', NULL, NULL, 'Toallas Alive Diaria', 2.95, 103.25, 'Toallas sanitarias de uso diario', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 4, 23, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(84, 'OSO-17907', NULL, NULL, 'Oso Blanco Cloro Gel', 1.75, 61.25, 'Cloro Gel Desinfectante para Baño y Cocina', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(85, 'PAP-45892', NULL, NULL, 'Papel Higienico Luciano', 1.75, 61.25, 'Papel Higienico Luciano', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(86, 'OSO-23721', NULL, NULL, 'Oso Blanco Lavavajillas', 1.50, 52.50, 'Detergente para lavavajillas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 180, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(90, 'OSO-50189', NULL, NULL, 'Oso Blanco Desinfectante Lavanda', 2.25, 78.75, 'Desinfectante clorado con fragancia a lavanda', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(91, 'OSO-18892', NULL, NULL, 'Oso Blanco Desinfectante Manzana', 2.25, 78.75, 'Desinfectante clorado con fragancia a manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(92, 'OSO-56125', NULL, NULL, 'Oso Blanco Desinfectante Cherry', 2.25, 78.75, 'Desinfectante clorado con fragancia a cereza', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(93, 'OSO-98956', NULL, NULL, 'Oso Blanco Desinfectante Fresca Sensación', 2.25, 78.75, 'Desinfectante clorado con fragancia fresca', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(94, 'DES-18427', NULL, NULL, 'Desinfectante Oso Blanco Intensa Floral', 2.35, 82.25, 'Desinfectante con fragancia intensa floral', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 95, 10, 1, 1, 1, 4, 24, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(96, 'LIM-92667', NULL, NULL, 'Limpiapisos en Polvo Aromax', 1.85, 64.75, 'Limpiador de pisos en polvo', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 4, 72, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(97, 'SUA-50865', NULL, NULL, 'Suavitel Cuidado Superior Frescura de Manzana', 3.15, 110.25, 'Suavizante con fragancia a manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 4, 86, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(98, 'SUA-17999', NULL, NULL, 'Suavitel Cuidado Superior Frescura de Primavera', 3.15, 110.25, 'Suavizante con fragancia primaveral', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 4, 86, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(99, 'SUA-97752', NULL, NULL, 'Suavitel Cuidado Superior Fresa y Chocolate', 3.25, 113.75, 'Suavizante con fragancia a fresa y chocolate', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 4, 86, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(100, 'SER-66357', NULL, NULL, 'Servilletas Blue Softy', 1.45, 50.75, 'Servilletas de papel suaves', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 120, 10, 1, 1, 1, 4, 84, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(101, 'NUT-14578', NULL, NULL, 'Nutribela Biokeratina', 18.40, 644.00, 'Tratamiento capilar Biokeratina 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(102, 'NUT-47040', NULL, NULL, 'Nutribela Enzimoterapia', 18.40, 644.00, 'Tratamiento capilar Enzimoterapia 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-28 03:00:28'),
	(103, 'NUT-26680', NULL, NULL, 'Nutribela Células Madres', 18.40, 644.00, 'Tratamiento capilar Células Madres 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(104, 'NUT-77170', NULL, NULL, 'Nutribela Pro Hialurónico', 18.40, 644.00, 'Tratamiento capilar Pro Hialurónico 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(107, 'NUT-39766', NULL, NULL, 'Nutribela Nutrición Avanzada', 18.40, 644.00, 'Tratamiento capilar Nutrición Avanzada 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(108, 'NUT-65050', NULL, NULL, 'Nutribela Repolarización en Frío', 18.40, 644.00, 'Tratamiento capilar Repolarización en Frío 300ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 150, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(109, 'NUT-96273', NULL, NULL, 'Nutribella15 Acondicionador 12x15ml Con células madres', 16.50, 577.50, 'Acondicionador con células madres 12 sobres de 15ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(110, 'NUT-25175', NULL, NULL, 'Nutribella15 Shampoo 12x15ml Reparación Intensiva', 15.50, 542.50, 'Shampoo reparación intensiva 12 sobres de 15ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(111, 'NUT-42570', NULL, NULL, 'Nutribella15 Tratamiento Capilar 12x1', 18.75, 656.25, 'Tratamiento capilar 12 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(112, 'NUT-49899', NULL, NULL, 'Nutribella15 Acondicionador 12x15ml Enzimoterapia', 16.50, 577.50, 'Acondicionador enzimoterapia 12 sobres de 15ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(113, 'NUT-50163', NULL, NULL, 'Nutribella15 Acondicionador 12x15ml Pro hialurónico', 16.50, 577.50, 'Acondicionador pro hialurónico 12 sobres de 15ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(114, 'NUT-59860', NULL, NULL, 'Nutribella15 Acondicionador 12x15ml Reparación Intensiva', 16.50, 577.50, 'Acondicionador reparación intensiva 12 sobres de 15ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(115, 'NUT-52390', NULL, NULL, 'Nutribella15 Acondicionador 12x18ml Pro hialurónico', 17.50, 612.50, 'Acondicionador pro hialurónico 12 sobres de 18ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(118, 'NUT-55745', NULL, NULL, 'Nutribella15 Shampoo 12x18ml Enzimoterapia', 16.50, 577.50, 'Shampoo enzimoterapia 12 sobres de 18ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(121, 'NUT-41832', NULL, NULL, 'Nutribella15 Tratamiento Capilar 12x24ml Enzimoterapia', 19.50, 682.50, 'Tratamiento capilar enzimoterapia 12 sobres de 24ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 55, 10, 1, 1, 1, 5, 25, '2025-11-21 05:13:57', '2025-11-21 07:57:38'),
	(122, 'ALI-69648', NULL, NULL, 'Alident Gel Triple Acción', 2.85, 99.75, 'Pasta dental gel triple acción', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 5, 53, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(123, 'ALI-12778', NULL, NULL, 'Alident Gel Azul', 2.75, 96.25, 'Pasta dental gel verde azul', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 5, 53, '2025-11-21 05:13:57', '2025-11-28 01:11:40'),
	(124, 'ALI-12940', NULL, NULL, 'Alident Gel Verde Fresco', 2.75, 96.25, 'Pasta dental gel verde fresco', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 5, 53, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(125, 'COL-49908', NULL, NULL, 'Colgate 12 x 90g', 28.50, 997.50, 'Pasta dental Colgate caja de 12 tubos de 90g', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 20, 10, 1, 1, 1, 5, 58, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(126, 'LAD-29465', NULL, NULL, 'Lady Speed Stick 18g', 3.45, 120.75, 'Desodorante femenino en barra', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 5, 71, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(127, 'SPE-49574', NULL, NULL, 'Speed Stick 18g', 3.25, 113.75, 'Desodorante masculino en barra', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 5, 85, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(128, 'JAB-28724', NULL, NULL, 'Jabón Anita Rosado', 1.15, 40.25, 'Jabón de tocador rosado', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 5, 67, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(129, 'JAB-10351', NULL, NULL, 'Jabón Frita Azul', 1.25, 43.75, 'Jabón de tocador azul', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 95, 10, 1, 1, 1, 5, 68, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(130, 'COC-72317', NULL, NULL, 'Coca Cola Original 350ml', 1.25, 43.75, 'Bebida gaseosa sabor cola', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 6, 34, '2025-11-21 05:13:57', '2025-11-21 05:50:55'),
	(131, 'COC-34272', NULL, NULL, 'Coca Cola Original 355ml', 1.30, 45.50, 'Bebida gaseosa sabor cola lata', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 120, 10, 1, 1, 1, 6, 34, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(135, 'PEP-66089', NULL, NULL, 'Pepsi Original 350ml', 1.20, 42.00, 'Bebida gaseosa sabor cola', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 35, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(136, 'PEP-35958', NULL, NULL, 'Pepsi Original 500ml', 1.70, 59.50, 'Bebida gaseosa sabor cola', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 35, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(137, 'REF-58765', NULL, NULL, 'Refresco Pepsi Cola', 1.30, 45.50, 'Refresco Pepsi Cola', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 35, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(138, 'SPR-32876', NULL, NULL, 'Sprite Original 350ml', 1.25, 43.75, 'Bebida gaseosa sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 36, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(139, 'SPR-90957', NULL, NULL, 'Sprite Original 500ml', 1.75, 61.25, 'Bebida gaseosa sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 36, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(140, 'FAN-91903', NULL, NULL, 'Fanta Naranja 350ml', 1.25, 43.75, 'Bebida gaseosa sabor naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 37, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(141, 'FAN-13196', NULL, NULL, 'Fanta Uva 350ml', 1.25, 43.75, 'Bebida gaseosa sabor uva', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 6, 37, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(142, 'MAL-28648', NULL, NULL, 'Malta Retornable 36x222ml Maltil Polar', 28.50, 997.50, 'Malta en envase retornable caja de 36 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 20, 10, 0, 1, 1, 6, 1, '2025-11-21 05:13:57', '2025-11-21 07:12:38'),
	(143, 'MAL-17060', NULL, NULL, 'Malta Desechable 12x250ml Maltin Polar', 12.75, 446.25, 'Malta en envase desechable caja de 12 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 30, 10, 0, 1, 1, 6, 1, '2025-11-21 05:13:57', '2025-11-21 07:12:39'),
	(144, 'MAL-35399', NULL, NULL, 'Malta de Lata 24x330ml Maltin Polar', 22.80, 798.00, 'Malta en lata caja de 24 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 25, 10, 0, 1, 1, 6, 1, '2025-11-21 05:13:57', '2025-11-21 07:12:41'),
	(145, 'MAL-38613', NULL, NULL, 'Malta 355 ml Maltin Polar', 2.85, 99.75, 'Malta en botella de 1.5 litros', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 1, '2025-11-21 05:13:57', '2025-11-21 07:13:32'),
	(146, 'MAL-32511', NULL, NULL, 'Maltin 355ml', 1.15, 40.25, 'Malta en lata de 355ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 0, 1, 1, 6, 1, '2025-11-21 05:13:57', '2025-11-21 07:12:44'),
	(147, 'LEC-91426', NULL, NULL, 'Leche Líquida Carabobo Entera', 1.95, 68.25, 'Leche líquida entera pasteurizada', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 47, '2025-11-21 05:13:57', '2025-11-21 06:57:14'),
	(148, 'LEC-41496', NULL, NULL, 'Leche Líquida Carabobo Descremada', 1.90, 66.50, 'Leche líquida descremada pasteurizada', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 0, 1, 1, 6, 47, '2025-11-21 05:13:57', '2025-11-21 06:57:16'),
	(149, 'LEC-79243', NULL, NULL, 'Leche Líquida Carabobo Semi-descremada', 1.92, 67.20, 'Leche líquida semi-descremada pasteurizada', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 0, 1, 1, 6, 47, '2025-11-21 05:13:57', '2025-11-21 06:55:28'),
	(150, 'REF-36194', NULL, NULL, 'Refresco Frut Cola 2L', 1.65, 57.75, 'Refresco sabor cola en botella de 2 litros', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 48, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(151, 'AGU-86352', NULL, NULL, 'Agua Natural Minalba', 0.85, 29.75, 'Agua mineral natural en botella', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 120, 10, 1, 1, 1, 6, 49, '2025-11-21 05:13:57', '2025-11-28 03:11:14'),
	(152, 'AGU-29154', NULL, NULL, 'Agua Mineral Cool 1L', 1.25, 43.75, 'Agua mineral natural en botella de 1 litro', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 50, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(154, 'AGU-24516', NULL, NULL, 'Agua Vista 1.5L', 1.45, 50.75, 'Agua purificada en botella de 1.5 litros', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 6, 51, '2025-11-21 05:13:57', '2025-11-21 05:41:20'),
	(161, 'FRU-88885', NULL, NULL, 'Frubys Manzana 12x1.5L', 18.50, 647.50, 'Jugo de manzana caja de 12 botellas de 1.5L', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 15, 10, 1, 1, 1, 6, 62, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(162, 'FRU-34704', NULL, NULL, 'Frubys Pera 12x1.5L', 18.50, 647.50, 'Jugo de pera caja de 12 botellas de 1.5L', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 15, 10, 1, 1, 1, 6, 62, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(163, 'FRU-33300', NULL, NULL, 'Frutea Limón 1.5L', 2.25, 78.75, 'Té helado sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 63, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(164, 'FRU-92534', NULL, NULL, 'Frutea Durazno 1.5L', 2.25, 78.75, 'Té helado sabor durazno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 63, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(165, 'FRU-34892', NULL, NULL, 'Fruttsy Passion 250ml', 1.15, 40.25, 'Bebida de fruta de la pasión', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 64, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(166, 'FRU-15605', NULL, NULL, 'Fruttsy Frutos Rojos 250ml', 1.15, 40.25, 'Bebida de frutos rojos', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 6, 64, '2025-11-21 05:13:57', '2025-11-21 06:22:04'),
	(167, 'FRU-69733', NULL, NULL, 'Fruttsy Naranja 250ml', 1.15, 40.25, 'Bebida de naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 64, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(168, 'JUG-25611', NULL, NULL, 'Jugo Fruttsy Frutos Rojos 24x250ml', 24.00, 840.00, 'Jugo frutos rojos caja de 24 unidades de 250ml', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 15, 10, 0, 1, 1, 6, 64, '2025-11-21 05:13:57', '2025-11-21 06:30:05'),
	(169, 'FRU-90794', NULL, NULL, 'Frutys Durazno 1.5L', 2.15, 75.25, 'Néctar de durazno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 65, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(170, 'FRU-51996', NULL, NULL, 'Frutys Naranja 1.5L', 2.15, 75.25, 'Néctar de naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 65, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(171, 'FRU-70191', NULL, NULL, 'Frutys Mandarina 1.5L', 2.15, 75.25, 'Néctar de mandarina', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 65, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(172, 'JUG-69863', NULL, NULL, 'Jugos El Valle Naranja 1.5L', 2.85, 99.75, 'Jugo de naranja natural', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 45, 10, 1, 1, 1, 6, 70, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(173, 'LIP-63223', NULL, NULL, 'Lipton Ice Tea Durazno 500ml', 1.85, 64.75, 'Té helado sabor durazno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 6, 73, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(174, 'LIP-90376', NULL, NULL, 'Lipton Ice Tea Limón 500ml', 1.85, 64.75, 'Té helado sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 6, 73, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(175, 'JUC-59421', NULL, NULL, 'Jucosa Refrescante Pera', 1.95, 68.25, 'Bebida refrescante sabor pera', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 69, '2025-11-21 05:13:57', '2025-11-21 06:53:40'),
	(176, 'JUC-91999', NULL, NULL, 'Jucosa Refrescante Manzana', 1.95, 68.25, 'Bebida refrescante sabor manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 69, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(177, 'NAT-54114', NULL, NULL, 'Natulac Pera', 1.75, 61.25, 'Bebida láctea sabor pera', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 6, 76, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(178, 'JUG-37861', NULL, NULL, 'Jugo Natulac Manzana', 1.85, 64.75, 'Jugo de manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 76, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(179, 'JUG-16849', NULL, NULL, 'Jugo Natulac Durazno', 1.85, 64.75, 'Jugo de durazno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 6, 76, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(180, 'JUG-51918', NULL, NULL, 'Jugo Valencia Coctel', 2.25, 78.75, 'Jugo coctel de frutas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 94, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(181, 'JUG-46481', NULL, NULL, 'Jugo Valencia Naranjada', 2.15, 75.25, 'Jugo de naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 55, 10, 1, 1, 1, 6, 94, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(182, 'JUG-58856', NULL, NULL, 'Jugo Valencia Durazno', 2.20, 77.00, 'Jugo de durazno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 94, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(183, 'JUG-25697', NULL, NULL, 'Jugo Valencia Pera', 2.20, 77.00, 'Jugo de pera', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 94, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(184, 'JUG-91393', NULL, NULL, 'Jugo Justy Naranja', 1.95, 68.25, 'Jugo de naranja natural', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 6, 95, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(185, 'JUG-78217', NULL, NULL, 'Jugo Speed', 2.45, 85.75, 'Bebida energética de frutas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 6, 96, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(186, 'JUG-97813', NULL, NULL, 'Jugo Speed Lata', 1.85, 64.75, 'Bebida energética de frutas en lata', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 6, 96, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(187, 'POW-14699', NULL, NULL, 'Power Max 400ml', 2.45, 85.75, 'Bebida energética', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 6, 81, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(188, 'ALD-96899', NULL, NULL, 'Aldor Tamarindo 100x1', 45.00, 1575.00, 'Bebida de tamarindo caja de 100 unidades', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 10, 10, 1, 1, 1, 6, 52, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(189, 'JUG-72087', NULL, NULL, 'Jugo Fruton Fruit Punch 6x1.5L', 12.50, 437.50, 'Jugo fruit punch caja de 6 botellas de 1.5L', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 25, 10, 1, 1, 1, 6, 91, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(190, 'JUG-59168', NULL, NULL, 'Jugo Fruton Citrus Punch 6x1.5L', 12.50, 437.50, 'Jugo citrus punch caja de 6 botellas de 1.5L', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 25, 10, 1, 1, 1, 6, 91, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(191, 'GLU-48302', NULL, NULL, 'Glup Naranja', 0.95, 33.25, 'Refresco sabor naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 310, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(192, 'GLU-33705', NULL, NULL, 'Glup Limón', 0.95, 33.25, 'Refresco sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 310, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(193, 'GLU-12974', NULL, NULL, 'Glup Uva', 0.95, 33.25, 'Refresco sabor uva', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 290, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(194, 'GLU-83887', NULL, NULL, 'Glup Manzana', 0.95, 33.25, 'Refresco sabor manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 290, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(195, 'GLU-89143', NULL, NULL, 'Glup Tropical', 1.00, 35.00, 'Refresco sabor tropical', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 270, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(196, 'GLU-39473', NULL, NULL, 'Glup Fresa', 1.00, 35.00, 'Refresco sabor fresa', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 270, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(197, 'GLU-99572', NULL, NULL, 'Glup Cola Negra', 1.05, 36.75, 'Refresco sabor cola negra', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 250, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(198, 'GLU-61456', NULL, NULL, 'Glup Colita', 1.05, 36.75, 'Refresco sabor colita', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 250, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(199, 'GLU-99931', NULL, NULL, 'Glup Fresh', 1.05, 36.75, 'Refresco sabor fresh', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 250, 10, 1, 1, 1, 6, 92, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(200, 'GAT-95827', NULL, NULL, 'Gatorade Azul', 2.85, 99.75, 'Bebida deportiva sabor azul', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 97, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(201, 'GAT-15871', NULL, NULL, 'Gatorade Mandarina', 2.85, 99.75, 'Bebida deportiva sabor mandarina', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 97, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(202, 'GAT-78935', NULL, NULL, 'Gatorade Tropical', 2.85, 99.75, 'Bebida deportiva sabor tropical', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 6, 97, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(203, 'AGU-80772', NULL, NULL, 'Agua Mineral Mi Brisa', 0.75, 26.25, 'Agua mineral natural', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 650, 10, 1, 1, 1, 6, 98, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(204, 'AGU-70819', NULL, NULL, 'Agua Mineral Heal', 0.80, 28.00, 'Agua mineral purificada', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 650, 10, 1, 1, 1, 6, 99, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(205, 'REF-55208', NULL, NULL, 'Refresco Golden Colita', 1.15, 40.25, 'Refresco sabor colita', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 100, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(206, 'REF-45290', NULL, NULL, 'Refresco Golden Piña', 1.15, 40.25, 'Refresco sabor piña', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 100, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(207, 'REF-31242', NULL, NULL, 'Refresco Golden Manzana', 1.15, 40.25, 'Refresco sabor manzana', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 100, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(208, 'REF-76921', NULL, NULL, 'Refresco Golden 7UP', 1.25, 43.75, 'Refresco sabor lima limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 100, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(209, 'REF-35442', NULL, NULL, 'Refresco Frescolita', 1.35, 47.25, 'Refresco sabor fresa', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 360, 10, 1, 1, 1, 6, 101, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(210, 'REF-61449', NULL, NULL, 'Refresco Chinotto', 1.45, 50.75, 'Refresco sabor chinotto', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 320, 10, 1, 1, 1, 6, 102, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(211, 'REF-99399', NULL, NULL, 'Refresco Hit Naranja', 1.25, 43.75, 'Refresco sabor naranja', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 103, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(212, 'REF-79830', NULL, NULL, 'Refresco Hit Uva', 1.25, 43.75, 'Refresco sabor uva', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 410, 10, 1, 1, 1, 6, 103, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(215, 'DOR-29446', NULL, NULL, 'Doritos Mega Queso', 2.45, 85.75, 'Tortilla chips mega queso', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 7, 28, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(216, 'CHE-78983', NULL, NULL, 'Cheese Tris 50g', 1.25, 43.75, 'Snack de queso triangular', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 7, 56, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(217, 'PUF-70934', NULL, NULL, 'Puffy Sabor a Pimienta con Limón', 1.15, 40.25, 'Snack inflado sabor pimienta limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 7, 89, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(218, 'PUF-62852', NULL, NULL, 'Puffy Sabor a Queso', 1.15, 40.25, 'Snack inflado sabor queso', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 7, 89, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(219, 'PUF-10480', NULL, NULL, 'Puffy Sabor a Tomate con Albahaca', 1.15, 40.25, 'Snack inflado sabor tomate albahaca', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 7, 89, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(220, 'SAL-75366', NULL, NULL, 'Saltitacos', 1.35, 47.25, 'Snack salado tipo taco', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 7, 90, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(221, 'LAY-32461', NULL, NULL, 'Lays Clásicas', 1.85, 64.75, 'Papas fritas clásicas con sal', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 7, 29, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(222, 'LAY-36539', NULL, NULL, 'Lays Limón', 1.85, 64.75, 'Papas fritas sabor limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 7, 29, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(223, 'RUF-10903', NULL, NULL, 'Ruffles Original', 2.10, 73.50, 'Papas fritas onduladas originales', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 7, 30, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(224, 'RUF-16260', NULL, NULL, 'Ruffles Queso y Cebolla', 2.10, 73.50, 'Papas fritas onduladas sabor queso y cebolla', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 7, 30, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(225, 'CHE-61807', NULL, NULL, 'Cheetos Crunchy', 1.95, 68.25, 'Snacks de maíz sabor queso cheddar', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 7, 31, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(226, 'CHE-36232', NULL, NULL, 'Cheetos Flamin Hot', 1.95, 68.25, 'Snacks de maíz sabor picante', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 7, 31, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(227, 'ORE-60978', NULL, NULL, 'Oreo Original', 2.50, 87.50, 'Galletas de chocolate con crema', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 7, 32, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(228, 'ORE-20067', NULL, NULL, 'Oreo Golden', 2.50, 87.50, 'Galletas doradas con crema de vainilla', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 7, 32, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(229, 'RIT-82634', NULL, NULL, 'Ritz Crackers Original', 2.25, 78.75, 'Galletas saladas redondas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 7, 33, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(230, 'RIT-86777', NULL, NULL, 'Ritz Crackers Queso', 2.35, 82.25, 'Galletas saladas con sabor a queso', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 70, 10, 1, 1, 1, 7, 33, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(231, 'COR-14062', NULL, NULL, 'Corn Flakes Kelloggs', 4.50, 157.50, 'Cereal de maíz tostado', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 8, 43, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(232, 'FRO-77336', NULL, NULL, 'Froot Loops Kelloggs', 5.25, 183.75, 'Cereal de colores con sabor a frutas', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 55, 10, 1, 1, 1, 8, 43, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(233, 'SPE-33333', NULL, NULL, 'Special K Kelloggs', 5.75, 201.25, 'Cereal de arroz y trigo', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 50, 10, 1, 1, 1, 8, 43, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(234, 'AVE-24185', NULL, NULL, 'Avena Quaker Original', 3.25, 113.75, 'Avena instantánea natural', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 8, 44, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(235, 'AVE-71919', NULL, NULL, 'Avena Quaker Canela', 3.50, 122.50, 'Avena instantánea sabor canela', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 8, 44, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(236, 'NES-63324', NULL, NULL, 'Nesquik Chocolate', 4.75, 166.25, 'Polvo para bebida sabor chocolate', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 8, 38, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(237, 'NES-65792', NULL, NULL, 'Nesquik Fresa', 4.75, 166.25, 'Polvo para bebida sabor fresa', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 60, 10, 1, 1, 1, 8, 38, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(238, 'JAB-52968', NULL, NULL, 'Jabón de Baño Rexona Antibacterial', 1.25, 43.75, 'Jabón antibacterial protección 12h', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(239, 'JAB-56117', NULL, NULL, 'Jabón de Baño Rexona Aloe Vera', 1.25, 43.75, 'Jabón con extracto de aloe vera', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(240, 'JAB-16927', NULL, NULL, 'Jabón de Baño Rexona Glicerina', 1.25, 43.75, 'Jabón con glicerina hidratante', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(241, 'JAB-86724', NULL, NULL, 'Jabón de Baño Rexona Avena', 1.35, 47.25, 'Jabón exfoliante con avena', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(242, 'JAB-76412', NULL, NULL, 'Jabón de Baño Rexona Coco', 1.35, 47.25, 'Jabón hidratante con aceite de coco', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(243, 'JAB-33181', NULL, NULL, 'Jabón de Baño Rexona Surtidos 8x110g', 8.95, 313.25, 'Pack de 8 jabones surtidos de 110g cada uno', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 8, 46, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(244, 'PAN-35096', NULL, NULL, 'Pañales Baby Finger P', 8.50, 297.50, 'Pañales talla P', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 9, 78, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(245, 'PAN-72775', NULL, NULL, 'Pañales Baby Finger M', 8.50, 297.50, 'Pañales talla M', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 9, 78, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(246, 'PAN-37501', NULL, NULL, 'Pañales Baby Finger G', 8.50, 297.50, 'Pañales talla G', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 9, 78, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(247, 'PAN-18611', NULL, NULL, 'Pañales Baby Finger RN', 8.50, 297.50, 'Pañales talla recién nacido', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 9, 78, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(248, 'PAN-56938', NULL, NULL, 'Pañales Baby Finger XXG', 8.50, 297.50, 'Pañales talla XXG', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 40, 10, 1, 1, 1, 9, 78, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(249, 'PAN-90801', NULL, NULL, 'Pañales Hugme P', 9.50, 332.50, 'Pañales talla P', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(250, 'PAN-95074', NULL, NULL, 'Pañales Hugme M', 9.50, 332.50, 'Pañales talla M', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(251, 'PAN-34946', NULL, NULL, 'Pañales Hugme G', 9.50, 332.50, 'Pañales talla G', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(252, 'PAN-20299', NULL, NULL, 'Pañales Hugme XG', 9.50, 332.50, 'Pañales talla XG', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(253, 'PAN-63057', NULL, NULL, 'Pañales Hugme RN', 8.75, 306.25, 'Pañales recién nacido', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(254, 'TOA-22220', NULL, NULL, 'Toallitas Húmedas Hugme', 3.25, 113.75, 'Toallitas húmedas para bebé', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 100, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(255, 'SHA-91934', NULL, NULL, 'Shampoo Hugme Bebé', 4.50, 157.50, 'Shampoo suave para bebé', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 75, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(256, 'JAB-15282', NULL, NULL, 'Jabón Líquido Hugme', 4.25, 148.75, 'Jabón líquido para bebé', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 85, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(257, 'CRE-96653', NULL, NULL, 'Crema Hugme Bebé', 5.75, 201.25, 'Crema hidratante para bebé', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 65, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(258, 'ACE-18261', NULL, NULL, 'Aceite Hugme Bebé', 3.95, 138.25, 'Aceite corporal para bebé', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 90, 10, 1, 1, 1, 9, 79, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(259, 'PROD-000259', NULL, NULL, 'Aceite La Lucha de Soja 900ML', 0.00, 0.00, 'Aceite de Soja La Lucha', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 83, '2025-11-21 05:29:57', '2025-11-21 05:29:57'),
	(260, 'PROD-000260', NULL, NULL, 'Azucar Montalban 1 KG', 0.00, 0.00, 'Azucar Montalban 1 Kg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 54, '2025-11-21 05:46:00', '2025-11-21 05:46:00'),
	(261, 'PROD-000261', NULL, NULL, 'Cremor 395 MG', 0.00, 0.00, 'Cremor 395 MG\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 59, '2025-11-21 05:54:43', '2025-11-21 05:54:43'),
	(262, 'PROD-000262', NULL, NULL, 'Cubitos Maggi', 0.00, 0.00, 'Cubitos Maggi', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 39, '2025-11-21 05:55:51', '2025-11-21 05:55:51'),
	(263, 'PROD-000263', NULL, NULL, 'Diablito Under Wood 115G', 0.00, 0.00, 'Diablito Under Wood 115G', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 60, '2025-11-21 05:57:17', '2025-11-21 05:57:17'),
	(264, 'Q6BO52VG', NULL, NULL, 'Diablito Under Wood 54G', 0.00, 0.00, 'Diablito Under Wood 54G', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 60, '2025-11-21 05:58:09', '2025-11-21 05:59:24'),
	(265, 'PROD-000265', NULL, NULL, 'Don Kat Adulto', 0.00, 0.00, 'Don Kat Adulto', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 10, 61, '2025-11-21 06:15:56', '2025-11-21 06:15:56'),
	(266, 'PROD-000266', NULL, NULL, 'Huevo Santa Maria doble 12x1', 0.00, 0.00, 'Huevo Santa Maria doble 12x1\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 66, '2025-11-21 06:31:31', '2025-11-21 06:31:31'),
	(267, 'PROD-000267', NULL, NULL, 'Mantequilla Deline, 250 MG', 0.00, 0.00, 'Mantequilla Deline, 250 MG\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 74, '2025-11-21 07:18:24', '2025-11-21 07:18:24'),
	(268, 'MAY-1763695160', NULL, NULL, 'Mayonesa 445 MG', 1.80, 63.00, 'Mayonesa 445 MG', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 80, 10, 1, 1, 1, 1, 1, '2025-11-21 07:19:20', '2025-11-21 07:22:28'),
	(269, 'PROD-000269', NULL, NULL, 'Mirringo Adulto', 0.00, 0.00, 'Mirringo Adulto alimento para gatos\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 10, 75, '2025-11-21 07:26:38', '2025-11-21 07:26:38'),
	(270, 'PROD-000270', NULL, NULL, 'Nutribella15 Acondicionador Nutrición 12x1  Devuelve la Belleza Natural', 0.00, 0.00, 'Nutribella15 Acondicionador Nutrición 12x1  Devuelve la Belleza Natural\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 5, 25, '2025-11-21 07:39:23', '2025-11-21 07:39:23'),
	(271, 'PROD-000271', NULL, NULL, 'Nutribella15 Acondicionador Termoproteccion 12x1', 0.00, 0.00, 'Nutribella15 Acondicionador Termoproteccion 12x1\n', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 5, 25, '2025-11-21 07:41:39', '2025-11-21 07:41:39'),
	(272, 'PROD-1764290601', NULL, NULL, 'Aceite Ideal', 0.00, 0.00, 'Aceite comestible Ideal', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 82, '2025-11-28 00:43:21', '2025-11-28 00:46:40'),
	(273, 'PROD-000273', NULL, NULL, 'Panelada', 0.00, 0.00, 'Bebida en polvo a base de Panela con sabor a limón', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 6, 105, '2025-11-28 02:11:34', '2025-11-28 02:11:34'),
	(274, 'PROD-000274', NULL, NULL, 'Pasta Allegri ricatones', 0.00, 0.00, 'Pasta Allegri ricatones 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:30:34', '2025-11-28 02:30:34'),
	(275, 'PROD-1764297049', NULL, NULL, 'Pasta Allegri Tubo', 0.00, 0.00, 'Pasta Allegri Tubo Liso 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:30:49', '2025-11-28 02:32:14'),
	(276, 'PROD-1764297147', NULL, NULL, 'Pasta Allegri Vercimelli', 0.00, 0.00, 'Pasta Allegri Vercimelli 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:32:27', '2025-11-28 02:33:17'),
	(277, 'PROD-1764297221', NULL, NULL, 'Pasta Allegri Linguini', 0.00, 0.00, 'Pasta Allegri Linguini 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:33:41', '2025-11-28 02:34:53'),
	(278, 'PROD-1764297304', NULL, NULL, 'Pasta Allegri Codos', 0.00, 0.00, 'Pasta Allegri Codos 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:35:04', '2025-11-28 02:36:19'),
	(279, 'PROD-764297307', NULL, NULL, 'Pasta Allegri Espirales', 0.00, 0.00, 'Pasta Allegri Espirales 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:35:07', '2025-11-28 02:37:01'),
	(280, 'PROD-1764297320', NULL, NULL, 'Pasta Allegri Plumita', 0.00, 0.00, 'Pasta Allegri Plumita 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:35:20', '2025-11-28 02:38:33'),
	(281, 'PROD-1764297468', NULL, NULL, 'Pasta Allegri Tornillo ', 0.00, 0.00, 'Pasta Allegri Tornillo 12X500Mg', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 1, 7, '2025-11-28 02:37:48', '2025-11-28 02:39:17'),
	(282, 'PROD-000282', NULL, NULL, 'Super Pega', 0.00, 0.00, 'Super pega 12x8', NULL, NULL, NULL, 0, 1, 0, 0, 'deny', 5000, 10, 1, 1, 1, 11, 87, '2025-11-28 02:55:39', '2025-11-28 02:55:39');

-- Volcando estructura para tabla laravel.producto_inventory_settings
DROP TABLE IF EXISTS `producto_inventory_settings`;
CREATE TABLE IF NOT EXISTS `producto_inventory_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `track_inventory` tinyint(1) NOT NULL DEFAULT '1',
  `allow_backorder` tinyint(1) NOT NULL DEFAULT '0',
  `inventory_policy` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'deny',
  `low_stock_threshold` int NOT NULL DEFAULT '5',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_inventory_settings_producto_id_index` (`producto_id`),
  KEY `producto_inventory_settings_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_inventory_settings_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_inventory_settings_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.producto_inventory_settings: ~3 rows (aproximadamente)
DELETE FROM `producto_inventory_settings`;
INSERT INTO `producto_inventory_settings` (`id`, `producto_id`, `track_inventory`, `allow_backorder`, `inventory_policy`, `low_stock_threshold`, `empresa_id`, `created_at`, `updated_at`) VALUES
	(1, 273, 1, 0, 'deny', 5, 1, '2025-11-28 02:11:34', '2025-11-28 02:11:34'),
	(2, 274, 1, 0, 'deny', 5, 1, '2025-11-28 02:30:34', '2025-11-28 02:30:34'),
	(3, 282, 1, 0, 'deny', 5, 1, '2025-11-28 02:55:39', '2025-11-28 02:55:39');

-- Volcando estructura para tabla laravel.producto_seo
DROP TABLE IF EXISTS `producto_seo`;
CREATE TABLE IF NOT EXISTS `producto_seo` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `barcode` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `meta_description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tags` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_seo_producto_id_index` (`producto_id`),
  KEY `producto_seo_empresa_id_index` (`empresa_id`),
  KEY `producto_seo_sku_index` (`sku`),
  KEY `producto_seo_barcode_index` (`barcode`),
  CONSTRAINT `producto_seo_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_seo_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.producto_seo: ~73 rows (aproximadamente)
DELETE FROM `producto_seo`;
INSERT INTO `producto_seo` (`id`, `producto_id`, `sku`, `barcode`, `meta_title`, `meta_description`, `tags`, `featured`, `empresa_id`, `created_at`, `updated_at`) VALUES
	(1, 81, 'ALIVE-TOALLAS-FEMENINAS-THTI', '', '', '', '', 0, 1, '2025-11-27 23:35:45', '2025-11-27 23:35:45'),
	(2, 80, 'ALIVE-ROSADO-4XJS', '', '', '', '', 0, 1, '2025-11-27 23:36:17', '2025-11-27 23:36:17'),
	(3, 79, 'ALIVE-BLANCO-IX9P', '', '', '', '', 0, 1, '2025-11-27 23:36:39', '2025-11-27 23:36:39'),
	(4, 76, 'ALIVE-VERDE-PAC4', '', '', '', '', 0, 1, '2025-11-27 23:40:27', '2025-11-27 23:40:27'),
	(5, 75, 'ALIVE-MORADO-V3GU', '', '', '', '', 0, 1, '2025-11-27 23:40:47', '2025-11-27 23:40:47'),
	(6, 74, 'ALIVE-AZUL-EGNJ', '', '', '', '', 0, 1, '2025-11-27 23:42:29', '2025-11-27 23:42:29'),
	(7, 179, 'JUGO-NATULAC-DURAZNO-BBU1', '', '', '', '', 0, 1, '2025-11-27 23:49:32', '2025-11-27 23:49:32'),
	(8, 178, 'JUGO-NATULAC-MANZANA-FBIB', '', '', '', '', 0, 1, '2025-11-27 23:50:24', '2025-11-27 23:50:24'),
	(9, 177, 'NATULAC-PERA-JPIV', '', '', '', '', 0, 1, '2025-11-27 23:51:31', '2025-11-27 23:51:31'),
	(10, 203, 'AGUA-MINERAL-MI-BRISA-V216', '', '', '', '', 0, 1, '2025-11-28 00:31:41', '2025-11-28 00:31:41'),
	(11, 204, 'AGUA-MINERAL-HEAL-BLB0', '', '', '', '', 0, 1, '2025-11-28 00:33:32', '2025-11-28 00:33:32'),
	(12, 4, '', '', '', '', '', 0, 1, '2025-11-28 00:43:10', '2025-11-28 00:43:10'),
	(13, 272, 'ACEITE-IDEAL-MVXK', '', '', '', '', 0, 1, '2025-11-28 00:46:40', '2025-11-28 00:46:40'),
	(14, 188, 'ALDOR-TAMARINDO-100X1-5X4X', '', '', '', '', 0, 1, '2025-11-28 01:09:57', '2025-11-28 01:09:57'),
	(15, 124, 'ALIDENT-GEL-VERDE-FRESCO-5SVD', '', '', '', '', 0, 1, '2025-11-28 01:10:55', '2025-11-28 01:10:55'),
	(16, 123, 'ALIDENT-GEL-AZUL-HTLT', '', '', '', '', 0, 1, '2025-11-28 01:11:40', '2025-11-28 01:11:40'),
	(17, 122, 'ALIDENT-GEL-TRIPLE-ACCION-K6JI', '', '', '', '', 0, 1, '2025-11-28 01:12:06', '2025-11-28 01:12:06'),
	(18, 99, 'SUAVITEL-CUIDADO-SUPERIOR-FRESA-Y-CHOCOLATE-QQGY', '', '', '', '', 0, 1, '2025-11-28 01:13:51', '2025-11-28 01:13:51'),
	(19, 98, 'SUAVITEL-CUIDADO-SUPERIOR-FRESCURA-DE-PRIMAVERA-7F2N', '', '', '', '', 0, 1, '2025-11-28 01:14:18', '2025-11-28 01:14:18'),
	(20, 97, 'SUAVITEL-CUIDADO-SUPERIOR-FRESCURA-DE-MANZANA-Z6D6', '', '', '', '', 0, 1, '2025-11-28 01:14:40', '2025-11-28 01:14:40'),
	(21, 84, 'OSO-BLANCO-CLORO-GEL-W6L5', '', '', '', '', 0, 1, '2025-11-28 01:17:19', '2025-11-28 01:17:19'),
	(23, 86, 'OSO-BLANCO-LAVAVAJILLAS-RVHS', '', '', '', '', 0, 1, '2025-11-28 01:20:38', '2025-11-28 01:20:38'),
	(24, 90, 'OSO-BLANCO-DESINFECTANTE-LAVANDA-RRWM', '', '', '', '', 0, 1, '2025-11-28 01:26:30', '2025-11-28 01:26:30'),
	(25, 91, 'OSO-BLANCO-DESINFECTANTE-MANZANA-B9Y8', '', '', '', '', 0, 1, '2025-11-28 01:27:00', '2025-11-28 01:27:00'),
	(26, 93, 'OSO-BLANCO-DESINFECTANTE-FRESCA-SENSACION-EVPI', '', '', '', '', 0, 1, '2025-11-28 01:30:57', '2025-11-28 01:30:57'),
	(27, 94, 'DESINFECTANTE-OSO-BLANCO-INTENSA-FLORAL-WIFI', '', '', '', '', 0, 1, '2025-11-28 01:31:28', '2025-11-28 01:31:28'),
	(28, 215, 'DORITOS-MEGA-QUESO-2FYD', '', '', '', '', 0, 1, '2025-11-28 01:35:17', '2025-11-28 01:35:17'),
	(29, 216, 'CHEESE-TRIS-50G-JDXF', '', '', '', '', 0, 1, '2025-11-28 01:36:55', '2025-11-28 01:36:55'),
	(30, 51, 'CIGARROS-20UND-UNIVERSAL-9NXB', '', '', '', '', 0, 1, '2025-11-28 01:37:30', '2025-11-28 01:37:30'),
	(31, 172, 'JUGOS-EL-VALLE-NARANJA-15L-SE0C', '', '', '', '', 0, 1, '2025-11-28 01:45:03', '2025-11-28 01:45:03'),
	(32, 126, 'LADY-SPEED-STICK-18G-SSN5', '', '', '', '', 0, 1, '2025-11-28 01:45:52', '2025-11-28 01:45:52'),
	(33, 111, 'NUTRIBELLA15-TRATAMIENTO-CAPILAR-12X1-YAQI', '', '', '', '', 0, 1, '2025-11-28 02:04:37', '2025-11-28 02:04:37'),
	(34, 115, 'NUTRIBELLA15-ACONDICIONADOR-12X18ML-PRO-HIALURONICO-91BO', '', '', '', '', 0, 1, '2025-11-28 02:08:10', '2025-11-28 02:08:10'),
	(35, 273, 'PANELADA-HI3K', NULL, NULL, NULL, 'bebida', 0, 1, '2025-11-28 02:11:34', '2025-11-28 02:11:34'),
	(36, 244, 'PANALES-BABY-FINGER-P-OIO9', '', '', '', '', 0, 1, '2025-11-28 02:13:52', '2025-11-28 02:13:52'),
	(37, 245, 'PANALES-BABY-FINGER-M-DFLO', '', '', '', '', 0, 1, '2025-11-28 02:15:24', '2025-11-28 02:15:24'),
	(38, 246, 'PANALES-BABY-FINGER-G-VW9W', '', '', '', '', 0, 1, '2025-11-28 02:16:19', '2025-11-28 02:16:19'),
	(39, 247, 'PANALES-BABY-FINGER-RN-TOPX', '', '', '', '', 0, 1, '2025-11-28 02:16:53', '2025-11-28 02:16:53'),
	(40, 248, 'PANALES-BABY-FINGER-XXG-JJF0', '', '', '', '', 0, 1, '2025-11-28 02:17:15', '2025-11-28 02:17:15'),
	(41, 249, 'PANALES-HUGME-P-LASC', '', '', '', '', 0, 1, '2025-11-28 02:22:33', '2025-11-28 02:22:33'),
	(42, 250, 'PANALES-HUGME-M-TSAB', '', '', '', '', 0, 1, '2025-11-28 02:23:07', '2025-11-28 02:23:07'),
	(43, 251, 'PANALES-HUGME-G-NC7X', '', '', '', '', 0, 1, '2025-11-28 02:26:07', '2025-11-28 02:26:07'),
	(44, 252, 'PANALES-HUGME-XG-NKWW', '', '', '', '', 0, 1, '2025-11-28 02:27:04', '2025-11-28 02:27:04'),
	(45, 253, 'PANALES-HUGME-RN-Y1VR', '', '', '', '', 0, 1, '2025-11-28 02:28:02', '2025-11-28 02:28:02'),
	(46, 274, 'PASTA-ALLEGRI-RICATONES-LSGR', NULL, NULL, NULL, NULL, 0, 1, '2025-11-28 02:30:34', '2025-11-28 02:30:34'),
	(47, 275, 'PASTA-ALLEGRI-TUBO-0YAH', '', '', '', '', 0, 1, '2025-11-28 02:32:14', '2025-11-28 02:32:14'),
	(48, 276, '', '', '', '', '', 0, 1, '2025-11-28 02:33:17', '2025-11-28 02:33:17'),
	(49, 277, 'PASTA-ALLEGRI-LINGUINI-JAPY', '', '', '', '', 0, 1, '2025-11-28 02:34:53', '2025-11-28 02:34:53'),
	(50, 278, '', '', '', '', '', 0, 1, '2025-11-28 02:36:19', '2025-11-28 02:36:19'),
	(51, 279, 'PASTA-ALLEGRI-LINGUINI-COPIA-GYZO', '', '', '', '', 0, 1, '2025-11-28 02:37:01', '2025-11-28 02:37:01'),
	(52, 280, '', '', '', '', '', 0, 1, '2025-11-28 02:38:33', '2025-11-28 02:38:33'),
	(53, 281, '', '', '', '', '', 0, 1, '2025-11-28 02:39:17', '2025-11-28 02:39:17'),
	(54, 68, 'PIN-POP-BOMBA-GIGANTE-24X1-YFEU', '', '', '', '', 0, 1, '2025-11-28 02:41:01', '2025-11-28 02:41:01'),
	(55, 69, 'PIN-POP-BOMBA-GIGANTE-48X1-FQIX', '', '', '', '', 0, 1, '2025-11-28 02:41:37', '2025-11-28 02:41:37'),
	(56, 70, 'PIN-POP-BOMBA-SURTIDOS-AYXO', '', '', '', '', 0, 1, '2025-11-28 02:42:07', '2025-11-28 02:42:07'),
	(57, 71, 'PIN-POP-GIGANTE-MORA-FRESA-24X1-WTRV', '', '', '', '', 0, 1, '2025-11-28 02:43:12', '2025-11-28 02:43:12'),
	(58, 187, 'POWER-MAX-400ML-X14S', '', '', '', '', 0, 1, '2025-11-28 02:44:23', '2025-11-28 02:44:23'),
	(59, 219, 'PUFFY-SABOR-A-TOMATE-CON-ALBAHACA-VRVS', '', '', '', '', 0, 1, '2025-11-28 02:45:52', '2025-11-28 02:45:52'),
	(60, 218, 'PUFFY-SABOR-A-QUESO-TZUX', '', '', '', '', 0, 1, '2025-11-28 02:46:22', '2025-11-28 02:46:22'),
	(61, 217, 'PUFFY-SABOR-A-PIMIENTA-CON-LIMON-R2JD', '', '', '', '', 0, 1, '2025-11-28 02:46:45', '2025-11-28 02:46:45'),
	(62, 11, 'SALSA-DE-TOMATE-L4DE', '', '', '', '', 0, 1, '2025-11-28 02:48:13', '2025-11-28 02:48:13'),
	(63, 31, 'SALSA-DE-TOMATE-PAMPERO-XZFH', '', '', '', '', 0, 1, '2025-11-28 02:50:19', '2025-11-28 02:50:19'),
	(64, 220, 'SALTITACOS-X4O5', '', '', '', '', 0, 1, '2025-11-28 02:51:01', '2025-11-28 02:51:01'),
	(65, 127, '', '', '', '', '', 0, 1, '2025-11-28 02:52:47', '2025-11-28 02:52:47'),
	(66, 282, 'SUPER-PEGA-QIN5', NULL, NULL, NULL, NULL, 0, 1, '2025-11-28 02:55:39', '2025-11-28 02:55:39'),
	(67, 72, 'TAM-CIKOLATAM-83G-ARNC', '', '', '', '', 0, 1, '2025-11-28 02:56:47', '2025-11-28 02:56:47'),
	(68, 101, 'NUTRIBELA-BIOKERATINA-BE4N', '', '', '', '', 0, 1, '2025-11-28 02:59:43', '2025-11-28 02:59:43'),
	(69, 102, 'NUTRIBELA-ENZIMOTERAPIA-GQGI', '', '', '', '', 0, 1, '2025-11-28 03:00:59', '2025-11-28 03:00:59'),
	(70, 103, 'NUTRIBELA-CELULAS-MADRES-CIV2', '', '', '', '', 0, 1, '2025-11-28 03:01:48', '2025-11-28 03:01:48'),
	(71, 104, 'NUTRIBELA-PRO-HIALURONICO-9OPM', '', '', '', '', 0, 1, '2025-11-28 03:02:40', '2025-11-28 03:02:40'),
	(73, 107, 'NUTRIBELA-NUTRICION-AVANZADA-MP8U', '', '', '', '', 0, 1, '2025-11-28 03:04:46', '2025-11-28 03:04:46'),
	(74, 108, 'NUTRIBELA-REPOLARIZACION-EN-FRIO-WB2B', '', '', '', '', 0, 1, '2025-11-28 03:05:46', '2025-11-28 03:05:46'),
	(75, 151, 'AGUA-MINALBA-600ML-GJ2R', '', '', '', '', 0, 1, '2025-11-28 03:11:14', '2025-11-28 03:11:14');

-- Volcando estructura para tabla laravel.producto_variants
DROP TABLE IF EXISTS `producto_variants`;
CREATE TABLE IF NOT EXISTS `producto_variants` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `values` json NOT NULL,
  `sku` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_adjustment` decimal(10,2) NOT NULL DEFAULT '0.00',
  `precio_bs` decimal(10,2) DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `image_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image_thumbnail_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alt_text` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `producto_variants_producto_id_index` (`producto_id`),
  KEY `producto_variants_empresa_id_index` (`empresa_id`),
  CONSTRAINT `producto_variants_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `producto_variants_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=415 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.producto_variants: ~356 rows (aproximadamente)
DELETE FROM `producto_variants`;
INSERT INTO `producto_variants` (`id`, `producto_id`, `name`, `values`, `sku`, `price_adjustment`, `precio_bs`, `quantity`, `image_path`, `image_thumbnail_path`, `alt_text`, `empresa_id`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-POLAR-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Polar', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(2, 1, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-POLAR-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Polar', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(3, 2, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-POL-1KG', 0.00, NULL, 120, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Polar', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(4, 2, 'Peso: 2kg', '{"Peso": "2kg"}', 'HAR-POL-2KG', 0.00, NULL, 80, NULL, NULL, 'Peso: 2kg - Harina de Maíz Precocida Polar', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(5, 3, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-POL-1KG', 0.00, NULL, 120, NULL, NULL, 'Peso: 1kg - Harina de Trigo Pol', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(6, 3, 'Peso: 2kg', '{"Peso": "2kg"}', 'HAR-POL-2KG', 0.00, NULL, 80, NULL, NULL, 'Peso: 2kg - Harina de Trigo Pol', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(7, 4, 'volumen', '{"Volumen": "900ml"}', '', 0.00, 0.00, 80, NULL, NULL, 'Volumen: 900ml - Aceite de Soja Soya', 1, '2025-11-21 05:13:56', '2025-11-28 00:43:10'),
	(8, 5, 'Peso: 500gr', '{"Peso": "500gr"}', 'PAS-POL-500', 0.00, NULL, 110, NULL, NULL, 'Peso: 500gr - Pasta Larga tipo Spaghetti Santa Rita', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(9, 6, 'Peso: 1kg', '{"Peso": "1kg"}', 'AZU-POL-1KG', 0.00, NULL, 90, NULL, NULL, 'Peso: 1kg - Azúcar Morena', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(10, 7, 'Peso: 1kg', '{"Peso": "1kg"}', 'SAL-POL-1KG', 0.00, NULL, 70, NULL, NULL, 'Peso: 1kg - Sal de Mesa', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(11, 8, 'Peso: 200gr', '{"Peso": "200gr"}', 'CAF-POL-200', 0.00, NULL, 60, NULL, NULL, 'Peso: 200gr - Café Instantáneo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(12, 9, 'Peso: 400gr', '{"Peso": "400gr"}', 'LEC-POL-400', 0.00, NULL, 75, NULL, NULL, 'Peso: 400gr - Leche en Polvo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(13, 9, 'Peso: 800gr', '{"Peso": "800gr"}', 'LEC-POL-800', 0.00, NULL, 50, NULL, NULL, 'Peso: 800gr - Leche en Polvo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(14, 10, 'Peso: 250gr', '{"Peso": "250gr"}', 'GAL-POL-250', 0.00, NULL, 120, NULL, NULL, 'Peso: 250gr - Galletas Saladas', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(15, 11, 'Peso: 340gr', '{"Peso: 340gr": "340gr"}', 'SALSA-DE-TOMATE-L4DE', 0.00, 0.00, 90, NULL, NULL, 'Peso: 340gr - Salsa de Tomate', 1, '2025-11-21 05:13:56', '2025-11-28 02:48:13'),
	(16, 12, 'Peso: 350gr', '{"Peso": "350gr"}', 'MAY-POL-350', 0.00, NULL, 80, NULL, NULL, 'Peso: 350gr - Mayonesa', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(17, 13, 'Peso: 454gr', '{"Peso": "454gr"}', 'MER-POL-454', 0.00, NULL, 70, NULL, NULL, 'Peso: 454gr - Mermelada Fresa', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(18, 14, 'Peso: 160gr', '{"Peso": "160gr"}', 'ATU-POL-160', 0.00, NULL, 85, NULL, NULL, 'Peso: 160gr - Atún en Agua', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(19, 15, 'Peso: 120gr', '{"Peso": "120gr"}', 'SAR-POL-120', 0.00, NULL, 80, NULL, NULL, 'Peso: 120gr - Sardinas en Aceite', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(20, 16, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-MARY-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Mary', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(21, 16, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-MARY-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Mary', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(22, 17, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-MARY-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Mary', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(23, 17, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-MARY-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Mary', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(24, 18, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-SANTONI-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Santoni', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(25, 18, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-SANTONI-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Santoni', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(26, 19, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-SANTONI-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Santoni', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(27, 19, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-SANTONI-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Santoni', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(28, 20, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-SANTAMONICA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Santa Monica', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(29, 20, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-SANTAMONICA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Santa Monica', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(30, 21, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-SANTAMONICA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Santa Monica', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(31, 21, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-SANTAMONICA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Santa Monica', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(32, 22, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-AMANECER-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Amanecer', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(33, 22, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-AMANECER-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Amanecer', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(34, 23, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-AMANECER-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Amanecer', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(35, 23, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-AMANECER-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Amanecer', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(36, 24, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-CAPRI-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Capri', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(37, 24, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-CAPRI-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Capri', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(38, 25, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-CAPRI-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Capri', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(39, 25, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-CAPRI-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Capri', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(44, 28, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-DOBON-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Dobón', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(45, 28, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-DOBON-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Dobón', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(46, 29, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-DOBON-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Dobón', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(47, 29, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-DOBON-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Dobón', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(50, 31, 'Peso: 1kg', '{"Peso: 1kg": "198 ML"}', 'SALSA-DE-TOMATE-PAMPERO-XZFH', 0.00, 0.00, 100, NULL, NULL, 'Peso: 198 ML Salsa de tomate Pampero', 1, '2025-11-21 05:13:56', '2025-11-28 02:50:19'),
	(52, 32, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-IBERIA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Iberia', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(53, 32, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-IBERIA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Iberia', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(54, 33, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-IBERIA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Iberia', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(55, 33, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-IBERIA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Iberia', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(56, 34, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-BOKA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Boka', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(57, 34, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-BOKA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Boka', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(58, 35, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-BOKA-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Boka', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(59, 35, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-BOKA-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Boka', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(60, 36, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-COAMO-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Coamo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(61, 36, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-COAMO-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Coamo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(62, 37, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-COAMO-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Coamo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(63, 37, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-COAMO-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Coamo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(64, 38, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-PRINGLES-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Pringles', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(65, 38, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-PRINGLES-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Pringles', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(66, 39, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-PRINGLES-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Pringles', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(67, 39, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-PRINGLES-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Pringles', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(68, 40, 'Peso: 1kg', '{"Peso": "1kg"}', 'ARZ-TOM-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Arroz Blanco Tom', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(69, 40, 'Peso: 5kg', '{"Peso": "5kg"}', 'ARZ-TOM-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Arroz Blanco Tom', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(70, 41, 'Peso: 1kg', '{"Peso": "1kg"}', 'HAR-TOM-1KG', 0.00, NULL, 100, NULL, NULL, 'Peso: 1kg - Harina de Maíz Precocida Tom', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(71, 41, 'Peso: 5kg', '{"Peso": "5kg"}', 'HAR-TOM-5KG', 0.00, NULL, 50, NULL, NULL, 'Peso: 5kg - Harina de Maíz Precocida Tom', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(72, 42, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CHI-APU-1', 0.00, NULL, 1000, NULL, NULL, 'Cantidad: 1 und - Chimo el apureño', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(73, 43, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CHI-TIG-AMA', 0.00, NULL, 200, NULL, NULL, 'Cantidad: 1 und - Chimo El Tigrito Amarillo', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(74, 44, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CIG-LUC-NOV', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 1 und - Cigarrillos Nova Lucky Strike', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(75, 45, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CIG-LUC-RED', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 1 und - Cigarrillos Lucky Strike Red', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(76, 46, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CIG-LUC-ECL', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 1 und - Cigarros Eclipse Lucky Strike', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(77, 47, 'Cantidad: 10 und', '{"Cantidad": "10 und"}', 'CIG-BEL-10', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 10 und - Cigarros 10und Belmont', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(78, 48, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'CIG-BEL-20', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Belmont', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(79, 49, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CIG-PAL-GRAN', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 1 und - Cigarrillos Grandes Pall Mall', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(80, 50, 'Cantidad: 1 und', '{"Cantidad": "1 und"}', 'CIG-VIC-UND', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 1 und - Cigarros Viceroy', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(81, 51, 'Cantidad: 20 und', '{"Cantidad: 20 und": "20 und"}', 'CIGARROS-20UND-UNIVERSAL-9NXB', 0.00, 0.00, 100, NULL, NULL, 'Cantidad: 20 und - Cigarros 20und Universal', 1, '2025-11-21 05:13:56', '2025-11-28 01:37:30'),
	(82, 52, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'CIG-COS-20', 0.00, NULL, 100, NULL, NULL, 'Cantidad: 20 und - Cigarrillos Cosmic 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(83, 53, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'MAR-RED-20', 0.00, NULL, 80, NULL, NULL, 'Cantidad: 20 und - Marlboro Red 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(84, 54, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'MAR-GOL-20', 0.00, NULL, 75, NULL, NULL, 'Cantidad: 20 und - Marlboro Gold 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(85, 55, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'MAR-MEN-20', 0.00, NULL, 70, NULL, NULL, 'Cantidad: 20 und - Marlboro Menthol 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(86, 56, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'CAM-BLU-20', 0.00, NULL, 85, NULL, NULL, 'Cantidad: 20 und - Camel Blue 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(87, 57, 'Cantidad: 20 und', '{"Cantidad": "20 und"}', 'CAM-YEL-20', 0.00, NULL, 80, NULL, NULL, 'Cantidad: 20 und - Camel Yellow 20und', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(88, 58, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-ORI-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Original', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(89, 58, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-ORI-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Original', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(90, 59, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-CYC-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Crema y Cebolla', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(91, 59, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-CYC-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Crema y Cebolla', 1, '2025-11-21 05:13:56', '2025-11-21 05:13:56'),
	(92, 60, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-QUE-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Queso Cheddar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(93, 60, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-QUE-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Queso Cheddar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(94, 61, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-BBQ-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Barbacoa BBQ', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(95, 61, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-BBQ-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Barbacoa BBQ', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(96, 62, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-RAN-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Ranch', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(97, 62, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-RAN-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Ranch', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(98, 63, 'Peso: 110g', '{"Peso": "110g"}', 'PRI-PIZ-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Pringles Pizza', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(99, 63, 'Peso: 158g', '{"Peso": "158g"}', 'PRI-PIZ-158', 1.20, NULL, 80, NULL, NULL, 'Peso: 158g - Pringles Pizza', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(100, 64, 'Peso: 124g', '{"Peso": "124g"}', 'PRI-ENC-124', 0.00, NULL, 100, NULL, NULL, 'Peso: 124g - Pringles Enchilada', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(101, 65, 'Peso: 124g', '{"Peso": "124g"}', 'PRI-HAB-124', 0.00, NULL, 100, NULL, NULL, 'Peso: 124g - Pringles Habanero', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(102, 66, 'Peso: 140gr', '{"Peso": "140gr"}', 'TOS-TOM-AG-140', 0.00, NULL, 100, NULL, NULL, 'Peso: 140gr - Tostones con Ajo Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(103, 66, 'Peso: 80gr', '{"Peso": "80gr"}', 'TOS-TOM-AG-80', -0.56, NULL, 100, NULL, NULL, 'Peso: 80gr - Tostones con Ajo Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(104, 66, 'Peso: 28gr', '{"Peso": "28gr"}', 'TOS-TOM-AG-28', -1.11, NULL, 100, NULL, NULL, 'Peso: 28gr - Tostones con Ajo Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(105, 67, 'Peso: 140gr', '{"Peso": "140gr"}', 'TOS-TOM-NAT-140', 0.00, NULL, 100, NULL, NULL, 'Peso: 140gr - Tostones Natural Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(106, 67, 'Peso: 80gr', '{"Peso": "80gr"}', 'TOS-TOM-NAT-80', -0.56, NULL, 100, NULL, NULL, 'Peso: 80gr - Tostones Natural Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(107, 67, 'Peso: 28gr', '{"Peso": "28gr"}', 'TOS-TOM-NAT-28', -1.11, NULL, 100, NULL, NULL, 'Peso: 28gr - Tostones Natural Tom', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(108, 68, 'Caja: 24 x 1 und', '{"Caja: 24 x 1 und": "24 x 1 und"}', 'PIN-POP-BOMBA-GIGANTE-24X1-YFEU', 0.00, 0.00, 30, NULL, NULL, 'Caja: 24 x 1 und - Pin Pop Bomba Gigante 24x1', 1, '2025-11-21 05:13:57', '2025-11-28 02:41:01'),
	(109, 69, 'Caja: 48 x 1 und', '{"Caja: 48 x 1 und": "48 x 1 und"}', 'PIN-POP-BOMBA-GIGANTE-48X1-FQIX', 0.00, 0.00, 15, NULL, NULL, 'Caja: 48 x 1 und - Pin Pop Bomba Gigante 48x1', 1, '2025-11-21 05:13:57', '2025-11-28 02:41:37'),
	(110, 70, 'Caja: Surtidos', '{"Caja: Surtidos": "Surtidos"}', 'PIN-POP-BOMBA-SURTIDOS-AYXO', 0.00, 0.00, 40, NULL, NULL, 'Caja: Surtidos - Pin Pop Bomba Surtidos', 1, '2025-11-21 05:13:57', '2025-11-28 02:42:07'),
	(111, 71, 'Caja: 24 x 1 und', '{"Caja: 24 x 1 und": "24 x 1 und"}', 'PIN-POP-GIGANTE-MORA-FRESA-24X1-WTRV', 0.00, 0.00, 25, NULL, NULL, 'Caja: 24 x 1 und - Pin Pop Gigante Mora Fresa 24x1', 1, '2025-11-21 05:13:57', '2025-11-28 02:43:13'),
	(112, 72, 'Peso: 83g', '{"Peso: 83g": "83g"}', 'TAM-CIKOLATAM-83G-ARNC', 0.00, 0.00, 60, NULL, NULL, 'Peso: 83g - Tam Cikolatam 83g', 1, '2025-11-21 05:13:57', '2025-11-28 02:56:47'),
	(113, 73, 'Volumen: 1L', '{"Volumen": "1L"}', 'CLO-LIM-EXT-1L', 0.00, NULL, 75, NULL, NULL, 'Volumen: 1L - Cloro Limpieza Extrema 1L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(114, 74, 'Peso: 500g', '{"Peso": "500g"}', 'ALIVE-AZUL-EGNJ', 0.00, 0.00, 100, NULL, NULL, 'Peso: 500g - Alive Azul', 1, '2025-11-21 05:13:57', '2025-11-27 23:42:29'),
	(115, 74, 'Peso: 1kg', '{"Peso": "1kg"}', 'ALIVE-AZUL-EGNJ', 1.50, 0.00, 80, NULL, NULL, 'Peso: 1kg - Alive Azul', 1, '2025-11-21 05:13:57', '2025-11-27 23:42:29'),
	(116, 75, 'Peso: 500g', '{"Peso": "500g"}', 'ALIVE-MORADO-V3GU', 0.00, 0.00, 100, NULL, NULL, 'Peso: 500g - Alive Morado', 1, '2025-11-21 05:13:57', '2025-11-27 23:40:47'),
	(117, 75, 'Peso: 1kg', '{"Peso": "1kg"}', 'ALIVE-MORADO-V3GU', 1.50, 0.00, 80, NULL, NULL, 'Peso: 1kg - Alive Morado', 1, '2025-11-21 05:13:57', '2025-11-27 23:40:47'),
	(118, 76, 'Peso: 500g', '{"Peso": "500g"}', 'ALIVE-VERDE-PAC4', 0.00, 0.00, 100, NULL, NULL, 'Peso: 500g - Alive Verde', 1, '2025-11-21 05:13:57', '2025-11-27 23:40:27'),
	(119, 76, 'Peso: 1kg', '{"Peso": "1kg"}', 'ALIVE-VERDE-PAC4', 1.50, 0.00, 80, NULL, NULL, 'Peso: 1kg - Alive Verde', 1, '2025-11-21 05:13:57', '2025-11-27 23:40:27'),
	(123, 79, 'Peso: 500g', '{"Peso": "500g"}', 'ALIVE-BLANCO-IX9P', 0.00, 0.00, 100, NULL, NULL, 'Peso: 500g - Alive Blanco', 1, '2025-11-21 05:13:57', '2025-11-27 23:37:24'),
	(124, 80, 'Peso: 500g', '{"Peso": "500g"}', 'ALIVE-ROSADO-4XJS', 0.00, 0.00, 100, NULL, NULL, 'Peso: 500g - Alive Rosado', 1, '2025-11-21 05:13:57', '2025-11-27 23:36:17'),
	(125, 81, 'Cantidad: 10 und', '{"Cantidad": "10 und"}', 'ALIVE-TOALLAS-FEMENINAS-THTI', 0.00, 0.00, 80, NULL, NULL, 'Cantidad: 10 und - Alive Toallas Femeninas', 1, '2025-11-21 05:13:57', '2025-11-27 23:35:46'),
	(126, 82, 'Cantidad: 8 und', '{"Cantidad": "8 und"}', 'TOALLAS-ALIVE-NOCTURNAS-9VSS', 0.00, 0.00, 70, NULL, NULL, 'Cantidad: 8 und - Toallas Alive Nocturnas', 1, '2025-11-21 05:13:57', '2025-11-27 23:33:36'),
	(129, 84, 'size', '{"Size": "1000ml"}', 'OSO-BLANCO-CLORO-GEL-W6L5', 1.00, 0.00, 80, NULL, NULL, 'Presentación: 1000ml - Oso Blanco Cloro Gel', 1, '2025-11-21 05:13:57', '2025-11-28 01:17:19'),
	(130, 85, 'Presentación: Paquete de 4 rollos', '{"Presentación": "Paquete de 4 rollos"}', 'OSO-CL-PAPER-500', 0.00, NULL, 100, NULL, NULL, 'Presentación: Paquete de 4 rollos - Papel Higienico Luciano', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(139, 90, 'Presentación: 1000ml', '{"Presentación: 1000ml": "1000ml"}', 'OSO-BLANCO-DESINFECTANTE-LAVANDA-RRWM', 0.00, 0.00, 100, NULL, NULL, 'Presentación: 1000ml - Oso Blanco Desinfectante Lavanda', 1, '2025-11-21 05:13:57', '2025-11-28 01:26:30'),
	(140, 91, 'Presentación: 1000ml', '{"Presentación: 1000ml": "1000ml"}', 'OSO-BLANCO-DESINFECTANTE-MANZANA-B9Y8', 0.00, 0.00, 100, NULL, NULL, 'Presentación: 1000ml - Oso Blanco Desinfectante Manzana', 1, '2025-11-21 05:13:57', '2025-11-28 01:27:00'),
	(141, 92, 'Presentación: 1000ml', '{"Presentación": "1000ml"}', 'OSO-DES-CHR', 0.00, NULL, 100, NULL, NULL, 'Presentación: 1000ml - Oso Blanco Desinfectante Cherry', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(142, 93, 'Presentación: 1000ml', '{"Presentación: 1000ml": "1000ml"}', 'OSO-BLANCO-DESINFECTANTE-FRESCA-SENSACION-EVPI', 0.00, 0.00, 100, NULL, NULL, 'Presentación: 1000ml - Oso Blanco Desinfectante Fresca Sensación', 1, '2025-11-21 05:13:57', '2025-11-28 01:30:57'),
	(143, 94, 'Presentación: 1000ml', '{"Presentación: 1000ml": "1000ml"}', 'DESINFECTANTE-OSO-BLANCO-INTENSA-FLORAL-WIFI', 0.00, 0.00, 95, NULL, NULL, 'Presentación: 1000ml - Desinfectante Oso Blanco Intensa Floral', 1, '2025-11-21 05:13:57', '2025-11-28 01:31:28'),
	(145, 96, 'Peso: 500g', '{"Peso": "500g"}', 'LIMPIAPISOS-EN-POLVO-AROMAX-ABWO', 0.00, NULL, 90, NULL, NULL, 'Peso: 500g - Limpiapisos en Polvo Aromax', 1, '2025-11-21 05:13:57', '2025-11-21 07:27:28'),
	(146, 97, 'Volumen: 900ml', '{"Volumen: 900ml": "900ml"}', 'SUAVITEL-CUIDADO-SUPERIOR-FRESCURA-DE-MANZANA-Z6D6', 0.00, 0.00, 70, NULL, NULL, 'Volumen: 900ml - Suavitel Cuidado Superior Frescura de Manzana', 1, '2025-11-21 05:13:57', '2025-11-28 01:14:40'),
	(147, 98, 'Volumen: 900ml', '{"Volumen: 900ml": "900ml"}', 'SUAVITEL-CUIDADO-SUPERIOR-FRESCURA-DE-PRIMAVERA-7F2N', 0.00, 0.00, 70, NULL, NULL, 'Volumen: 900ml - Suavitel Cuidado Superior Frescura de Primavera', 1, '2025-11-21 05:13:57', '2025-11-28 01:14:18'),
	(148, 99, 'Volumen: 900ml', '{"Volumen: 900ml": "900ml"}', 'SUAVITEL-CUIDADO-SUPERIOR-FRESA-Y-CHOCOLATE-QQGY', 0.00, 0.00, 65, NULL, NULL, 'Volumen: 900ml - Suavitel Cuidado Superior Fresa y Chocolate', 1, '2025-11-21 05:13:57', '2025-11-28 01:13:51'),
	(149, 100, 'Cantidad: 100 und', '{"Cantidad": "100 und"}', 'SERVILLETAS-BLUE-SOFTY-EKUT', 0.00, NULL, 120, NULL, NULL, 'Cantidad: 100 und - Servilletas Blue Softy', 1, '2025-11-21 05:13:57', '2025-11-27 23:22:39'),
	(150, 101, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-BIOKERATINA-BE4N', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Biokeratina', 1, '2025-11-21 05:13:57', '2025-11-28 02:59:43'),
	(151, 101, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-BIOKERATINA-BE4N', 1.90, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Biokeratina', 1, '2025-11-21 05:13:57', '2025-11-28 02:59:43'),
	(152, 102, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-ENZIMOTERAPIA-GQGI', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Enzimoterapia', 1, '2025-11-21 05:13:57', '2025-11-28 03:00:59'),
	(153, 102, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-ENZIMOTERAPIA-GQGI', 1.67, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Enzimoterapia', 1, '2025-11-21 05:13:57', '2025-11-28 03:00:59'),
	(154, 103, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-CELULAS-MADRES-CIV2', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Células Madres', 1, '2025-11-21 05:13:57', '2025-11-28 03:01:48'),
	(155, 103, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-CELULAS-MADRES-CIV2', 1.90, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Células Madres', 1, '2025-11-21 05:13:57', '2025-11-28 03:01:48'),
	(156, 104, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-PRO-HIALURONICO-9OPM', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Pro Hialurónico', 1, '2025-11-21 05:13:57', '2025-11-28 03:02:40'),
	(157, 104, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-PRO-HIALURONICO-9OPM', 1.90, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Pro Hialurónico', 1, '2025-11-21 05:13:57', '2025-11-28 03:02:40'),
	(162, 107, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-NUTRICION-AVANZADA-MP8U', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Nutrición Avanzada', 1, '2025-11-21 05:13:57', '2025-11-28 03:04:46'),
	(163, 107, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-NUTRICION-AVANZADA-MP8U', 1.90, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Nutrición Avanzada', 1, '2025-11-21 05:13:57', '2025-11-28 03:04:46'),
	(164, 108, 'Presentación: 300ml', '{"Presentación: 300ml": "300ml"}', 'NUTRIBELA-REPOLARIZACION-EN-FRIO-WB2B', 0.00, 0.00, 50, NULL, NULL, 'Presentación: 300ml - Nutribela Repolarización en Frío', 1, '2025-11-21 05:13:57', '2025-11-28 03:05:46'),
	(165, 108, 'Presentación: 12 sobres', '{"Presentación: 12 sobres": "12 sobres"}', 'NUTRIBELA-REPOLARIZACION-EN-FRIO-WB2B', 1.90, 0.00, 100, NULL, NULL, 'Presentación: 12 sobres - Nutribela Repolarización en Frío', 1, '2025-11-21 05:13:57', '2025-11-28 03:05:46'),
	(166, 109, 'Presentación: 12 x 15ml', '{"Presentación": "12 x 15ml"}', '', 0.00, NULL, 80, NULL, NULL, 'Presentación: 12 x 15ml - Nutribella15 Acondicionador 12x15ml Con células madres', 1, '2025-11-21 05:13:57', '2025-11-21 07:30:18'),
	(167, 110, 'Presentación: 12 x 15ml', '{"Presentación": "12 x 15ml"}', '', 0.00, NULL, 85, NULL, NULL, 'Presentación: 12 x 15ml - Nutribella15 Shampoo 12x15ml Reparación Intensiva', 1, '2025-11-21 05:13:57', '2025-11-21 07:45:40'),
	(168, 111, 'Presentación: 12 x 1 und', '{"Presentación: 12 x 1 und": "12 x 1 und"}', 'NUTRIBELLA15-TRATAMIENTO-CAPILAR-12X1-YAQI', 0.00, 0.00, 60, NULL, NULL, 'Presentación: 12 x 1 und - Nutribella15 Tratamiento Capilar 12x1', 1, '2025-11-21 05:13:57', '2025-11-28 02:07:43'),
	(169, 112, 'Presentación: 12 x 15ml', '{"Presentación": "12 x 15ml"}', 'NUTRIBELLA15-ACONDICIONADOR-12X15ML-ENZIMOTERAPIA-6QCD', 0.00, NULL, 80, NULL, NULL, 'Presentación: 12 x 15ml - Nutribella15 Acondicionador 12x15ml Enzimoterapia', 1, '2025-11-21 05:13:57', '2025-11-21 07:32:28'),
	(170, 113, 'Presentación: 12 x 15ml', '{"Presentación": "12 x 15ml"}', 'NUTRIBELLA15-ACONDICIONADOR-12X15ML-PRO-HIALURONICO-9FLE', 0.00, NULL, 80, NULL, NULL, 'Presentación: 12 x 15ml - Nutribella15 Acondicionador 12x15ml Pro hialurónico', 1, '2025-11-21 05:13:57', '2025-11-21 07:33:05'),
	(171, 114, 'Presentación: 12 x 15ml', '{"Presentación": "12 x 15ml"}', 'NUTRIBELLA15-ACONDICIONADOR-12X15ML-REPARACION-INTENSIVA-QIX9', 0.00, NULL, 80, NULL, NULL, 'Presentación: 12 x 15ml - Nutribella15 Acondicionador 12x15ml Reparación Intensiva', 1, '2025-11-21 05:13:57', '2025-11-21 07:33:38'),
	(172, 115, 'Presentación: 12 x 18ml', '{"Presentación: 12 x 18ml": "12 x 18ml"}', 'NUTRIBELLA15-ACONDICIONADOR-12X18ML-PRO-HIALURONICO-91BO', 0.00, 0.00, 75, NULL, NULL, 'Presentación: 12 x 18ml - Nutribella15 Acondicionador 12x18ml Pro hialurónico', 1, '2025-11-21 05:13:57', '2025-11-28 02:08:10'),
	(175, 118, 'Presentación: 12 x 18ml', '{"Presentación": "12 x 18ml"}', '', 0.00, NULL, 80, NULL, NULL, 'Presentación: 12 x 18ml - Nutribella15 Shampoo 12x18ml Enzimoterapia', 1, '2025-11-21 05:13:57', '2025-11-21 07:46:23'),
	(178, 121, 'Presentación: 12 x 24ml', '{"Presentación": "12 x 24ml"}', 'NUTRIBELLA15-TRATAMIENTO-CAPILAR-12X24ML-ENZIMOTERAPIA-NZQA', 0.00, NULL, 55, NULL, NULL, 'Presentación: 12 x 24ml - Nutribella15 Tratamiento Capilar 12x24ml Enzimoterapia', 1, '2025-11-21 05:13:57', '2025-11-21 07:57:58'),
	(179, 122, 'Peso: 100ml', '{"Peso: 100ml": "100ml"}', 'ALIDENT-GEL-TRIPLE-ACCION-K6JI', 0.00, 0.00, 80, NULL, NULL, 'Peso: 100ml - Alident Gel Triple Acción', 1, '2025-11-21 05:13:57', '2025-11-28 01:12:06'),
	(180, 123, 'Peso: 100ml', '{"Peso: 100ml": "100ml"}', 'ALIDENT-GEL-AZUL-HTLT', 0.00, 0.00, 85, NULL, NULL, 'Peso: 100ml - Alident Gel Verde Azul', 1, '2025-11-21 05:13:57', '2025-11-28 01:11:40'),
	(181, 124, 'Peso: 100ml', '{"Peso: 100ml": "100ml"}', 'ALIDENT-GEL-VERDE-FRESCO-5SVD', 0.00, 0.00, 85, NULL, NULL, 'Peso: 100ml - Alident Gel Verde Fresco', 1, '2025-11-21 05:13:57', '2025-11-28 01:10:55'),
	(182, 125, 'Caja: 12 x 90g', '{"Caja": "12 x 90g"}', 'COLGATE-12-X-90G-PNWV', 0.00, NULL, 20, NULL, NULL, 'Caja: 12 x 90g - Colgate 12 x 90g', 1, '2025-11-21 05:13:57', '2025-11-21 05:52:44'),
	(183, 126, 'Peso: 18g', '{"Peso: 18g": "18g"}', 'LADY-SPEED-STICK-18G-SSN5', 0.00, 0.00, 60, NULL, NULL, 'Peso: 18g - Lady Speed Stick 18g', 1, '2025-11-21 05:13:57', '2025-11-28 02:52:26'),
	(184, 127, 'Peso: 18g', '{"Peso: 18g": "18g"}', '', 0.00, 0.00, 65, NULL, NULL, 'Peso: 18g - Speed Stick 18g', 1, '2025-11-21 05:13:57', '2025-11-28 02:52:47'),
	(185, 128, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-ANI-ROS-110', 0.00, NULL, 100, NULL, NULL, 'Peso: 110g - Jabón Anita Rosado', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(186, 129, 'Peso: 110g', '{"Peso": "110g"}', '', 0.00, NULL, 95, NULL, NULL, 'Peso: 110g - Jabón Frita Azul', 1, '2025-11-21 05:13:57', '2025-11-21 06:44:53'),
	(187, 130, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'COC-ORI-350', 0.00, NULL, 100, NULL, NULL, 'Volumen: 350ml - Coca Cola Original 350ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(188, 131, 'Volumen: 355ml', '{"Volumen": "355ml"}', '', 0.00, NULL, 120, NULL, NULL, 'Volumen: 355ml - Coca Cola Original 355ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:51:32'),
	(196, 135, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'PEP-ORI-350', 0.00, NULL, 100, NULL, NULL, 'Volumen: 350ml - Pepsi Original 350ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(197, 136, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'PEP-ORI-500', 0.00, NULL, 80, NULL, NULL, 'Volumen: 500ml - Pepsi Original 500ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(198, 137, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-PEP-COL-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Pepsi Cola', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(199, 137, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-PEP-COL-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Pepsi Cola', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(200, 137, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-PEP-COL-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Pepsi Cola', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(201, 137, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-PEP-COL-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Pepsi Cola', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(202, 137, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-PEP-COL-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Pepsi Cola', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(203, 138, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'SPR-ORI-350', 0.00, NULL, 100, NULL, NULL, 'Volumen: 350ml - Sprite Original 350ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(204, 139, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'SPR-ORI-500', 0.00, NULL, 80, NULL, NULL, 'Volumen: 500ml - Sprite Original 500ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(205, 140, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'FAN-NAR-350', 0.00, NULL, 100, NULL, NULL, 'Volumen: 350ml - Fanta Naranja 350ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(206, 141, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'FAN-UVA-350', 0.00, NULL, 90, NULL, NULL, 'Volumen: 350ml - Fanta Uva 350ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(207, 142, 'Caja: 36 x 222ml', '{"Caja": "36 x 222ml"}', 'MAL-POL-RET-36X222', 0.00, NULL, 20, NULL, NULL, 'Caja: 36 x 222ml - Malta Retornable 36x222ml Maltil Polar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(208, 143, 'Caja: 12 x 250ml', '{"Caja": "12 x 250ml"}', 'MAL-POL-DES-12X250', 0.00, NULL, 30, NULL, NULL, 'Caja: 12 x 250ml - Malta Desechable 12x250ml Maltin Polar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(209, 144, 'Caja: 24 x 330ml', '{"Caja": "24 x 330ml"}', 'MAL-POL-LAT-24X330', 0.00, NULL, 25, NULL, NULL, 'Caja: 24 x 330ml - Malta de Lata 24x330ml Maltin Polar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(210, 145, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'MAL-POL-1.5L', 0.00, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Malta 1.5Lt Maltin Polar', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(211, 146, 'Volumen: 355ml', '{"Volumen": "355ml"}', 'MAL-POL-355', 0.00, NULL, 100, NULL, NULL, 'Volumen: 355ml - Maltin 355ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(212, 147, 'Volumen: 1L', '{"Volumen": "1L"}', 'LEC-CAR-ENT-1L', 0.00, NULL, 80, NULL, NULL, 'Volumen: 1L - Leche Líquida Carabobo Entera', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(213, 148, 'Volumen: 1L', '{"Volumen": "1L"}', 'LEC-CAR-DESC-1L', 0.00, NULL, 75, NULL, NULL, 'Volumen: 1L - Leche Líquida Carabobo Descremada', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(214, 149, 'Volumen: 1L', '{"Volumen": "1L"}', 'LEC-CAR-SEMI-1L', 0.00, NULL, 70, NULL, NULL, 'Volumen: 1L - Leche Líquida Carabobo Semi-descremada', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(215, 150, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-FRU-COL-2L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Frut Cola 2L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(216, 151, 'Volumen: 600ml', '{"Volumen: 600ml": "600ml"}', 'AGUA-MINALBA-600ML-GJ2R', 0.00, 0.00, 120, NULL, NULL, 'Volumen: 600ml - Agua Minalba 600ml', 1, '2025-11-21 05:13:57', '2025-11-28 03:11:14'),
	(217, 152, 'Volumen: 1L', '{"Volumen": "1L"}', 'AGU-COO-1L', 0.00, NULL, 100, NULL, NULL, 'Volumen: 1L - Agua Mineral Cool 1L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(219, 154, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'AGU-VIS-1.5L', 0.00, NULL, 80, NULL, NULL, 'Volumen: 1.5L - Agua Vista 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(226, 161, 'Caja: 12 x 1.5L', '{"Caja": "12 x 1.5L"}', 'FRU-MAN-12X1.5', 0.00, NULL, 15, NULL, NULL, 'Caja: 12 x 1.5L - Frubys Manzana 12x1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(227, 162, 'Caja: 12 x 1.5L', '{"Caja": "12 x 1.5L"}', 'FRU-PER-12X1.5', 0.00, NULL, 15, NULL, NULL, 'Caja: 12 x 1.5L - Frubys Pera 12x1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(228, 163, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'FRT-LIM-1.5L', 0.00, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Frutea Limón 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(229, 164, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'FRT-DUR-1.5L', 0.00, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Frutea Durazno 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(230, 165, 'Volumen: 250ml', '{"Volumen": "250ml"}', 'FTS-PAS-250', 0.00, NULL, 80, NULL, NULL, 'Volumen: 250ml - Fruttsy Passion 250ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(231, 166, 'Volumen: 250ml', '{"Volumen": "250ml"}', 'FTS-FRR-250', 0.00, NULL, 80, NULL, NULL, 'Volumen: 250ml - Fruttsy Frutos Rojos 250ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(232, 167, 'Volumen: 250ml', '{"Volumen": "250ml"}', 'FTS-NAR-250', 0.00, NULL, 80, NULL, NULL, 'Volumen: 250ml - Fruttsy Naranja 250ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(233, 168, 'Caja: 24 x 250ml', '{"Caja": "24 x 250ml"}', 'FTS-FRR-24X250', 0.00, NULL, 15, NULL, NULL, 'Caja: 24 x 250ml - Jugo Fruttsy Frutos Rojos 24x250ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(234, 169, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'FRY-DUR-1.5L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Frutys Durazno 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(235, 170, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'FRY-NAR-1.5L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Frutys Naranja 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(236, 171, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'FRY-MAN-1.5L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Frutys Mandarina 1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(237, 172, 'Volumen: 1.5L', '{"Volumen: 1.5L": "1.5L"}', 'JUGOS-EL-VALLE-NARANJA-15L-SE0C', 0.00, 0.00, 45, NULL, NULL, 'Volumen: 1.5L - Jugos El Valle Naranja 1.5L', 1, '2025-11-21 05:13:57', '2025-11-28 01:45:03'),
	(238, 173, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'LIP-DUR-500', 0.00, NULL, 70, NULL, NULL, 'Volumen: 500ml - Lipton Ice Tea Durazno 500ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(239, 174, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'LIP-LIM-500', 0.00, NULL, 70, NULL, NULL, 'Volumen: 500ml - Lipton Ice Tea Limón 500ml', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(240, 175, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUC-PER-1L', 0.00, NULL, 60, NULL, NULL, 'Volumen: 1L - Jucosa Refrescante Pera', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(241, 176, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUC-MAN-1L', 0.00, NULL, 60, NULL, NULL, 'Volumen: 1L - Jucosa Refrescante Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(242, 177, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'NATULAC-PERA-JPIV', 0.00, 0.00, 65, NULL, NULL, 'Volumen: 1LT- Natulac Pera', 1, '2025-11-21 05:13:57', '2025-11-27 23:51:31'),
	(243, 178, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'JUGO-NATULAC-MANZANA-FBIB', 0.00, 0.00, 60, NULL, NULL, 'Volumen: 500ml - Jugo Natulac Manzana', 1, '2025-11-21 05:13:57', '2025-11-27 23:50:24'),
	(244, 179, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'JUGO-NATULAC-DURAZNO-BBU1', 0.00, 0.00, 60, NULL, NULL, 'Volumen: 1LT - Jugo Natulac Durazno', 1, '2025-11-21 05:13:57', '2025-11-27 23:49:32'),
	(245, 180, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUG-VAL-COC-1L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1L - Jugo Valencia Coctel', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(246, 181, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUG-VAL-NAR-1L', 0.00, NULL, 55, NULL, NULL, 'Volumen: 1L - Jugo Valencia Naranjada', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(247, 182, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUG-VAL-DUR-1L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1L - Jugo Valencia Durazno', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(248, 183, 'Volumen: 1L', '{"Volumen": "1L"}', 'JUG-VAL-PER-1L', 0.00, NULL, 50, NULL, NULL, 'Volumen: 1L - Jugo Valencia Pera', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(249, 184, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'JUG-JUS-NAR-500', 0.00, NULL, 65, NULL, NULL, 'Volumen: 500ml - Jugo Justy Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(250, 185, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'JUG-SPE-500', 0.00, NULL, 70, NULL, NULL, 'Volumen: 500ml - Jugo Speed', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(251, 186, 'Volumen: 355ml', '{"Volumen": "355ml"}', 'JUG-SPE-LAT-355', 0.00, NULL, 80, NULL, NULL, 'Volumen: 355ml - Jugo Speed Lata', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(252, 187, 'Volumen: 400ml', '{"Volumen: 400ml": "400ml"}', 'POWER-MAX-400ML-X14S', 0.00, 0.00, 50, NULL, NULL, 'Volumen: 400ml - Power Max 400ml', 1, '2025-11-21 05:13:57', '2025-11-28 02:44:23'),
	(253, 188, 'Caja: 100 x 1 und', '{"Caja: 100 x 1 und": "100 x 1 und"}', 'ALDOR-TAMARINDO-100X1-5X4X', 0.00, 0.00, 10, NULL, NULL, 'Caja: 100 x 1 und - Aldor Tamarindo 100x1', 1, '2025-11-21 05:13:57', '2025-11-28 01:09:57'),
	(254, 189, 'Caja: 6 x 1.5L', '{"Caja": "6 x 1.5L"}', 'FRU-FRU-6X1.5', 0.00, NULL, 25, NULL, NULL, 'Caja: 6 x 1.5L - Jugo Fruton Fruit Punch 6x1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(255, 190, 'Caja: 6 x 1.5L', '{"Caja": "6 x 1.5L"}', 'FRU-CIT-6X1.5', 0.00, NULL, 25, NULL, NULL, 'Caja: 6 x 1.5L - Jugo Fruton Citrus Punch 6x1.5L', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(256, 191, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-NAR-400', 0.00, NULL, 120, NULL, NULL, 'Volumen: 400ml - Glup Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(257, 191, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-NAR-1L', 0.85, NULL, 80, NULL, NULL, 'Volumen: 1L - Glup Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(258, 191, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-NAR-1.5L', 1.25, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Glup Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(259, 191, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-NAR-2L', 1.65, NULL, 50, NULL, NULL, 'Volumen: 2L - Glup Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(260, 192, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-LIM-400', 0.00, NULL, 120, NULL, NULL, 'Volumen: 400ml - Glup Limón', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(261, 192, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-LIM-1L', 0.85, NULL, 80, NULL, NULL, 'Volumen: 1L - Glup Limón', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(262, 192, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-LIM-1.5L', 1.25, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Glup Limón', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(263, 192, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-LIM-2L', 1.65, NULL, 50, NULL, NULL, 'Volumen: 2L - Glup Limón', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(264, 193, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-UVA-400', 0.00, NULL, 115, NULL, NULL, 'Volumen: 400ml - Glup Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(265, 193, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-UVA-1L', 0.85, NULL, 75, NULL, NULL, 'Volumen: 1L - Glup Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(266, 193, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-UVA-1.5L', 1.25, NULL, 55, NULL, NULL, 'Volumen: 1.5L - Glup Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(267, 193, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-UVA-2L', 1.65, NULL, 45, NULL, NULL, 'Volumen: 2L - Glup Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(268, 194, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-MAN-400', 0.00, NULL, 115, NULL, NULL, 'Volumen: 400ml - Glup Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(269, 194, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-MAN-1L', 0.85, NULL, 75, NULL, NULL, 'Volumen: 1L - Glup Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(270, 194, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-MAN-1.5L', 1.25, NULL, 55, NULL, NULL, 'Volumen: 1.5L - Glup Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(271, 194, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-MAN-2L', 1.65, NULL, 45, NULL, NULL, 'Volumen: 2L - Glup Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(272, 195, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-TRO-400', 0.00, NULL, 110, NULL, NULL, 'Volumen: 400ml - Glup Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(273, 195, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-TRO-1L', 0.85, NULL, 70, NULL, NULL, 'Volumen: 1L - Glup Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(274, 195, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-TRO-1.5L', 1.25, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Glup Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(275, 195, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-TRO-2L', 1.65, NULL, 40, NULL, NULL, 'Volumen: 2L - Glup Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(276, 196, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-FRE-400', 0.00, NULL, 110, NULL, NULL, 'Volumen: 400ml - Glup Fresa', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(277, 196, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-FRE-1L', 0.85, NULL, 70, NULL, NULL, 'Volumen: 1L - Glup Fresa', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(278, 196, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-FRE-1.5L', 1.25, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Glup Fresa', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(279, 196, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-FRE-2L', 1.65, NULL, 40, NULL, NULL, 'Volumen: 2L - Glup Fresa', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(280, 197, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-COL-400', 0.00, NULL, 105, NULL, NULL, 'Volumen: 400ml - Glup Cola Negra', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(281, 197, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-COL-1L', 0.85, NULL, 65, NULL, NULL, 'Volumen: 1L - Glup Cola Negra', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(282, 197, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-COL-1.5L', 1.25, NULL, 45, NULL, NULL, 'Volumen: 1.5L - Glup Cola Negra', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(283, 197, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-COL-2L', 1.65, NULL, 35, NULL, NULL, 'Volumen: 2L - Glup Cola Negra', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(284, 198, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-COLI-400', 0.00, NULL, 105, NULL, NULL, 'Volumen: 400ml - Glup Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(285, 198, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-COLI-1L', 0.85, NULL, 65, NULL, NULL, 'Volumen: 1L - Glup Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(286, 198, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-COLI-1.5L', 1.25, NULL, 45, NULL, NULL, 'Volumen: 1.5L - Glup Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(287, 198, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-COLI-2L', 1.65, NULL, 35, NULL, NULL, 'Volumen: 2L - Glup Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(288, 199, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'GLP-FRESH-400', 0.00, NULL, 105, NULL, NULL, 'Volumen: 400ml - Glup Fresh', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(289, 199, 'Volumen: 1L', '{"Volumen": "1L"}', 'GLP-FRESH-1L', 0.85, NULL, 65, NULL, NULL, 'Volumen: 1L - Glup Fresh', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(290, 199, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'GLP-FRESH-1.5L', 1.25, NULL, 45, NULL, NULL, 'Volumen: 1.5L - Glup Fresh', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(291, 199, 'Volumen: 2L', '{"Volumen": "2L"}', 'GLP-FRESH-2L', 1.65, NULL, 35, NULL, NULL, 'Volumen: 2L - Glup Fresh', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(292, 200, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'GAT-AZU-500', 0.00, NULL, 60, NULL, NULL, 'Volumen: 500ml - Gatorade Azul', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(293, 200, 'Volumen: 1L', '{"Volumen": "1L"}', 'GAT-AZU-1L', 1.15, NULL, 40, NULL, NULL, 'Volumen: 1L - Gatorade Azul', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(294, 201, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'GAT-MAN-500', 0.00, NULL, 60, NULL, NULL, 'Volumen: 500ml - Gatorade Mandarina', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(295, 201, 'Volumen: 1L', '{"Volumen": "1L"}', 'GAT-MAN-1L', 1.15, NULL, 40, NULL, NULL, 'Volumen: 1L - Gatorade Mandarina', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(296, 202, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'GAT-TRO-500', 0.00, NULL, 60, NULL, NULL, 'Volumen: 500ml - Gatorade Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(297, 202, 'Volumen: 1L', '{"Volumen": "1L"}', 'GAT-TRO-1L', 1.15, NULL, 40, NULL, NULL, 'Volumen: 1L - Gatorade Tropical', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(302, 203, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'AGUA-MINERAL-MI-BRISA-V216', 0.85, 0.00, 80, NULL, NULL, 'Volumen: 350ml - Agua Mineral Mi Brisa', 1, '2025-11-21 05:13:57', '2025-11-28 00:31:41'),
	(307, 204, 'Volumen: 1L', '{"Volumen": "1.5LT"}', 'AGUA-MINERAL-HEAL-BLB0', 0.55, 0.00, 100, NULL, NULL, 'Volumen: 1.5LT - Agua Mineral Heal', 1, '2025-11-21 05:13:57', '2025-11-28 00:33:32'),
	(308, 204, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'AGUA-MINERAL-HEAL-BLB0', 0.85, 0.00, 80, NULL, NULL, 'Volumen: 1.5L - Agua Mineral Heal', 1, '2025-11-21 05:13:57', '2025-11-28 00:33:32'),
	(309, 204, 'Volumen: 2L', '{"Volumen": "5LT"}', 'AGUA-MINERAL-HEAL-BLB0', 1.15, 0.00, 70, NULL, NULL, 'Volumen: 5LT - Agua Mineral Heal', 1, '2025-11-21 05:13:57', '2025-11-28 00:33:32'),
	(310, 205, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-GOL-COL-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Golden Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(311, 205, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-GOL-COL-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Golden Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(312, 205, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-GOL-COL-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Golden Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(313, 205, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-GOL-COL-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Golden Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(314, 205, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-GOL-COL-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Golden Colita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(315, 206, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-GOL-PIN-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Golden Piña', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(316, 206, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-GOL-PIN-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Golden Piña', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(317, 206, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-GOL-PIN-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Golden Piña', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(318, 206, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-GOL-PIN-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Golden Piña', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(319, 206, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-GOL-PIN-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Golden Piña', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(320, 207, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-GOL-MAN-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Golden Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(321, 207, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-GOL-MAN-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Golden Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(322, 207, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-GOL-MAN-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Golden Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(323, 207, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-GOL-MAN-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Golden Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(324, 207, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-GOL-MAN-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Golden Manzana', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(325, 208, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-GOL-7UP-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Golden 7UP', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(326, 208, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-GOL-7UP-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Golden 7UP', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(327, 208, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-GOL-7UP-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Golden 7UP', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(328, 208, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-GOL-7UP-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Golden 7UP', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(329, 208, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-GOL-7UP-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Golden 7UP', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(330, 209, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-FRE-350', 0.00, NULL, 110, NULL, NULL, 'Volumen: 350ml - Refresco Frescolita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(331, 209, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-FRE-500', 0.35, NULL, 90, NULL, NULL, 'Volumen: 500ml - Refresco Frescolita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(332, 209, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-FRE-1L', 0.75, NULL, 70, NULL, NULL, 'Volumen: 1L - Refresco Frescolita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(333, 209, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-FRE-1.5L', 1.15, NULL, 50, NULL, NULL, 'Volumen: 1.5L - Refresco Frescolita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(334, 209, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-FRE-2L', 1.55, NULL, 40, NULL, NULL, 'Volumen: 2L - Refresco Frescolita', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(335, 210, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-CHI-350', 0.00, NULL, 100, NULL, NULL, 'Volumen: 350ml - Refresco Chinotto', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(336, 210, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-CHI-500', 0.35, NULL, 80, NULL, NULL, 'Volumen: 500ml - Refresco Chinotto', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(337, 210, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-CHI-1L', 0.75, NULL, 60, NULL, NULL, 'Volumen: 1L - Refresco Chinotto', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(338, 210, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-CHI-1.5L', 1.15, NULL, 45, NULL, NULL, 'Volumen: 1.5L - Refresco Chinotto', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(339, 210, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-CHI-2L', 1.55, NULL, 35, NULL, NULL, 'Volumen: 2L - Refresco Chinotto', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(340, 211, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-HIT-NAR-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Hit Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(341, 211, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-HIT-NAR-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Hit Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(342, 211, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-HIT-NAR-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Hit Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(343, 211, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-HIT-NAR-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Hit Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(344, 211, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-HIT-NAR-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Hit Naranja', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(345, 212, 'Volumen: 350ml', '{"Volumen": "350ml"}', 'REF-HIT-UVA-350', 0.00, NULL, 120, NULL, NULL, 'Volumen: 350ml - Refresco Hit Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(346, 212, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'REF-HIT-UVA-500', 0.35, NULL, 100, NULL, NULL, 'Volumen: 500ml - Refresco Hit Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(347, 212, 'Volumen: 1L', '{"Volumen": "1L"}', 'REF-HIT-UVA-1L', 0.75, NULL, 80, NULL, NULL, 'Volumen: 1L - Refresco Hit Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(348, 212, 'Volumen: 1.5L', '{"Volumen": "1.5L"}', 'REF-HIT-UVA-1.5L', 1.15, NULL, 60, NULL, NULL, 'Volumen: 1.5L - Refresco Hit Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(349, 212, 'Volumen: 2L', '{"Volumen": "2L"}', 'REF-HIT-UVA-2L', 1.55, NULL, 50, NULL, NULL, 'Volumen: 2L - Refresco Hit Uva', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(352, 215, 'Peso: 160g', '{"Peso: 160g": "160g"}', 'DORITOS-MEGA-QUESO-2FYD', 0.00, 0.00, 70, NULL, NULL, 'Peso: 160g - Doritos Mega Queso', 1, '2025-11-21 05:13:57', '2025-11-28 01:35:17'),
	(353, 216, 'Peso: 50g', '{"Peso: 50g": "50g"}', 'CHEESE-TRIS-50G-JDXF', 0.00, 0.00, 100, NULL, NULL, 'Peso: 50g - Cheese Tris 50g', 1, '2025-11-21 05:13:57', '2025-11-28 01:36:55'),
	(354, 217, 'Peso: 80g', '{"Peso: 80g": "80g"}', 'PUFFY-SABOR-A-PIMIENTA-CON-LIMON-R2JD', 0.00, 0.00, 90, NULL, NULL, 'Peso: 80g - Puffy Sabor a Pimienta con Limón', 1, '2025-11-21 05:13:57', '2025-11-28 02:46:45'),
	(355, 218, 'Peso: 80g', '{"Peso: 80g": "80g"}', 'PUFFY-SABOR-A-QUESO-TZUX', 0.00, 0.00, 90, NULL, NULL, 'Peso: 80g - Puffy Sabor a Queso', 1, '2025-11-21 05:13:57', '2025-11-28 02:46:22'),
	(356, 219, 'Peso: 80g', '{"Peso: 80g": "80g"}', 'PUFFY-SABOR-A-TOMATE-CON-ALBAHACA-VRVS', 0.00, 0.00, 85, NULL, NULL, 'Peso: 80g - Puffy Sabor a Tomate con Albahaca', 1, '2025-11-21 05:13:57', '2025-11-28 02:45:52'),
	(357, 220, 'Peso: 100g', '{"Peso: 100g": "100g"}', 'SALTITACOS-X4O5', 0.00, 0.00, 80, NULL, NULL, 'Peso: 100g - Saltitacos', 1, '2025-11-21 05:13:57', '2025-11-28 02:51:01'),
	(358, 221, 'Peso: 140g', '{"Peso": "140g"}', 'LAY-CLA-140', 0.00, NULL, 90, NULL, NULL, 'Peso: 140g - Lays Clásicas', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(359, 222, 'Peso: 140g', '{"Peso": "140g"}', 'LAY-LIM-140', 0.00, NULL, 85, NULL, NULL, 'Peso: 140g - Lays Limón', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(360, 223, 'Peso: 150g', '{"Peso": "150g"}', 'RUF-ORI-150', 0.00, NULL, 80, NULL, NULL, 'Peso: 150g - Ruffles Original', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(361, 224, 'Peso: 150g', '{"Peso": "150g"}', 'RUF-QUE-150', 0.00, NULL, 75, NULL, NULL, 'Peso: 150g - Ruffles Queso y Cebolla', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(362, 225, 'Peso: 130g', '{"Peso": "130g"}', 'CHE-CRU-130', 0.00, NULL, 85, NULL, NULL, 'Peso: 130g - Cheetos Crunchy', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(363, 226, 'Peso: 130g', '{"Peso": "130g"}', 'CHE-FLA-130', 0.00, NULL, 80, NULL, NULL, 'Peso: 130g - Cheetos Flamin Hot', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(364, 227, 'Peso: 154g', '{"Peso": "154g"}', 'ORE-ORI-154', 0.00, NULL, 70, NULL, NULL, 'Peso: 154g - Oreo Original', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(365, 228, 'Peso: 154g', '{"Peso": "154g"}', 'ORE-GOL-154', 0.00, NULL, 65, NULL, NULL, 'Peso: 154g - Oreo Golden', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(366, 229, 'Peso: 200g', '{"Peso": "200g"}', 'RIT-ORI-200', 0.00, NULL, 75, NULL, NULL, 'Peso: 200g - Ritz Crackers Original', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(367, 230, 'Peso: 200g', '{"Peso": "200g"}', 'RIT-QUE-200', 0.00, NULL, 70, NULL, NULL, 'Peso: 200g - Ritz Crackers Queso', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(368, 231, 'Peso: 350g', '{"Peso": "350g"}', 'KEL-COR-350', 0.00, NULL, 60, NULL, NULL, 'Peso: 350g - Corn Flakes Kelloggs', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(369, 232, 'Peso: 345g', '{"Peso": "345g"}', 'KEL-FRO-345', 0.00, NULL, 55, NULL, NULL, 'Peso: 345g - Froot Loops Kelloggs', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(370, 233, 'Peso: 380g', '{"Peso": "380g"}', 'KEL-SPE-380', 0.00, NULL, 50, NULL, NULL, 'Peso: 380g - Special K Kelloggs', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(371, 234, 'Peso: 400g', '{"Peso": "400g"}', 'QUA-AVE-400', 0.00, NULL, 80, NULL, NULL, 'Peso: 400g - Avena Quaker Original', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(372, 235, 'Peso: 400g', '{"Peso": "400g"}', 'QUA-CAN-400', 0.00, NULL, 75, NULL, NULL, 'Peso: 400g - Avena Quaker Canela', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(373, 236, 'Peso: 400g', '{"Peso": "400g"}', 'NES-CHO-400', 0.00, NULL, 65, NULL, NULL, 'Peso: 400g - Nesquik Chocolate', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(374, 237, 'Peso: 400g', '{"Peso": "400g"}', 'NES-FRE-400', 0.00, NULL, 60, NULL, NULL, 'Peso: 400g - Nesquik Fresa', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(375, 238, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-REX-ANT-110', 0.00, NULL, 90, NULL, NULL, 'Peso: 110g - Jabón de Baño Rexona Antibacterial', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(376, 239, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-REX-ALO-110', 0.00, NULL, 85, NULL, NULL, 'Peso: 110g - Jabón de Baño Rexona Aloe Vera', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(377, 240, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-REX-GLI-110', 0.00, NULL, 85, NULL, NULL, 'Peso: 110g - Jabón de Baño Rexona Glicerina', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(378, 241, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-REX-AVE-110', 0.00, NULL, 80, NULL, NULL, 'Peso: 110g - Jabón de Baño Rexona Avena', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(379, 242, 'Peso: 110g', '{"Peso": "110g"}', 'JAB-REX-COC-110', 0.00, NULL, 80, NULL, NULL, 'Peso: 110g - Jabón de Baño Rexona Coco', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(380, 243, 'Pack: 8 unidades x 110g', '{"Pack": "8 unidades x 110g"}', 'JAB-REX-SUR-8X110', 0.00, NULL, 40, NULL, NULL, 'Pack: 8 unidades x 110g - Jabón de Baño Rexona Surtidos 8x110g', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(381, 244, 'Talla: P', '{"Talla: P": "P"}', 'PANALES-BABY-FINGER-P-OIO9', 0.00, 0.00, 40, NULL, NULL, 'Talla: P - Pañales Baby Finger P', 1, '2025-11-21 05:13:57', '2025-11-28 02:13:52'),
	(382, 245, 'Talla: M', '{"Talla: M": "M"}', 'PANALES-BABY-FINGER-M-DFLO', 0.00, 0.00, 40, NULL, NULL, 'Talla: M - Pañales Baby Finger M', 1, '2025-11-21 05:13:57', '2025-11-28 02:15:24'),
	(383, 246, 'Talla: G', '{"Talla: G": "G"}', 'PANALES-BABY-FINGER-G-VW9W', 0.00, 0.00, 40, NULL, NULL, 'Talla: G - Pañales Baby Finger G', 1, '2025-11-21 05:13:57', '2025-11-28 02:16:19'),
	(384, 247, 'Talla: RN', '{"Talla: RN": "RN"}', 'PANALES-BABY-FINGER-RN-TOPX', 0.00, 0.00, 40, NULL, NULL, 'Talla: RN - Pañales Baby Finger RN', 1, '2025-11-21 05:13:57', '2025-11-28 02:16:53'),
	(385, 248, 'Talla: XXG', '{"Talla: XXG": "XXG"}', 'PANALES-BABY-FINGER-XXG-JJF0', 0.00, 0.00, 40, NULL, NULL, 'Talla: XXG - Pañales Baby Finger XXG', 1, '2025-11-21 05:13:57', '2025-11-28 02:17:15'),
	(386, 249, 'Pack: 10 x 20', '{"Pack: 10 x 20": "10 x 20"}', 'PANALES-HUGME-P-LASC', 0.00, 0.00, 30, NULL, NULL, 'Pack: 10 x 20 - Pañales Hugme P', 1, '2025-11-21 05:13:57', '2025-11-28 02:22:33'),
	(388, 250, 'Pack: 10 x 20', '{"Pack: 10 x 20": "10 x 20"}', 'PANALES-HUGME-M-TSAB', 0.00, 0.00, 30, NULL, NULL, 'Pack: 10 x 20 - Pañales Hugme M', 1, '2025-11-21 05:13:57', '2025-11-28 02:23:07'),
	(390, 251, 'Pack: 10 x 20', '{"Pack: 10 x 20": "10 x 20"}', 'PANALES-HUGME-G-NC7X', 0.00, 0.00, 30, NULL, NULL, 'Pack: 10 x 20 - Pañales Hugme G', 1, '2025-11-21 05:13:57', '2025-11-28 02:26:07'),
	(392, 252, 'Pack: 10 x 20', '{"Pack: 10 x 20": "10 x 20"}', 'PANALES-HUGME-XG-NKWW', 0.00, 0.00, 30, NULL, NULL, 'Pack: 10 x 20 - Pañales Hugme XG', 1, '2025-11-21 05:13:57', '2025-11-28 02:27:04'),
	(394, 253, 'Pack: 10 x 24', '{"Pack: 10 x 24": "10 x 24"}', 'PANALES-HUGME-RN-Y1VR', 0.00, 0.00, 25, NULL, NULL, 'Pack: 10 x 24 - Pañales Hugme RN', 1, '2025-11-21 05:13:57', '2025-11-28 02:28:02'),
	(396, 254, 'Pack: 80 und', '{"Pack": "80 und"}', 'TOA-HUG-80', 0.00, NULL, 60, NULL, NULL, 'Pack: 80 und - Toallitas Húmedas Hugme', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(397, 254, 'Pack: 160 und', '{"Pack": "160 und"}', 'TOA-HUG-160', 2.75, NULL, 40, NULL, NULL, 'Pack: 160 und - Toallitas Húmedas Hugme', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(398, 255, 'Volumen: 200ml', '{"Volumen": "200ml"}', 'SHA-HUG-200', 0.00, NULL, 45, NULL, NULL, 'Volumen: 200ml - Shampoo Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(399, 255, 'Volumen: 400ml', '{"Volumen": "400ml"}', 'SHA-HUG-400', 3.50, NULL, 30, NULL, NULL, 'Volumen: 400ml - Shampoo Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(400, 256, 'Volumen: 250ml', '{"Volumen": "250ml"}', 'JAB-HUG-250', 0.00, NULL, 50, NULL, NULL, 'Volumen: 250ml - Jabón Líquido Hugme', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(401, 256, 'Volumen: 500ml', '{"Volumen": "500ml"}', 'JAB-HUG-500', 3.75, NULL, 35, NULL, NULL, 'Volumen: 500ml - Jabón Líquido Hugme', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(402, 257, 'Peso: 100g', '{"Peso": "100g"}', 'CRE-HUG-100', 0.00, NULL, 40, NULL, NULL, 'Peso: 100g - Crema Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(403, 257, 'Peso: 200g', '{"Peso": "200g"}', 'CRE-HUG-200', 4.25, NULL, 25, NULL, NULL, 'Peso: 200g - Crema Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(404, 258, 'Volumen: 100ml', '{"Volumen": "100ml"}', 'ACE-HUG-100', 0.00, NULL, 55, NULL, NULL, 'Volumen: 100ml - Aceite Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(405, 258, 'Volumen: 200ml', '{"Volumen": "200ml"}', 'ACE-HUG-200', 2.50, NULL, 35, NULL, NULL, 'Volumen: 200ml - Aceite Hugme Bebé', 1, '2025-11-21 05:13:57', '2025-11-21 05:13:57'),
	(406, 83, 'size', '"[]"', 'TOALLAS-ALIVE-DIARIA-S8TK', 0.00, 0.00, 0, NULL, NULL, '', 1, '2025-11-27 23:26:19', '2025-11-27 23:26:19'),
	(407, 272, 'volumen', '{"Volumen": "100 ML"}', 'ACEITE-IDEAL-MVXK', 0.00, 0.00, 0, 'public/productos/272/variants/1764291958_variant_0.jpg', 'public/productos/272/variants/thumb_1764291958_variant_0.jpg', 'Volumen: Aceite comestible Ideal 100 ML', 1, '2025-11-28 00:46:40', '2025-11-28 01:08:45'),
	(408, 272, 'volumen', '{"Volumen": "250 ML"}', 'ACEITE-IDEAL-MVXK', 0.00, 0.00, 0, 'public/productos/272/variants/1764292125_variant_1.jpg', 'public/productos/272/variants/thumb_1764292125_variant_1.jpg', 'Volumen: Aceite comestible Ideal 250 ML', 1, '2025-11-28 00:46:40', '2025-11-28 01:08:45'),
	(409, 272, 'volumen', '{"Volumen": "430 ML"}', 'ACEITE-IDEAL-MVXK', 0.00, 0.00, 0, 'public/productos/272/variants/1764292125_variant_2.jpg', 'public/productos/272/variants/thumb_1764292125_variant_2.jpg', 'Volumen: Aceite comestible Ideal 430 ML', 1, '2025-11-28 00:46:40', '2025-11-28 01:08:45'),
	(410, 272, 'volumen', '{"Volumen": "900 ML"}', 'ACEITE-IDEAL-MVXK', 0.00, 0.00, 0, 'public/productos/272/variants/1764292125_variant_3.jpg', 'public/productos/272/variants/thumb_1764292125_variant_3.jpg', 'Volumen: Aceite comestible Ideal 900 ML', 1, '2025-11-28 00:46:40', '2025-11-28 01:08:45'),
	(411, 86, 'size', '"{\\"Size\\":\\"450 Ml\\"}"', 'OSO-BLANCO-LAVAVAJILLAS-RVHS', 0.00, 0.00, 0, 'public/productos/86/variants/1764292971_variant_0.jpg', 'public/productos/86/variants/thumb_1764292971_variant_0.jpg', 'Presentacion: 450 Ml  Oso Blanco Lavavajillas', 1, '2025-11-28 01:22:51', '2025-11-28 01:22:51'),
	(412, 86, 'size', '"{\\"Size\\":\\"800 ML\\"}"', 'OSO-BLANCO-LAVAVAJILLAS-RVHS', 0.00, 0.00, 0, 'public/productos/86/variants/1764292971_variant_1.jpg', 'public/productos/86/variants/thumb_1764292971_variant_1.jpg', 'Presentacion: 800 ML Oso Blanco Lavavajillas', 1, '2025-11-28 01:22:51', '2025-11-28 01:22:51'),
	(413, 151, 'volumen', '"{\\"Volumen\\":\\"1.5Lt\\"}"', 'AGUA-MINALBA-600ML-GJ2R', 0.00, 0.00, 0, 'public/productos/151/variants/1764299474_variant_1.jpg', 'public/productos/151/variants/thumb_1764299474_variant_1.jpg', 'Volumen: 1.5Lt - Agua Minalba 1.5Lt', 1, '2025-11-28 03:11:14', '2025-11-28 03:11:14'),
	(414, 151, '', '"{\\"\\":\\"5Lt\\"}"', 'AGUA-MINALBA-600ML-GJ2R', 0.00, 0.00, 0, 'public/productos/151/variants/1764299474_variant_2.jpg', 'public/productos/151/variants/thumb_1764299474_variant_2.jpg', 'Volumen: 5Lt - Agua Minalba 5Lt', 1, '2025-11-28 03:11:14', '2025-11-28 03:11:14');

-- Volcando estructura para tabla laravel.product_reviews
DROP TABLE IF EXISTS `product_reviews`;
CREATE TABLE IF NOT EXISTS `product_reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` tinyint unsigned NOT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `verified_purchase` tinyint(1) NOT NULL DEFAULT '0',
  `is_approved` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_reviews_producto_id_user_id_unique` (`producto_id`,`user_id`),
  KEY `product_reviews_user_id_foreign` (`user_id`),
  KEY `product_reviews_producto_id_is_approved_index` (`producto_id`,`is_approved`),
  CONSTRAINT `product_reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `product_reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.product_reviews: ~0 rows (aproximadamente)
DELETE FROM `product_reviews`;

-- Volcando estructura para tabla laravel.referencias_bancarias
DROP TABLE IF EXISTS `referencias_bancarias`;
CREATE TABLE IF NOT EXISTS `referencias_bancarias` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `tipo_pago` enum('pago_movil','transferencia') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `banco_id` bigint unsigned NOT NULL,
  `documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `numero_cuenta` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `tipo_cuenta` enum('ahorro','corriente') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `referencia` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `monto_efectivo` decimal(10,2) DEFAULT NULL,
  `monto_restante` decimal(10,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `referencias_bancarias_pedido_id_foreign` (`pedido_id`),
  KEY `referencias_bancarias_banco_id_foreign` (`banco_id`),
  CONSTRAINT `referencias_bancarias_banco_id_foreign` FOREIGN KEY (`banco_id`) REFERENCES `bancos` (`id`),
  CONSTRAINT `referencias_bancarias_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.referencias_bancarias: ~0 rows (aproximadamente)
DELETE FROM `referencias_bancarias`;

-- Volcando estructura para tabla laravel.resenas
DROP TABLE IF EXISTS `resenas`;
CREATE TABLE IF NOT EXISTS `resenas` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `pedido_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `producto_id` bigint unsigned NOT NULL,
  `calificacion` tinyint unsigned NOT NULL COMMENT '1-5 estrellas',
  `comentario` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `aprobada` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `resenas_user_id_foreign` (`user_id`),
  KEY `resenas_producto_id_foreign` (`producto_id`),
  KEY `resenas_pedido_id_producto_id_index` (`pedido_id`,`producto_id`),
  KEY `resenas_calificacion_index` (`calificacion`),
  KEY `resenas_aprobada_index` (`aprobada`),
  CONSTRAINT `resenas_pedido_id_foreign` FOREIGN KEY (`pedido_id`) REFERENCES `pedidos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `resenas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.resenas: ~0 rows (aproximadamente)
DELETE FROM `resenas`;

-- Volcando estructura para tabla laravel.reunions
DROP TABLE IF EXISTS `reunions`;
CREATE TABLE IF NOT EXISTS `reunions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `titulo` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `descripcion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `fecha_inicio` datetime NOT NULL,
  `fecha_fin` datetime NOT NULL,
  `ubicacion` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estado` enum('programada','en_curso','finalizada','cancelada') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'programada',
  `color` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#007bff',
  `participantes` json DEFAULT NULL,
  `creado_por` bigint unsigned NOT NULL,
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reunions_creado_por_foreign` (`creado_por`),
  KEY `reunions_empresa_id_foreign` (`empresa_id`),
  KEY `reunions_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `reunions_creado_por_foreign` FOREIGN KEY (`creado_por`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reunions_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.reunions: ~0 rows (aproximadamente)
DELETE FROM `reunions`;

-- Volcando estructura para tabla laravel.reviews
DROP TABLE IF EXISTS `reviews`;
CREATE TABLE IF NOT EXISTS `reviews` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `rating` int unsigned NOT NULL DEFAULT '5',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `empresa_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `reviews_empresa_id_foreign` (`empresa_id`),
  KEY `reviews_producto_id_approved_index` (`producto_id`,`approved`),
  KEY `reviews_user_id_index` (`user_id`),
  CONSTRAINT `reviews_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reviews_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.reviews: ~0 rows (aproximadamente)
DELETE FROM `reviews`;

-- Volcando estructura para tabla laravel.roles
DROP TABLE IF EXISTS `roles`;
CREATE TABLE IF NOT EXISTS `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.roles: ~5 rows (aproximadamente)
DELETE FROM `roles`;
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'Super Administrador', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(2, 'Administrador', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(3, 'Recepcionista', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(4, 'Cliente', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02'),
	(5, 'Empleado', 'web', '2025-11-26 14:20:02', '2025-11-26 14:20:02');

-- Volcando estructura para tabla laravel.role_has_permissions
DROP TABLE IF EXISTS `role_has_permissions`;
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.role_has_permissions: ~391 rows (aproximadamente)
DELETE FROM `role_has_permissions`;
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(1, 1),
	(2, 1),
	(3, 1),
	(4, 1),
	(5, 1),
	(6, 1),
	(7, 1),
	(8, 1),
	(9, 1),
	(10, 1),
	(11, 1),
	(12, 1),
	(13, 1),
	(14, 1),
	(15, 1),
	(16, 1),
	(17, 1),
	(18, 1),
	(19, 1),
	(20, 1),
	(21, 1),
	(22, 1),
	(23, 1),
	(24, 1),
	(25, 1),
	(26, 1),
	(27, 1),
	(28, 1),
	(29, 1),
	(30, 1),
	(31, 1),
	(32, 1),
	(33, 1),
	(34, 1),
	(35, 1),
	(36, 1),
	(37, 1),
	(38, 1),
	(39, 1),
	(40, 1),
	(41, 1),
	(42, 1),
	(43, 1),
	(44, 1),
	(45, 1),
	(46, 1),
	(47, 1),
	(48, 1),
	(49, 1),
	(50, 1),
	(51, 1),
	(52, 1),
	(53, 1),
	(54, 1),
	(55, 1),
	(56, 1),
	(57, 1),
	(58, 1),
	(59, 1),
	(60, 1),
	(61, 1),
	(62, 1),
	(63, 1),
	(64, 1),
	(65, 1),
	(66, 1),
	(67, 1),
	(68, 1),
	(69, 1),
	(70, 1),
	(71, 1),
	(72, 1),
	(73, 1),
	(74, 1),
	(75, 1),
	(76, 1),
	(77, 1),
	(78, 1),
	(79, 1),
	(80, 1),
	(81, 1),
	(82, 1),
	(83, 1),
	(84, 1),
	(85, 1),
	(86, 1),
	(87, 1),
	(88, 1),
	(89, 1),
	(90, 1),
	(91, 1),
	(92, 1),
	(93, 1),
	(94, 1),
	(95, 1),
	(96, 1),
	(97, 1),
	(98, 1),
	(99, 1),
	(100, 1),
	(101, 1),
	(102, 1),
	(103, 1),
	(104, 1),
	(105, 1),
	(106, 1),
	(107, 1),
	(108, 1),
	(109, 1),
	(110, 1),
	(111, 1),
	(112, 1),
	(113, 1),
	(114, 1),
	(115, 1),
	(116, 1),
	(117, 1),
	(118, 1),
	(119, 1),
	(120, 1),
	(121, 1),
	(122, 1),
	(123, 1),
	(124, 1),
	(125, 1),
	(126, 1),
	(127, 1),
	(128, 1),
	(129, 1),
	(130, 1),
	(131, 1),
	(132, 1),
	(133, 1),
	(134, 1),
	(135, 1),
	(136, 1),
	(137, 1),
	(138, 1),
	(139, 1),
	(140, 1),
	(141, 1),
	(142, 1),
	(143, 1),
	(144, 1),
	(145, 1),
	(146, 1),
	(147, 1),
	(148, 1),
	(149, 1),
	(150, 1),
	(151, 1),
	(152, 1),
	(153, 1),
	(154, 1),
	(155, 1),
	(156, 1),
	(157, 1),
	(158, 1),
	(159, 1),
	(160, 1),
	(161, 1),
	(162, 1),
	(163, 1),
	(164, 1),
	(165, 1),
	(166, 1),
	(167, 1),
	(168, 1),
	(169, 1),
	(170, 1),
	(171, 1),
	(172, 1),
	(173, 1),
	(1, 2),
	(2, 2),
	(3, 2),
	(4, 2),
	(5, 2),
	(6, 2),
	(7, 2),
	(8, 2),
	(9, 2),
	(10, 2),
	(11, 2),
	(12, 2),
	(13, 2),
	(14, 2),
	(15, 2),
	(16, 2),
	(17, 2),
	(18, 2),
	(19, 2),
	(20, 2),
	(22, 2),
	(23, 2),
	(24, 2),
	(25, 2),
	(27, 2),
	(28, 2),
	(29, 2),
	(30, 2),
	(31, 2),
	(32, 2),
	(33, 2),
	(34, 2),
	(35, 2),
	(36, 2),
	(37, 2),
	(38, 2),
	(39, 2),
	(40, 2),
	(41, 2),
	(42, 2),
	(43, 2),
	(44, 2),
	(45, 2),
	(46, 2),
	(47, 2),
	(48, 2),
	(49, 2),
	(50, 2),
	(51, 2),
	(52, 2),
	(53, 2),
	(54, 2),
	(55, 2),
	(56, 2),
	(57, 2),
	(58, 2),
	(59, 2),
	(60, 2),
	(61, 2),
	(62, 2),
	(63, 2),
	(64, 2),
	(65, 2),
	(66, 2),
	(67, 2),
	(68, 2),
	(69, 2),
	(70, 2),
	(71, 2),
	(72, 2),
	(73, 2),
	(74, 2),
	(75, 2),
	(76, 2),
	(77, 2),
	(78, 2),
	(79, 2),
	(80, 2),
	(81, 2),
	(82, 2),
	(83, 2),
	(84, 2),
	(85, 2),
	(86, 2),
	(87, 2),
	(88, 2),
	(89, 2),
	(90, 2),
	(91, 2),
	(92, 2),
	(93, 2),
	(94, 2),
	(95, 2),
	(96, 2),
	(97, 2),
	(98, 2),
	(99, 2),
	(100, 2),
	(101, 2),
	(102, 2),
	(103, 2),
	(104, 2),
	(105, 2),
	(106, 2),
	(107, 2),
	(108, 2),
	(109, 2),
	(110, 2),
	(111, 2),
	(112, 2),
	(113, 2),
	(114, 2),
	(115, 2),
	(116, 2),
	(117, 2),
	(118, 2),
	(119, 2),
	(120, 2),
	(121, 2),
	(122, 2),
	(123, 2),
	(124, 2),
	(125, 2),
	(126, 2),
	(127, 2),
	(128, 2),
	(129, 2),
	(130, 2),
	(131, 2),
	(132, 2),
	(133, 2),
	(134, 2),
	(135, 2),
	(136, 2),
	(137, 2),
	(138, 2),
	(139, 2),
	(140, 2),
	(141, 2),
	(142, 2),
	(143, 2),
	(144, 2),
	(145, 2),
	(146, 2),
	(147, 2),
	(148, 2),
	(149, 2),
	(150, 2),
	(151, 2),
	(152, 2),
	(153, 2),
	(154, 2),
	(155, 2),
	(156, 2),
	(157, 2),
	(158, 2),
	(159, 2),
	(160, 2),
	(161, 2),
	(162, 2),
	(163, 2),
	(164, 2),
	(165, 2),
	(166, 2),
	(167, 2),
	(168, 2),
	(169, 2),
	(170, 2),
	(171, 2),
	(172, 2),
	(173, 2),
	(43, 3),
	(44, 3),
	(45, 3),
	(46, 3),
	(47, 3),
	(48, 3),
	(49, 3),
	(50, 3),
	(69, 3),
	(70, 3),
	(71, 3),
	(72, 3),
	(73, 3),
	(74, 3),
	(75, 3),
	(76, 3),
	(77, 3),
	(78, 3),
	(79, 3),
	(137, 4),
	(138, 4),
	(139, 4),
	(140, 4),
	(141, 4),
	(142, 4),
	(143, 4),
	(144, 4),
	(145, 4),
	(146, 4),
	(147, 4),
	(148, 4),
	(149, 4),
	(150, 4),
	(151, 4),
	(137, 5),
	(138, 5),
	(139, 5),
	(140, 5),
	(141, 5),
	(142, 5),
	(143, 5),
	(144, 5),
	(145, 5),
	(146, 5),
	(147, 5),
	(148, 5),
	(149, 5);

-- Volcando estructura para tabla laravel.series
DROP TABLE IF EXISTS `series`;
CREATE TABLE IF NOT EXISTS `series` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tipo_documento` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `serie` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `correlativo_actual` int NOT NULL DEFAULT '0',
  `longitud_correlativo` int NOT NULL DEFAULT '8',
  `activo` tinyint(1) NOT NULL DEFAULT '1',
  `empresa_id` bigint unsigned NOT NULL,
  `sucursal_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `series_serie_empresa_id_sucursal_id_unique` (`serie`,`empresa_id`,`sucursal_id`),
  KEY `series_empresa_id_foreign` (`empresa_id`),
  KEY `series_sucursal_id_foreign` (`sucursal_id`),
  KEY `series_tipo_documento_empresa_id_sucursal_id_activo_index` (`tipo_documento`,`empresa_id`,`sucursal_id`,`activo`),
  CONSTRAINT `series_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `series_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.series: ~4 rows (aproximadamente)
DELETE FROM `series`;
INSERT INTO `series` (`id`, `tipo_documento`, `serie`, `correlativo_actual`, `longitud_correlativo`, `activo`, `empresa_id`, `sucursal_id`, `created_at`, `updated_at`) VALUES
	(1, 'factura', '7', 0, 8, 1, 1, 1, '2025-11-26 14:20:03', '2025-11-27 14:19:31'),
	(2, 'boleta', 'B001', 0, 8, 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(3, 'nota_credito', 'NC01', 0, 8, 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03'),
	(4, 'recibo', 'R001', 0, 8, 1, 1, 1, '2025-11-26 14:20:03', '2025-11-26 14:20:03');

-- Volcando estructura para tabla laravel.sessions
DROP TABLE IF EXISTS `sessions`;
CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.sessions: ~2 rows (aproximadamente)
DELETE FROM `sessions`;
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
	('LcHSbQmpzfsgc64cjhZJp1NrNqtzZOpwDnwrHGK9', 2, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/142.0.0.0 Safari/537.36', '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', 1764352292);

-- Volcando estructura para tabla laravel.sucursales
DROP TABLE IF EXISTS `sucursales`;
CREATE TABLE IF NOT EXISTS `sucursales` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `empresa_id` bigint unsigned NOT NULL,
  `nombre` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `direccion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `latitud` decimal(10,8) DEFAULT NULL,
  `longitud` decimal(11,8) DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sucursales_empresa_id_foreign` (`empresa_id`),
  CONSTRAINT `sucursales_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.sucursales: ~0 rows (aproximadamente)
DELETE FROM `sucursales`;
INSERT INTO `sucursales` (`id`, `empresa_id`, `nombre`, `telefono`, `direccion`, `latitud`, `longitud`, `status`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Sucursal Devtechvnzla C.A', '1234567890', 'Av. Principal 123', NULL, NULL, 1, '2025-11-26 14:20:02', '2025-11-26 14:20:02');

-- Volcando estructura para tabla laravel.template_customizations
DROP TABLE IF EXISTS `template_customizations`;
CREATE TABLE IF NOT EXISTS `template_customizations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `primary_color` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#7367F0',
  `skin` int NOT NULL DEFAULT '0',
  `theme` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `semi_dark` tinyint(1) NOT NULL DEFAULT '0',
  `content_layout` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'compact',
  `header_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'static',
  `menu_collapsed` tinyint(1) NOT NULL DEFAULT '0',
  `navbar_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sticky',
  `text_direction` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'ltr',
  `footer_fixed` tinyint(1) NOT NULL DEFAULT '0',
  `dropdown_on_hover` tinyint(1) NOT NULL DEFAULT '0',
  `layout_type` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'vertical',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.template_customizations: ~0 rows (aproximadamente)
DELETE FROM `template_customizations`;
INSERT INTO `template_customizations` (`id`, `primary_color`, `skin`, `theme`, `semi_dark`, `content_layout`, `header_type`, `menu_collapsed`, `navbar_type`, `text_direction`, `footer_fixed`, `dropdown_on_hover`, `layout_type`, `created_at`, `updated_at`) VALUES
	(1, '#7367F0', 0, 'light', 1, 'compact', 'static', 0, 'sticky', 'ltr', 0, 0, 'horizontal', '2025-11-26 14:20:03', '2025-11-27 15:16:35');

-- Volcando estructura para tabla laravel.users
DROP TABLE IF EXISTS `users`;
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `bio` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notifications_email` tinyint(1) NOT NULL DEFAULT '1',
  `notifications_sms` tinyint(1) NOT NULL DEFAULT '0',
  `notifications_push` tinyint(1) NOT NULL DEFAULT '1',
  `telefono` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `verification_code` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `two_factor_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` json DEFAULT NULL,
  `two_factor_enabled` tinyint(1) NOT NULL DEFAULT '0',
  `verification_code_sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `empresa_id` bigint unsigned DEFAULT NULL,
  `sucursal_id` bigint unsigned DEFAULT NULL,
  `avatar` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `preferred_devices` json DEFAULT NULL,
  `common_locations` json DEFAULT NULL,
  `total_session_time` int NOT NULL DEFAULT '0',
  `security_alerts` json DEFAULT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `api_token` varchar(80) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  UNIQUE KEY `users_api_token_unique` (`api_token`),
  KEY `users_empresa_id_foreign` (`empresa_id`),
  KEY `users_sucursal_id_foreign` (`sucursal_id`),
  CONSTRAINT `users_empresa_id_foreign` FOREIGN KEY (`empresa_id`) REFERENCES `empresas` (`id`) ON DELETE SET NULL,
  CONSTRAINT `users_sucursal_id_foreign` FOREIGN KEY (`sucursal_id`) REFERENCES `sucursales` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.users: ~10 rows (aproximadamente)
DELETE FROM `users`;
INSERT INTO `users` (`id`, `name`, `username`, `email`, `phone`, `address`, `bio`, `notifications_email`, `notifications_sms`, `notifications_push`, `telefono`, `verification_code`, `email_verified_at`, `password`, `remember_token`, `two_factor_secret`, `two_factor_recovery_codes`, `two_factor_enabled`, `verification_code_sent_at`, `created_at`, `updated_at`, `empresa_id`, `sucursal_id`, `avatar`, `preferred_devices`, `common_locations`, `total_session_time`, `security_alerts`, `status`, `api_token`) VALUES
	(1, 'Super Admin Devtechvnzla C.A', 'superadmin', 'superadmin@devtechvnzla.com', NULL, NULL, NULL, 1, 0, 1, NULL, NULL, '2025-11-26 14:23:07', '$2y$12$5FEiT7Vq..0do0Qf/PP1quKFlIvij5sDo0obRXVIrivAL7a.LUrK6', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:02', '2025-11-26 19:22:48', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(2, 'Admin Devtechvnzla C.A', 'admin', 'admin@devtechvnzla.com', NULL, NULL, NULL, 1, 0, 1, NULL, NULL, '2025-11-26 14:23:07', '$2y$12$mDuL35jqDJsGYMXTA8E2Meti561q887CbPqlR0yScadPuiRHsFMVi', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:03', '2025-11-26 14:22:58', 1, 1, NULL, NULL, NULL, 0, NULL, 1, 'qOOem4yqyz5VgPTdY4We50XSSp38Lq4nBZsFMSIKb9ihrAsAoVcn2OotUEJ9fiSJXHoRbPuiI4SyY1Do'),
	(3, 'User Cliente Devtechvnzla C.A', 'usercliente', 'cliente@devtechvnzla.com', NULL, NULL, NULL, 1, 0, 1, '04242115948', NULL, '2025-11-26 14:23:06', '$2y$12$Hs5LCZJLaMxgmqpYwFMPYuxSbUkkQ9VIRuN2kKYRLXdLwYxmR8kdC', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:03', '2025-11-27 23:03:54', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(4, 'User Empleado Devtechvnzla C.A', 'userempleado', 'userempleado@devtechvnzla.com', NULL, NULL, NULL, 1, 0, 1, NULL, NULL, '2025-11-26 14:23:06', '$2y$12$ABp2rpZ8BWlGS4xPjll.2eBsCvQkdZHPdf6JCoIjK.XSQxVr8rI..', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:03', '2025-11-26 14:20:03', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(5, 'Carlos Rodríguez Pérez', 'crodríguez', 'carlos.rodriguez@empresa.com', NULL, NULL, NULL, 1, 0, 1, '0412-1234567', NULL, '2025-11-26 14:20:04', '$2y$12$U4nNsMEsUQGVfphiUHOCYeFtYVFIxQ8YSEVkuQAEZMckvVdLJOYI2', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:04', '2025-11-26 14:20:04', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(6, 'Ana González López', 'agonzález', 'ana.gonzalez@empresa.com', NULL, NULL, NULL, 1, 0, 1, '0414-7654321', NULL, '2025-11-26 14:20:04', '$2y$12$cfOMmOlHjkLATk.zY7NaweL6qE9D2iB64XbWzwx/sG1x5.eToXCm6', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:04', '2025-11-26 14:20:04', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(7, 'Luis Martínez Sánchez', 'lmartínez', 'luis.martinez@empresa.com', NULL, NULL, NULL, 1, 0, 1, '0426-9876543', NULL, '2025-11-26 14:20:05', '$2y$12$Chuzep2HMqMK4dkA3oqKaOa5eP4jkleVZi7ti1Fa2VUzWquGeqJtW', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(8, 'María Fernández Torres', 'mfernández', 'maria.fernandez@empresa.com', NULL, NULL, NULL, 1, 0, 1, '0412-5556677', NULL, '2025-11-26 14:20:05', '$2y$12$ZGVVnP7eVZbo1bsOs5bFBe3t8b4TCbQoBWQdOZpLR7CTS3pM6lFV2', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(9, 'Jorge Pérez Ramírez', 'jperez', 'jorge.perez@empresa.com', NULL, NULL, NULL, 1, 0, 1, '0424-3332211', NULL, '2025-11-26 14:20:05', '$2y$12$JRQzdxVtTZ0qKj.hR8CHsOVdFd3pGj9OxY0BENQSKCdFV71RrGhYG', NULL, NULL, NULL, 0, NULL, '2025-11-26 14:20:05', '2025-11-26 14:20:05', 1, 1, NULL, NULL, NULL, 0, NULL, 1, NULL),
	(11, 'Administrador', 'admin1', 'admin@example.com', NULL, NULL, NULL, 1, 0, 1, NULL, NULL, NULL, '$2y$12$a9OIhtaa5.lRCGMn9cpc3.inaOCtli3WOIL9sHk2td/ABOmxb/8Xq', NULL, NULL, NULL, 0, NULL, '2025-11-26 19:07:06', '2025-11-26 19:07:06', 1, 1, '1', NULL, NULL, 0, NULL, 1, NULL);

-- Volcando estructura para tabla laravel.wishlists
DROP TABLE IF EXISTS `wishlists`;
CREATE TABLE IF NOT EXISTS `wishlists` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `producto_id` bigint unsigned NOT NULL DEFAULT '1',
  `user_id` bigint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wishlists_user_id_producto_id_unique` (`user_id`,`producto_id`),
  KEY `wishlists_producto_id_foreign` (`producto_id`),
  CONSTRAINT `wishlists_producto_id_foreign` FOREIGN KEY (`producto_id`) REFERENCES `productos` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `wishlists_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Volcando datos para la tabla laravel.wishlists: ~0 rows (aproximadamente)
DELETE FROM `wishlists`;

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
