<?php

require_once 'vendor/autoload.php';

use App\Services\WhatsAppService;

$app = require_once 'bootstrap/app.php';
$app->make('Illuminate\Contracts\Console\Kernel')->bootstrap();

echo "📱 Verificando estado de WhatsApp...\n\n";

$whatsappService = new WhatsAppService();
$status = $whatsappService->getStatus();

echo "Estado: " . ($status['status'] ?? 'desconocido') . "\n";
echo "Listo: " . ($status['isReady'] ? 'Sí' : 'No') . "\n";

if (isset($status['qr']) && $status['qr']) {
    echo "✅ Código QR disponible\n";
    echo "👉 Ve al dashboard: http://localhost:8000/admin/whatsapp/dashboard\n";
    echo "📱 Escanea el código QR con WhatsApp\n";
} else {
    echo "⏳ Esperando código QR...\n";
    echo "👉 Ve al dashboard: http://localhost:8000/admin/whatsapp/dashboard\n";
}

echo "\n🔄 El QR se actualiza automáticamente cada 3 segundos\n";