<?php

$iconMap = [
    'ri ri-home-4-line' => 'ri ri-home',
    'ri ri-shopping-cart-2-line' => 'ri ri-cart',
    'ri ri-money-dollar-circle-line' => 'ri ri-currency-usd',
    'ri ri-file-list-3-line' => 'ri ri-file-document',
    'ri ri-exchange-dollar-line' => 'ri ri-currency-usd-circle',
    'ri ri-palette-line' => 'ri ri-palette',
    'ri ri-group-line' => 'ri ri-account-group',
    'ri ri-line-chart-line' => 'ri ri-chart-line',
    'ri ri-menu-line' => 'ri ri-menu',
    'ri ri-translate-2' => 'ri ri-translate',
    'ri ri-sun-line' => 'ri ri-weather-sunny',
    'ri ri-moon-clear-line' => 'ri ri-weather-night',
    'ri ri-computer-line' => 'ri ri-monitor',
    'ri ri-user-3-line' => 'ri ri-account',
    'ri ri-logout-box-r-line' => 'ri ri-logout',
    'ri ri-notification-2-line' => 'ri ri-bell',
    'ri ri-global-line' => 'ri ri-earth',
    'ri ri-add-line' => 'ri ri-plus',
    'ri ri-edit-line' => 'ri ri-pencil',
    'ri ri-delete-bin-line' => 'ri ri-delete',
    'ri ri-eye-line' => 'ri ri-eye',
    'ri ri-search-line' => 'ri ri-magnify',
    'ri ri-save-line' => 'ri ri-content-save',
    'ri ri-arrow-left-line' => 'ri ri-arrow-left',
    'ri ri-arrow-right-line' => 'ri ri-arrow-right',
    'ri ri-arrow-up-line' => 'ri ri-arrow-up',
    'ri ri-arrow-down-line' => 'ri ri-arrow-down',
    'ri ri-close-line' => 'ri ri-close',
    'ri ri-check-line' => 'ri ri-check',
    'ri ri-refresh-line' => 'ri ri-refresh'
];

function replaceInFile($file, $iconMap) {
    $content = file_get_contents($file);
    $changed = false;
    
    foreach ($iconMap as $old => $new) {
        if (strpos($content, $old) !== false) {
            $content = str_replace($old, $new, $content);
            $changed = true;
        }
    }
    
    if ($changed) {
        file_put_contents($file, $content);
        echo "Updated: $file\n";
    }
}

$directory = 'resources/views';
$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));

foreach ($iterator as $file) {
    if ($file->isFile() && $file->getExtension() === 'php') {
        replaceInFile($file->getPathname(), $iconMap);
    }
}

echo "Icon replacement completed!\n";