<?php

if (!function_exists('secure_storage_url')) {
    /**
     * Genera una URL segura para archivos de storage
     */
    function secure_storage_url($path)
    {
        if (!$path) {
            return null;
        }

        $url = Storage::url($path);
        
        // Si estamos en HTTPS, forzar HTTPS en la URL
        if (request()->isSecure()) {
            return str_replace('http://', 'https://', $url);
        }

        return $url;
    }
}