<?php

namespace App\Traits;

use Illuminate\Database\Eloquent\Builder;

trait FiltersByEmpresaSucursal
{
    public function scopeFilterByEmpresaSucursal(Builder $query)
    {
        $user = auth()->user();

        if ($user && !$user->hasRole('Super Administrador')) {
            // Solo filtrar por empresa_id si la columna existe
            if ($user->empresa_id && $this->hasColumn('empresa_id')) {
                $query->where('empresa_id', $user->empresa_id);
            }

            // Solo filtrar por sucursal_id si la columna existe
            if ($user->sucursal_id && $this->hasColumn('sucursal_id')) {
                $query->where('sucursal_id', $user->sucursal_id);
            }
        }

        return $query;
    }

    private function hasColumn($column)
    {
        return \Schema::hasColumn($this->getTable(), $column);
    }
}