<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class Review extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $fillable = [
        'producto_id',
        'user_id',
        'rating',
        'title',
        'comment',
        'approved',
        'empresa_id'
    ];

    protected $casts = [
        'rating' => 'integer',
        'approved' => 'boolean'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}