<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\FiltersByEmpresaSucursal;

class ProductoInventorySetting extends Model
{
    use HasFactory, FiltersByEmpresaSucursal;

    protected $table = 'producto_inventory_settings';

    protected $fillable = [
        'producto_id',
        'track_inventory',
        'allow_backorder',
        'inventory_policy',
        'low_stock_threshold',
        'empresa_id'
    ];

    protected $casts = [
        'track_inventory' => 'boolean',
        'allow_backorder' => 'boolean',
        'low_stock_threshold' => 'integer'
    ];

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }
}
