<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;

class Producto extends Model
{
    use HasFactory, Multitenantable;

    protected $fillable = [
        'code',
        'name',
        'price',
        'precio_bs',
        'description',
        'quantity',
        'quantity_alert',
        'status',
        'empresa_id',
        'categoria_id',
        'marca_id',
        'batch_number',
        'expiry_date',
        'requires_batch_tracking'
    ];

    protected $casts = [
        'price' => 'decimal:2',
        'precio_bs' => 'decimal:2',
        'quantity' => 'integer',
        'quantity_alert' => 'integer',
        'status' => 'boolean',
        'expiry_date' => 'date',
        'requires_batch_tracking' => 'boolean'
    ];

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function categoria()
    {
        return $this->belongsTo(Categoria::class, 'categoria_id');
    }

    public function marca()
    {
        return $this->belongsTo(Marca::class, 'marca_id');
    }

    public function detallesPedido()
    {
        return $this->hasMany(PedidoDetalle::class,'productoId');
    }

    public function images()
    {
        return $this->hasMany(Image::class);
    }

    public function featuredImage()
    {
        return $this->hasOne(Image::class)->where('featured', true);
    }

    public function variants()
    {
        return $this->hasMany(ProductoVariant::class);
    }

    public function inventorySetting()
    {
        return $this->hasOne(ProductoInventorySetting::class);
    }

    public function seo()
    {
        return $this->hasOne(ProductoSeo::class);
    }

    public function reviews()
    {
        return $this->hasMany(Review::class);
    }

    public function averageRating()
    {
        return $this->reviews()->where('approved', true)->avg('rating');
    }

    public function reviewsCount()
    {
        return $this->reviews()->where('approved', true)->count();
    }

    public function inventoryMovements()
    {
        return $this->hasMany(InventoryMovement::class);
    }

    public function latestMovements($limit = 10)
    {
        return $this->inventoryMovements()
            ->with('user')
            ->orderBy('created_at', 'desc')
            ->limit($limit);
    }
}