<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PedidoPago extends Model
{

    public $timestamps = true;

    protected $table = 'pedido_pago';
    
    protected $casts = [
        'monto' => 'decimal:2',
        'total_usd' => 'decimal:2',
        'total_bs' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];
    
    protected $fillable = [
        'pedidoId',
        'metodo_pago',
        'total_usd',
        'total_bs',
        'referencia_bancaria_id',
        'empresaId',
        'userId',
        'caja_id',
        'monto',
        'moneda',
        'referencia',
        'estado',
        'status'
    ];


    /**
     * Get the pedido that owns the PedidoPago
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function pedido()
    {
        return $this->belongsTo(Pedido::class, 'pedidoId', 'id');
    }
    
    /**
     * Get the referenciaBancaria associated with the pago
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function referenciaBancaria()
    {
        return $this->hasOne(ReferenciaBancaria::class, 'id', 'referencia_bancaria_id');
    }

    /**
     * Get the caja that owns the PedidoPago
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function caja()
    {
        return $this->belongsTo(Caja::class, 'caja_id');
    }
}