<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PedidoHistorial extends Model
{
    protected $table = 'pedido_historial';
    
    protected $fillable = [
        'pedido_id',
        'estado',
        'comentario',
        'usuario_id'
    ];
    
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime'
    ];
    
    public function pedido()
    {
        return $this->belongsTo(Pedido::class, 'pedido_id');
    }
    
    public function usuario()
    {
        return $this->belongsTo(User::class, 'usuario_id');
    }
}