<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;

class PedidoDetalle extends Model
{
    use HasFactory;
    protected $table = 'detalle_pedidos';

    protected $fillable = [
        'pedidoId',
        'productoId',
        'variant_id',
        'product_name',
        'cantidad',
        'precio_unitario',
        'subtotal',
        'empresa_id',
        'sucursal_id'
    ];

    protected $casts = [
        'cantidad' => 'integer',
        'precio_unitario' => 'decimal:2',
        'subtotal' => 'decimal:2',
    ];

    public function pedido()
    {
        return $this->belongsTo(Pedido::class);
    }

    public function producto()
    {
        return $this->belongsTo(Producto::class,'productoId');
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function variant()
    {
        return $this->belongsTo(ProductoVariant::class, 'variant_id');
    }
}
