<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;
use App\Traits\HasRegionalFormatting;

class NotaCredito extends Model
{
    use Multitenantable, HasRegionalFormatting;

    protected $table = 'notas_credito';

    protected $fillable = [
        'serie',
        'numero',
        'fecha_emision',
        'fecha_vencimiento',
        'cliente_id',
        'motivo',
        'tipo_nota_credito',
        'subtotal',
        'impuestos',
        'total',
        'estado',
        'venta_id',
        'empresa_id',
        'sucursal_id',
        'user_id'
    ];

    protected $casts = [
        'fecha_emision' => 'date',
        'fecha_vencimiento' => 'date',
        'subtotal' => 'decimal:2',
        'impuestos' => 'decimal:2',
        'total' => 'decimal:2'
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    public function venta()
    {
        return $this->belongsTo(Venta::class);
    }

    public function detalles()
    {
        return $this->hasMany(DetalleNotaCredito::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getNumeroCompletoAttribute()
    {
        return $this->serie . '-' . str_pad($this->numero, 8, '0', STR_PAD_LEFT);
    }

    public static function getTiposNotaCredito()
    {
        return [
            '1' => 'ANULACIÓN DE LA OPERACIÓN',
            '2' => 'ANULACIÓN POR ERROR EN EL RUC',
            '3' => 'CORRECCIÓN POR ERROR EN LA DESCRIPCIÓN',
            '4' => 'DESCUENTO GLOBAL',
            '5' => 'DESCUENTO POR ÍTEM',
            '6' => 'DEVOLUCIÓN TOTAL',
            '7' => 'DEVOLUCIÓN POR ÍTEM',
            '8' => 'BONIFICACIÓN',
            '9' => 'DISMINUCIÓN EN EL VALOR',
            '10' => 'OTROS CONCEPTOS',
            '11' => 'AJUSTES DE OPERACIONES DE EXPORTACIÓN',
            '12' => 'AJUSTES AFECTOS AL IVAP'
        ];
    }
}