<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class HistoricoPedido extends Model
{
    protected $table = 'historico_pedidos';
    
    protected $fillable = [
        'fecha',
        'titulo',
        'descripcion',
        'empresaId',
        'userId',
        'pedidoId'
    ];
    
    public function pedido()
    {
        return $this->belongsTo(Pedido::class, 'pedidoId');
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'userId');
    }
    
    public function empresa()
    {
        return $this->belongsTo(Empresa::class, 'empresaId');
    }
}