<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;
use App\Traits\HasRegionalFormatting;

class Cotizacion extends Model
{
    use Multitenantable, HasRegionalFormatting;

    protected $table = 'cotizaciones';

    protected $fillable = [
        'serie',
        'numero',
        'fecha_emision',
        'fecha_vencimiento',
        'cliente_id',
        'observaciones',
        'subtotal',
        'impuestos',
        'total',
        'estado',
        'nota_venta_id', // ID de la nota de venta generada
        'empresa_id',
        'sucursal_id',
        'user_id'
    ];

    protected $casts = [
        'fecha_emision' => 'date',
        'fecha_vencimiento' => 'date',
        'subtotal' => 'decimal:2',
        'impuestos' => 'decimal:2',
        'total' => 'decimal:2'
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    public function detalles()
    {
        return $this->hasMany(DetalleCotizacion::class);
    }

    public function notaVenta()
    {
        return $this->belongsTo(NotaVenta::class);
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getNumeroCompletoAttribute()
    {
        return $this->serie . '-' . str_pad($this->numero, 8, '0', STR_PAD_LEFT);
    }

    public static function getEstados()
    {
        return [
            'pendiente' => 'Pendiente',
            'aprobada' => 'Aprobada',
            'rechazada' => 'Rechazada',
            'vencida' => 'Vencida',
            'convertida' => 'Convertida'
        ];
    }
}
