<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Traits\Multitenantable;

class Cliente extends Model
{
    use HasFactory, Multitenantable;

    protected $fillable = [
        'nombres',
        'apellidos',
        'email',
        'telefono',
        'direccion',
        'documento_identidad',
        'empresa_id',
        'sucursal_id'
    ];

    public function pedidos()
    {
        return $this->hasMany(Pedido::class);
    }

    public function getNombreCompletoAttribute()
    {
        return $this->nombres . ' ' . $this->apellidos;
    }

    public function empresa()
    {
        return $this->belongsTo(Empresa::class);
    }

    public function sucursal()
    {
        return $this->belongsTo(Sucursal::class);
    }
}