<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CajaMovimiento extends Model
{
    use HasFactory;

    protected $fillable = [
        'caja_id',
        'user_id',
        'tipo',
        'tipo_salida',
        'monto',
        'motivo',
        'metodo_pago',
        'referencia',
        'aprobado_por',
        'ip_address',
        'user_agent',
        'motivo_rechazo',
        'estado_aprobacion',
    ];

    protected $casts = [
        'monto' => 'decimal:2',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    public function caja(): BelongsTo
    {
        return $this->belongsTo(Caja::class);
    }

    public function usuario(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    // Scope para obtener solo ingresos
    public function scopeIngresos($query)
    {
        return $query->where('tipo', 'ingreso');
    }

    // Scope para obtener solo salidas
    public function scopeSalidas($query)
    {
        return $query->where('tipo', 'salida');
    }

    // Scope para obtener movimientos por tipo de salida específico
    public function scopePorTipoSalida($query, $tipo)
    {
        return $query->where('tipo_salida', $tipo);
    }
}
