<?php

namespace App\Livewire\Front;

use Livewire\Component;
use App\Models\Producto;

class ProductSearch extends Component
{
    public $search = '';
    public $results = [];
    public $showResults = false;
    public $isSearching = false;

    protected $queryString = ['search'];

    public function updatedSearch()
    {
        if (strlen($this->search) < 2) {
            $this->results = [];
            $this->showResults = false;
            $this->isSearching = false;
            return;
        }

        $this->isSearching = true;
        $this->searchProducts();
    }

    public function searchProducts()
    {
        if (empty($this->search) || strlen($this->search) < 2) {
            $this->results = [];
            $this->showResults = false;
            $this->isSearching = false;
            return;
        }

        try {
            // Buscar productos que coincidan con el término y que estén activos con stock
            $this->results = Producto::where('activo', true)
                ->where('stock', '>', 0)
                ->where(function($query) {
                    $query->where('name', 'like', "%{$this->search}%")
                          ->orWhere('description    N   ', 'like', "%{$this->search}%")
                          ->orWhere('code', 'like', "%{$this->search}%");
                })
                ->limit(8)
                ->get(['id', 'name', 'code', 'precio_venta', 'imagen', 'stock']);

            $this->showResults = true;
        } catch (\Exception $e) {
            $this->results = [];
            $this->showResults = false;
            \Log::error('Error en búsqueda de productos: ' . $e->getMessage());
        } finally {
            $this->isSearching = false;
        }
    }

    public function selectProduct($productId)
    {
        $this->redirect('/front/product/' . $productId);
    }

    public function clearSearch()
    {
        $this->search = '';
        $this->results = [];
        $this->showResults = false;
        $this->isSearching = false;
    }

    public function render()
    {
        return view('livewire.front.product-search');
    }
}