<?php

namespace App\Livewire\Front\Pedido;

use App\Models\Pedido;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\WithPagination;

class Historico extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';
    
    public $search = '';
    public $status = '';
    public $sortBy = 'created_at';
    public $sortDirection = 'desc';

    protected $updatesQueryString = [
        'search',
        'status',
        'page'
    ];

    public function mount()
    {
        $this->fill(request()->only(['search', 'status', 'page']));
    }

    public function updatingSearch()
    {
        $this->resetPage();
    }

    public function updatingStatus()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        if ($this->sortBy === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection = 'asc';
        }

        $this->sortBy = $field;
    }

    public function render()
    {
        $query = Pedido::where('userId', Auth::id())
            ->with(['detalles', 'referenciaBancaria.banco']);

        // Aplicar búsqueda
        if (!empty($this->search)) {
            $query->where(function($q) {
                $q->where('codigo', 'like', '%' . $this->search . '%')
                  ->orWhere('metodo_pago', 'like', '%' . $this->search . '%')
                  ->orWhere('estado', 'like', '%' . $this->search . '%');
            });
        }

        // Aplicar filtro de estado
        if (!empty($this->status)) {
            $query->where('estado', $this->status);
        }

        // Aplicar ordenamiento
        $query->orderBy($this->sortBy, $this->sortDirection);

        $pedidos = $query->paginate(10);

        // Estadísticas
        $totalPedidos = Pedido::where('userId', Auth::id())->count();
        $pendientes = Pedido::where('userId', Auth::id())->where('estado', 'Pendiente')->count();
        $entregados = Pedido::where('userId', Auth::id())->where('estado', 'Entregado')->count();
        $totalGastado = Pedido::where('userId', Auth::id())->sum('total_usd');

        return view('livewire.front.pedido.historico', [
            'pedidos' => $pedidos,
            'totalPedidos' => $totalPedidos,
            'pendientes' => $pendientes,
            'entregados' => $entregados,
            'totalGastado' => $totalGastado
        ])->layout('layouts.front.app');
    }
    
    public function resetFilters()
    {
        $this->search = '';
        $this->status = '';
        $this->resetPage();
    }
}