<?php

namespace App\Livewire\Front;

use App\Models\Wishlist;
use Livewire\Component;
use Livewire\Attributes\On;

class MiniWishlist extends Component
{
    public $wishlistItems = [];
    public $wishlistCount = 0;

    public function mount()
    {
        $this->loadWishlist();
    }

    #[On('reloadWhislist')]
    public function loadWishlist()
    {
        if (auth()->check()) {
            $this->wishlistItems = Wishlist::with('producto.images')
                ->where('user_id', auth()->id())
                ->get();
            $this->wishlistCount = $this->wishlistItems->count();
        }
    }

    public function removeItem($id)
    {
        Wishlist::find($id)->delete();
        $this->loadWishlist();
        
        $this->dispatch('alert', [
            'title' => '¡Producto eliminado!',
            'text' => 'El producto ha sido eliminado de favoritos',
            'icon' => 'success',
        ]);
    }

    public function render()
    {
        return view('livewire.front.mini-wishlist');
    }
}