<?php

namespace App\Livewire\Front\Cart;

use App\Models\Cart;
use App\Models\Empleado;
use App\Models\Pedido;
use App\Models\Producto;
use App\Services\WhatsAppService;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class Detalle extends Component
{

    public $pedido;
    public $metodo_pago;
    public $ubicacion;
    public $longitud;
    public $latitud;

    function mount($pedido)
    {
        $this->pedido = \App\Models\Pedido::find($pedido->id);
        $this->metodo_pago = $this->pedido->metodo_pago;
        $this->ubicacion = $this->pedido->ubicacion;
        $this->longitud = $this->pedido->longitud;
        $this->latitud = $this->pedido->latitud;
        Cart::clear();
    }

    public function render()
    {
        return view('livewire.front.cart.detalle')
            ->layout('layouts.front.app');
    }

    function cancel($id)
    {
        $pedido = Pedido::find($id);
        $pedido->estado = 'Cancelar';
        $pedido->save();

        $this->dispatch('alert', [
            'title' => '¡Bien hecho!',
            'text'  => '¡Pedido cancelado satisfactoriamente!',
            'icon'  => 'success',
        ]);
        return redirect('front/pedido/detalle/' . $pedido->codigo);
    }
    
    function empaquetado($id)
    {
        $pedido = Pedido::find($id);
        $pedido->estado = 'Entregado';
        $pedido->save();

        $empleado = Empleado::find(Auth::user()->empleadoId);
        $empleado->status = 1;
        $empleado->save();

        foreach ($pedido->detalles as $key => $value) {
            $producto = Producto::find($value->productoId);
            $producto->quantity -= $value->quantity;
            $producto->save();
        }

        $this->dispatch('alert', [
            'title' => '¡Bien hecho!',
            'text'  => '¡Pedido Entregado satisfactoriamente!',
            'icon'  => 'success',
        ]);
        return redirect('admin/dashboard');
    }
    
    public function contactarPorWhatsApp()
    {
        // Obtener el número de teléfono del pedido (debe estar almacenado en la base de datos)
        $numero = $this->pedido->cliente->telefono ?? null;
        
        if (!$numero) {
            $this->dispatch('alert', [
                'title' => 'Error',
                'text'  => 'No se encontró un número de teléfono para este pedido',
                'icon'  => 'error',
            ]);
            return;
        }
        
        // Limpiar el número (eliminar espacios, paréntesis, guiones, etc.)
        $numero = preg_replace('/[^0-9]/', '', $numero);
        
        $whatsappService = new WhatsAppService();
        $mensaje = "Hola {$this->pedido->cliente->name}, tengo una consulta sobre tu pedido #{$this->pedido->codigo}. ¿En qué puedo ayudarte?";
        
        $resultado = $whatsappService->sendMessage($numero, $mensaje);
        
        if ($resultado['success']) {
            $this->dispatch('alert', [
                'title' => '¡Éxito!',
                'text'  => 'Mensaje enviado correctamente',
                'icon'  => 'success',
            ]);
        } else {
            // Manejar específicamente el error de sesión cerrada
            if (isset($resultado['error']) && strpos($resultado['error'], 'sesión de WhatsApp ha sido cerrada') !== false) {
                $this->dispatch('alert', [
                    'title' => 'Sesión cerrada',
                    'text'  => 'La sesión de WhatsApp ha sido cerrada. Por favor, reinicia la API de WhatsApp y escanea el código QR.',
                    'icon'  => 'warning',
                ]);
            } 
            // Manejar errores de conexión con la API
            else if (isset($resultado['error']) && strpos($resultado['error'], 'Error de conexión con la API de WhatsApp') !== false) {
                $this->dispatch('alert', [
                    'title' => 'Error de conexión',
                    'text'  => 'No se puede conectar con la API de WhatsApp. Por favor, asegúrate de que la API esté en ejecución.',
                    'icon'  => 'error',
                ]);
            }
            else {
                $this->dispatch('alert', [
                    'title' => 'Error',
                    'text'  => 'No se pudo enviar el mensaje: ' . $resultado['error'],
                    'icon'  => 'error',
                ]);
            }
        }
    }
}
