<?php

namespace App\Livewire\Components;

use Livewire\Component;
use App\Models\Producto;

class ProductComparison extends Component
{
    public $compareProducts = [];
    public $showComparison = false;
    
    protected $listeners = ['productAdded' => 'addProduct'];

    public function mount()
    {
        $this->compareProducts = session('compare_products', []);
    }

    public function addProduct($productId)
    {
        if (count($this->compareProducts) >= 3) {
            $this->dispatch('notify', message: 'Máximo 3 productos para comparar', type: 'warning');
            return;
        }
        
        if (!in_array($productId, $this->compareProducts)) {
            $this->compareProducts[] = $productId;
            session(['compare_products' => $this->compareProducts]);
            $this->dispatch('notify', message: 'Producto añadido a comparación', type: 'success');
        }
    }

    public function removeProduct($productId)
    {
        $this->compareProducts = array_values(array_filter($this->compareProducts, fn($id) => $id != $productId));
        session(['compare_products' => $this->compareProducts]);
    }

    public function toggleComparison()
    {
        $this->showComparison = !$this->showComparison;
    }

    public function clearAll()
    {
        $this->compareProducts = [];
        session()->forget('compare_products');
        $this->showComparison = false;
    }

    public function getProductsProperty()
    {
        return Producto::whereIn('id', $this->compareProducts)->get();
    }

    public function render()
    {
        return view('livewire.components.product-comparison');
    }
}