<?php

namespace App\Livewire\Admin\Users\Profile;

use App\Traits\HasDynamicLayout;
use Livewire\Component;
use App\Models\User;
use App\Models\Pedido;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Auth;

class HistoryUser extends Component
{
    use HasDynamicLayout, WithPagination;

    public $user_id;
    public $user;
    public $filter = 'all';

    public function mount($user_id)
    {
        $this->user_id = $user_id;
        $this->user = User::findOrFail($user_id);
    }

    public function setFilter($filter)
    {
        $this->filter = $filter;
        $this->resetPage();
    }

    public function getActivityHistory()
    {
        $empleado = \App\Models\Empleado::where('user_id', $this->user_id)->first();
        
        $query = Pedido::query();
        
        if ($empleado) {
            $query->whereHas('empleados', function($q) use ($empleado) {
                $q->where('empleadoId', $empleado->id);
            });
        } else {
            // If no employee, return empty paginated result
            $query->where('id', -1);
        }
        
        $query->with(['detalles.producto']);
        
        if ($this->filter !== 'all') {
            $query->where('estado', $this->filter);
        }
        
        return $query->orderBy('created_at', 'desc')->paginate(10);
    }

    public function render()
    {
        return $this->renderWithLayout('livewire.admin.users.profile.history-user', [
            'activities' => $this->getActivityHistory()
        ], [
            'title' => 'Historial de Usuario',
            'breadcrumb' => [
                'admin.dashboard' => 'Dashboard',
                'admin.users.profile' => 'Mi Perfil',
                'admin.users.history' => 'Historial'
            ]
        ]);
    }
}




