<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Pedido;
use Illuminate\Support\Facades\Auth;

class RealTimeNotifications extends Component
{
    public $pendingOrders = [];
    public $lastCheck;

    public function mount()
    {
        $this->loadPendingOrders();
        $this->lastCheck = now();
    }

    public function loadPendingOrders()
    {
        $user = Auth::user();
        $empresaId = $user->empresa_id;

        $query = Pedido::where('empresaId', $empresaId)
            ->where('estado', 'Pendiente')
            ->with(['user', 'detalles.producto'])
            ->orderBy('created_at', 'desc');

        // Si el usuario es empleado, filtrar solo pedidos asignados
        if ($user->hasRole('Empleado') && $user->empleado) {
            $query->whereHas('empleados', function($q) use ($user) {
                $q->where('empleadoId', $user->empleado->id);
            });
        }

        $this->pendingOrders = $query->get();
    }

    public function checkForUpdates()
    {
        $this->loadPendingOrders();
        $this->lastCheck = now();
    }

    public function render()
    {
        return view('livewire.admin.real-time-notifications');
    }
}