<?php

namespace App\Livewire\Admin\NotasCredito;

use Livewire\Component;
use App\Models\NotaCredito;
use App\Traits\HasDynamicLayout;
use App\Traits\HasRegionalFormatting;

class Show extends Component
{
    use HasDynamicLayout, HasRegionalFormatting;
    public NotaCredito $notaCredito;

    public function mount(NotaCredito $notaCredito)
    {
        $this->notaCredito = $notaCredito->load([
            'cliente', 
            'venta.detalles.producto', 
            'detalles.producto',
            'user',
            'empresa',
            'sucursal'
        ]);
    }

    public function render()
    {
        $tiposNotaCredito = NotaCredito::getTiposNotaCredito();
        
        return view('livewire.admin.notas-credito.show', [
            'tiposNotaCredito' => $tiposNotaCredito
        ])->layout($this->getLayout());
    }
}