<?php

namespace App\Livewire\Admin\Marcas;

use Livewire\Component;
use App\Models\Marca;
use App\Traits\HasDynamicLayout;

class Create extends Component
{
    use HasDynamicLayout;

    public $nombre;
    public $descripcion;
    public $activo = true;

    protected $rules = [
        'nombre' => 'required|string|max:255|unique:marcas,nombre',
        'descripcion' => 'nullable|string|max:1000',
        'activo' => 'boolean'
    ];

    protected $messages = [
        'nombre.required' => 'El nombre de la marca es obligatorio.',
        'nombre.unique' => 'Ya existe una marca con este nombre.',
        'nombre.max' => 'El nombre no puede exceder 255 caracteres.',
        'descripcion.max' => 'La descripción no puede exceder 1000 caracteres.'
    ];

    public function save()
    {
        $this->validate();

        Marca::create([
            'nombre' => $this->nombre,
            'descripcion' => $this->descripcion,
            'activo' => $this->activo,
            'empresa_id' => auth()->user()->empresa_id,
            'sucursal_id' => auth()->user()->sucursal_id,
        ]);

        $this->dispatch('notify', ['message' => 'Marca creada correctamente.', 'type' => 'success']);

        return redirect()->route('admin.marcas.index');
    }

    public function render()
    {
        return view('livewire.admin.marcas.create')->layout($this->getLayout(), [
            'title' => 'Creación de Marcas',
            'breadcrumb' => [
                ['name' => 'Dashboard', 'route' => 'admin.dashboard'],
                ['name' => 'Marcas', 'route' => 'admin.marcas.index'],
                ['name' => 'Crear', 'active' => true]
            ]
        ]);
    }
}
