<?php

namespace App\Livewire\Admin\Empleados;

use App\Models\Empleado;
use App\Traits\HasDynamicLayout;
use Livewire\Component;

class Show extends Component
{
    use HasDynamicLayout;
    public Empleado $empleado;

    public function mount(Empleado $empleado)
    {
        $this->empleado = $empleado->load(['empresa', 'sucursal']);
    }

    public function render()
    {
        return $this->renderWithLayout('livewire.admin.empleados.show');
    }
}