<?php

namespace App\Livewire\Admin\Empleados;

use Livewire\Component;
use App\Models\Pedido;
use Illuminate\Support\Facades\Auth;

class OrderNotifications extends Component
{
    public $pendingOrdersCount = 0;
    public $recentOrders = [];
    
    protected $listeners = ['echo:pedidos,PedidoActualizado' => 'handleOrderUpdate'];

    public function mount()
    {
        $this->loadPendingOrdersCount();
        $this->loadRecentOrders();
    }
    
    public function handleOrderUpdate($data)
    {
        // Actualizar contador de pedidos pendientes
        $this->loadPendingOrdersCount();
        
        // Actualizar lista de pedidos recientes
        $this->loadRecentOrders();
        
        // Emitir evento para mostrar notificación
        $this->dispatch('show-notification', [
            'title' => 'Pedido Actualizado',
            'message' => $data['accion'] . ' pedido #' . $data['pedido']['codigo'],
            'type' => 'info'
        ]);
    }
    
    private function loadPendingOrdersCount()
    {
        $userId = Auth::id();
        $empresaId = Auth::user()->empresa_id;
        
        $this->pendingOrdersCount = Pedido::where('empresaId', $empresaId)
            ->whereHas('empleados', function($query) use ($userId) {
                $query->where('user_id', $userId);
            })
            ->where('estado', 'Pendiente')
            ->count();
    }
    
    private function loadRecentOrders()
    {
        $userId = Auth::id();
        $empleado = \DB::table('empleados')->where('user_id', $userId)->first();

        if (!$empleado) {
            $this->recentOrders = collect();
            return;
        }

        $this->recentOrders = Pedido::where('empresaId', Auth::user()->empresa_id)
            ->whereHas('empleados', function($query) use ($empleado) {
                $query->where('empleadoId', $empleado->id);
            })
            ->with(['user', 'detalles.producto'])
            ->orderBy('created_at', 'desc')
            ->limit(3)
            ->get();
    }
    
    public function render()
    {
        return view('livewire.admin.empleados.order-notifications');
    }
}