<?php

namespace App\Livewire\Admin\Categorias;

use App\Models\Categoria;
use Livewire\Component;
use App\Traits\HasDynamicLayout;

class Create extends Component
{
    use HasDynamicLayout;

    public $nombre;
    public $descripcion;
    public $activo = true;

    protected $rules = [
        'nombre' => 'required|string|max:255|unique:categorias,nombre',
        'descripcion' => 'nullable|string|max:500',
        'activo' => 'boolean'
    ];

    public function save()
    {
        $this->validate();

        Categoria::create([
            'nombre' => $this->nombre,
            'descripcion' => $this->descripcion,
            'activo' => $this->activo,
            'empresa_id' => auth()->user()->empresa_id,
            'sucursal_id' => auth()->user()->sucursal_id
        ]);

        $this->dispatch('notify', ['message' => 'Categoría creada correctamente.', 'type' => 'success']);
        return redirect()->route('admin.categorias.index');
    }

    public function render()
    {
        return view('livewire.admin.categorias.create')
            ->layout($this->getLayout(), [
                'title' => 'Crear Categoría',
                'breadcrumb' => [
                    ['name' => 'Dashboard', 'route' => 'admin.dashboard'],
                    ['name' => 'Categorías', 'route' => 'admin.categorias.index'],
                    ['name' => 'Crear', 'active' => true]
                ]
            ]);
    }
}
