<?php

namespace App\Livewire\Admin\Cajas;

use App\Models\Caja;
use App\Models\ExchangeRate;
use App\Services\CajaTasaConfigService;
use Livewire\Component;
use Livewire\Attributes\On;

class CajaTasaStatusWidget extends Component
{
    public $config;
    public $tasaHoy;
    public $cajasAbiertas;
    public $proximoCorte;
    public $tiempoProximoCorte;
    public $estadoVerificacion;
    public $estadoActualizacion;
    
    public function mount()
    {
        $this->actualizarDatos();
    }

    #[On('actualizar-cajatasa-status')]
    public function actualizarDatos()
    {
        $this->config = CajaTasaConfigService::getConfiguracionActual();
        $this->tasaHoy = ExchangeRate::getTodayRate();
        $this->cajasAbiertas = Caja::where('estado', 'abierta')->count();
        $this->proximoCorte = CajaTasaConfigService::getProximoCorteCaja();
        $this->tiempoProximoCorte = $this->proximoCorte ? now()->diffForHumans($this->proximoCorte, true) : null;
        $this->estadoVerificacion = CajaTasaConfigService::enPeriodoVerificacionTasa();
        $this->estadoActualizacion = CajaTasaConfigService::esHoraActualizacionTasa();
    }

    public function ejecutarActualizacionTasa()
    {
        try {
            $automationService = app(\App\Services\CajaTasaAutomationService::class);
            $resultado = $automationService->actualizarTasaAutomatica(true);
            
            if ($resultado['success']) {
                session()->flash('message', 'Tasa actualizada exitosamente');
                session()->flash('message-type', 'success');
            } else {
                session()->flash('message', 'Error al actualizar tasa: ' . $resultado['message']);
                session()->flash('message-type', 'danger');
            }
        } catch (\Exception $e) {
            session()->flash('message', 'Error: ' . $e->getMessage());
            session()->flash('message-type', 'danger');
        }
        
        $this->actualizarDatos();
    }

    public function ejecutarCorteCaja()
    {
        try {
            $automationService = app(\App\Services\CajaTasaAutomationService::class);
            $resultado = $automationService->ejecutarCorteCajaAutomatico(null, null, true);
            
            if ($resultado['success']) {
                session()->flash('message', 'Corte de caja ejecutado exitosamente');
                session()->flash('message-type', 'success');
            } else {
                session()->flash('message', 'Error en corte de caja: ' . $resultado['message']);
                session()->flash('message-type', 'danger');
            }
        } catch (\Exception $e) {
            session()->flash('message', 'Error: ' . $e->getMessage());
            session()->flash('message-type', 'danger');
        }
        
        $this->actualizarDatos();
    }

    public function render()
    {
        return view('livewire.admin.cajas.caja-tasa-status-widget');
    }
}