<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use App\Services\WhatsAppService;

class SendPasswordResetWhatsApp implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public $tries = 3;
    public $backoff = [10, 30, 60];

    protected $user;
    protected $newPassword;

    public function __construct($user, $newPassword)
    {
        $this->user = $user;
        $this->newPassword = $newPassword;
    }

    public function handle()
    {
        $whatsappService = new WhatsAppService();
        $telefonoFormateado = $whatsappService->cleanPhoneNumber($this->user->telefono);
        
        $message = "🔐 *Nueva Contraseña*\n\n";
        $message .= "Hola {$this->user->name}!\n\n";
        $message .= "Tu nueva contraseña es: *{$this->newPassword}*\n\n";
        $message .= "Por seguridad, te recomendamos cambiarla después de iniciar sesión.\n\n";
        $message .= "¡Gracias por usar nuestros servicios!";
        
        $whatsappService->sendMessage($telefonoFormateado, $message);
    }
}