<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class PedidoPermissions
{
    public function handle(Request $request, Closure $next, string $permission)
    {
        $user = auth()->user();
        
        // Super admin tiene acceso total
        if ($user->hasRole('Super Administrador')) {
            return $next($request);
        }
        
        // Verificar permisos específicos
        if (!$user->can($permission)) {
            abort(403, 'No tienes permisos para realizar esta acción.');
        }
        
        return $next($request);
    }
}