<?php

namespace App\Helpers;

use Illuminate\Support\Facades\Storage;

class ImageHelper
{
    public static function getImageUrl($path)
    {
        if (!$path) {
            return null;
        }

        // Si estamos en HTTPS, forzar HTTPS en las URLs de Storage
        if (request()->isSecure()) {
            return str_replace('http://', 'https://', Storage::url($path));
        }

        return Storage::url($path);
    }
}