<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Empresa;

class VerificarEmpresa extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:verificar-empresa';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Verificar configuración de empresa y país';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $empresa = Empresa::with('pais')->first();

        if ($empresa) {
            $this->info('Empresa: ' . $empresa->nombre);
            $this->info('País: ' . $empresa->pais->nombre);
            $this->info('Símbolo de moneda: ' . $empresa->pais->simbolo_moneda);
            $this->info('Moneda principal: ' . $empresa->pais->moneda_principal);
        } else {
            $this->error('No se encontró ninguna empresa');
        }
    }
}
