<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use App\Jobs\SendWelcomeWhatsAppMessage;
use App\Services\TemporaryTokenService;

class TestWelcomeWhatsApp extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'test:welcome-whatsapp {phone?} {name?}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Probar el envío de mensaje de bienvenida por WhatsApp';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $phone = $this->argument('phone') ?? '584142885159';
        $name = $this->argument('name') ?? 'Usuario de Prueba';
        
        $this->info("Probar mensaje de bienvenida a: {$phone}");
        
        // Crear usuario de prueba
        $user = User::firstOrCreate([
            'telefono' => $phone
        ], [
            'name' => $name,
            'username' => 'test_' . time(),
            'email' => 'test_' . time() . '@test.com',
            'password' => bcrypt('test123'),
            'email_verified_at' => now()
        ]);
        
        // Crear token temporal
        $token = TemporaryTokenService::generateCredentialToken(
            $user->id,
            $user->username,
            'test123'
        );
        
        $this->info("Usuario creado: {$user->name} (ID: {$user->id})");
        $this->info("Token generado: {$token}");
        
        // Despachar el job a la cola whatsapp
        $this->info("Despachando job de WhatsApp...");
        SendWelcomeWhatsAppMessage::dispatch($user, $token)->onQueue('whatsapp');
        
        $this->info("Job despachado a la cola whatsapp para: {$user->telefono}");
        $this->info("Usuario: {$user->name} (ID: {$user->id})");
        $this->info("Token: {$token}");
        
        return Command::SUCCESS;
    }
}