<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;
use Tymon\JWTAuth\Facades\JWTAuth;

class GenerateServiceToken extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'jwt:generate-service-token {email}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generar un token JWT de larga duración para servicios';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $email = $this->argument('email');

        $user = User::where('email', $email)->first();

        if (!$user) {
            $this->error('Usuario no encontrado');
            return 1;
        }

        try {
            // Generar token con TTL muy largo (1 año)
            $token = JWTAuth::customClaims(['exp' => now()->addYear()->timestamp])->fromUser($user);

            $this->info('Token de servicio generado exitosamente:');
            $this->line($token);
            $this->newLine();
            $this->info('Este token expira en: ' . now()->addYear()->format('Y-m-d H:i:s'));
            $this->info('Copia este token y guárdalo de forma segura en tus variables de entorno.');

            return 0;
        } catch (\Exception $e) {
            $this->error('Error al generar token: ' . $e->getMessage());
            return 1;
        }
    }
}
