<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Illuminate\Support\Str;

class GenerateAdminApiTokensCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'api:generate-admin-tokens';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generar tokens API para usuarios Administrador y Super Administrador';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Generando tokens API para administradores...');

        // Obtener usuarios con roles Administrador o Super Administrador
        $adminUsers = User::whereHas('roles', function ($query) {
            $query->whereIn('name', ['Administrador', 'Super Administrador']);
        })->get();

        if ($adminUsers->isEmpty()) {
            $this->warn('No se encontraron usuarios con roles Administrador o Super Administrador');
            return 0;
        }

        $bar = $this->output->createProgressBar($adminUsers->count());
        $bar->start();

        $generatedCount = 0;

        foreach ($adminUsers as $user) {
            // Generar token solo si no existe
            if (empty($user->api_token)) {
                $token = Str::random(80);
                $user->api_token = $token;
                $user->save();

                $this->info("\nToken generado para {$user->name} ({$user->email}): {$token}");
                $generatedCount++;
            } else {
                $this->info("\n{$user->name} ya tiene token: {$user->api_token}");
            }

            $bar->advance();
        }

        $bar->finish();
        $this->info("\n\nProceso completado. Tokens generados: {$generatedCount} de {$adminUsers->count()} administradores.");

        return 0;
    }
}
