<?php

namespace App\Console\Commands;

use App\Services\CajaTasaAutomationService;
use App\Services\CajaTasaConfigService;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class ActualizarTasaProgramada extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'tasa:actualizar-programada {--force : Forzar actualización sin verificar horario}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Actualizar tasa de cambio según horario programado (2:30 PM)';

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        $this->info('Verificando actualización programada de tasa...');

        try {
            $force = $this->option('force');
            
            if (!$force && !CajaTasaConfigService::esHoraActualizacionTasa()) {
                $this->warn('No es hora de actualización automática (debe ser 2:30 PM)');
                $this->warn('Use --force para ejecutar de todas formas');
                return Command::SUCCESS;
            }

            $service = new CajaTasaAutomationService();
            $resultado = $service->actualizarTasaAutomaticamente();

            if ($resultado['exitoso']) {
                $this->info("✓ Tasa actualizada exitosamente");
                $this->info("  Tasa: USD = {$resultado['tasa']} Bs.");
                $this->info("  Hora: {$resultado['hora']}");
                
                Log::info('Tasa actualizada programadamente', $resultado);
            } else {
                $this->error("✗ Error: {$resultado['mensaje']}");
                Log::error('Error en actualización programada de tasa', $resultado);
            }

            return $resultado['exitoso'] ? Command::SUCCESS : Command::FAILURE;

        } catch (\Exception $e) {
            $this->error('Error crítico: ' . $e->getMessage());
            Log::error('Error crítico en actualización de tasa', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);
            
            return Command::FAILURE;
        }
    }
}