# Integración JWT con WhatsApp Service

## Resumen
El sistema de autenticación JWT ha sido implementado exitosamente en Laravel. Ahora puedes generar tokens JWT para autenticar tus servicios.

## Endpoints JWT Disponibles

### 1. Login
```
POST http://pedidos.test/api/auth/login
Content-Type: application/json

{
    "email": "superadmin@devtechvnzla.com",
    "password": "admin123"
}
```

### 2. Verificar Token
```
POST http://pedidos.test/api/verify-token
Authorization: Bearer {token}
Content-Type: application/json
```

### 3. Obtener Usuario Actual
```
POST http://pedidos.test/api/auth/me
Authorization: Bearer {token}
Content-Type: application/json
```

### 4. Cerrar Sesión
```
POST http://pedidos.test/api/auth/logout
Authorization: Bearer {token}
Content-Type: application/json
```

### 5. Refrescar Token
```
POST http://pedidos.test/api/auth/refresh
Authorization: Bearer {token}
Content-Type: application/json
```

## Token de Servicio Generado

Se ha generado un token de servicio de larga duración (1 año):

```
eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwMDAiLCJpYXQiOjE3NjQxODU5MDgsImV4cCI6MTc5NTcyMTkwOCwibmJmIjoxNzY0MTg1OTA4LCJqdGkiOiJzcGY0QlZQNVJCeHRva0l0Iiwic3ViIjoiMSIsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ.bAF0jL9iyun1Jjq8Zswmgyde0KFrGPaY40AStidYOJc
```

**Fecha de expiración:** 2026-11-26 15:38:28

## Configuración del Servicio WhatsApp

Actualiza tu archivo `.env` del servicio WhatsApp con:

```env
LARAVEL_URL=http://pedidos.test
LARAVEL_VERIFY_ENDPOINT=http://pedidos.test/api/verify-token
LARAVEL_API_KEY=eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpc3MiOiJodHRwOi8vbG9jYWxob3N0OjgwMDAiLCJpYXQiOjE3NjQxODU5MDgsImV4cCI6MTc5NTcyMTkwOCwibmJmIjoxNzY0MTg1OTA4LCJqdGkiOiJzcGY0QlZQNVJCeHRva0l0Iiwic3ViIjoiMSIsInBydiI6IjIzYmQ1Yzg5NDlmNjAwYWRiMzllNzAxYzQwMDg3MmRiN2E1OTc2ZjcifQ.bAF0jL9iyun1Jjq8Zswmgyde0KFrGPaY40AStidYOJc
```

## Generar Nuevos Tokens de Servicio

Para generar un nuevo token de servicio, usa:

```bash
php artisan jwt:generate-service-token superadmin@devtechvnzla.com
```

## Notas de Seguridad

1. **Nunca compartas tokens en repositorios públicos**
2. **Rota los tokens regularmente**
3. **Usa HTTPS en producción**
4. **Configura TTL apropiados según tu caso de uso**
5. **Almacena tokens de forma segura**

## Pruebas Realizadas

✅ Login con credenciales válidas  
✅ Generación de tokens JWT  
✅ Verificación de tokens  
✅ Refresh de tokens  
✅ Cierre de sesión  
✅ Integración con middleware  

El sistema JWT está completamente funcional y listo para usar.
