# Sistema de Pedidos - Guía de Instalación

## Requisitos del Sistema

- PHP 8.1 o superior
- Composer
- MySQL 5.7 o superior
- Node.js 16+ y NPM
- Servidor web (Apache/Nginx) o Laragon/XAMPP

## Instalación Paso a Paso

### 1. Clonar el Repositorio
```bash
git clone [URL_DEL_REPOSITORIO]
cd pedidos
```

### 2. Instalar Dependencias PHP
```bash
composer install
```

### 3. Configurar Variables de Entorno
```bash
cp .env.example .env
```

Editar el archivo `.env` con tu configuración:
```env
APP_NAME="Sistema de Pedidos"
APP_ENV=local
APP_KEY=
APP_DEBUG=true
APP_URL=http://localhost

DB_CONNECTION=mysql
DB_HOST=127.0.0.1
DB_PORT=3306
DB_DATABASE=pedidos
DB_USERNAME=root
DB_PASSWORD=

# WhatsApp API (Opcional)
WHATSAPP_API_URL=
WHATSAPP_API_TOKEN=

# Configuración de Archivos
FILESYSTEM_DISK=public
```

### 4. Generar Clave de Aplicación
```bash
php artisan key:generate
```

### 5. Crear Base de Datos
Crear una base de datos MySQL llamada `pedidos`

### 6. Ejecutar Migraciones y Seeders
```bash
php artisan migrate --seed
```

### 7. Crear Enlace Simbólico para Storage
```bash
php artisan storage:link
```

### 8. Instalar Dependencias Frontend
```bash
npm install
npm run build
```

### 9. Configurar Permisos (Linux/Mac)
```bash
chmod -R 775 storage bootstrap/cache
```

### 10. Iniciar el Servidor
```bash
php artisan serve
```

El sistema estará disponible en: `http://localhost:8000`

## Configuración Inicial

### Acceso Administrativo
- **URL**: `/admin`
- **Usuario**: admin@admin.com
- **Contraseña**: password

### Configuración de la Empresa
1. Ir a **Configuración > Empresa**
2. Completar datos de la empresa
3. Configurar país y moneda
4. Subir logo (opcional)

### Configuración de WhatsApp (Opcional)
1. Obtener credenciales de API de WhatsApp
2. Configurar en `.env`
3. Probar conexión en **Configuración > WhatsApp**

## Comandos Útiles

### Limpiar Cache
```bash
php artisan cache:clear
php artisan config:clear
php artisan view:clear
```

### Limpiar Archivos Temporales
```bash
php artisan cleanup:temp-files
```

### Actualizar Tasas de Cambio (Venezuela)
```bash
php artisan exchange:fetch
```

### Procesar Cola de Trabajos
```bash
php artisan queue:work
```

## Estructura del Proyecto

```
pedidos/
├── app/
│   ├── Livewire/          # Componentes Livewire
│   ├── Models/            # Modelos Eloquent
│   ├── Services/          # Servicios de negocio
│   └── Jobs/              # Trabajos en cola
├── resources/
│   ├── views/             # Vistas Blade
│   └── js/                # Assets JavaScript
├── public/
│   └── app/               # Archivos subidos
└── database/
    ├── migrations/        # Migraciones
    └── seeders/           # Datos iniciales
```

## Funcionalidades Principales

- ✅ Gestión de productos con variantes
- ✅ Sistema de pedidos completo
- ✅ Integración WhatsApp
- ✅ Múltiples monedas (USD/VES)
- ✅ Panel administrativo
- ✅ Tienda online
- ✅ Sistema de usuarios y roles
- ✅ Reportes y estadísticas

## Solución de Problemas

### Error de Permisos
```bash
sudo chown -R www-data:www-data storage bootstrap/cache
```

### Error de Base de Datos
- Verificar credenciales en `.env`
- Asegurar que MySQL esté ejecutándose
- Crear la base de datos manualmente

### Error de Storage Link
```bash
rm public/storage
php artisan storage:link
```

### Problemas con WhatsApp
- Verificar credenciales de API
- Revisar logs en `storage/logs/laravel.log`
- Probar conexión con: `php artisan whatsapp:test`

## Soporte

Para soporte técnico o reportar problemas, contactar al equipo de desarrollo.